/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.ActRedisManager;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.atom.ActUpdateGroupActiveStockAtomService;
import com.tydic.active.app.atom.bo.ActUpdateGroupActiveStockAtomReqBO;
import com.tydic.active.app.atom.bo.ActUpdateGroupActiveStockAtomRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActUpdateGroupActiveStockAtomServiceImpl
implements ActUpdateGroupActiveStockAtomService {
    @Autowired
    private ActRedisManager cacheManager;
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Value(value="${IS_OCCUPY_STOCK}")
    private boolean isOccupyStock;
    @Value(value="${STOCK_HANDLE_MODE}")
    private Byte stockHandleMode;

    @Override
    public ActUpdateGroupActiveStockAtomRspBO updateGroupActiveStock(ActUpdateGroupActiveStockAtomReqBO atomReqBO) {
        ActUpdateGroupActiveStockAtomRspBO rsp = new ActUpdateGroupActiveStockAtomRspBO();
        if (ActCommConstant.GroupActiveStockOperateType.OCCUPY_STOCK.equals(atomReqBO.getStockOperType())) {
            this.processOccupyStock(atomReqBO, rsp);
        } else if (ActCommConstant.GroupActiveStockOperateType.OUT_STOCK.equals(atomReqBO.getStockOperType())) {
            this.processOutStock(atomReqBO, rsp);
        } else if (ActCommConstant.GroupActiveStockOperateType.INSERT_STOCK.equals(atomReqBO.getStockOperType())) {
            this.processInsertStock(atomReqBO, rsp);
        } else if (ActCommConstant.GroupActiveStockOperateType.UN_OCCUPY_STOCK.equals(atomReqBO.getStockOperType())) {
            this.processUnOcuppyStock(atomReqBO, rsp);
        }
        return rsp;
    }

    private void processOccupyStock(ActUpdateGroupActiveStockAtomReqBO atomReqBO, ActUpdateGroupActiveStockAtomRspBO rsp) {
        if (ActCommConstant.GroupActiveOperType.OPENING_A_REGIMENT.equals(atomReqBO.getGroupActiveOperType())) {
            Long groupInstId = Sequence.getInstance().nextId();
            String memLockRedisKey = this.getRedisKey(atomReqBO.getActiveId(), groupInstId, 1);
            this.cacheManager.incrByCount(memLockRedisKey, 1L);
            rsp.setGroupInstId(groupInstId);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5360\u5e93\u6210\u529f\uff01");
        } else {
            Integer finalMemNum = this.getActGroupActiveInst(atomReqBO.getGroupInstId());
            Integer lockMemNum = this.getLockMemNum(atomReqBO);
            Integer groupMenNum = this.getGroupMenNum(atomReqBO);
            if (lockMemNum + groupMenNum < finalMemNum) {
                String memLockRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 1);
                this.cacheManager.incrByCount(memLockRedisKey, 1L);
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u5360\u5e93\u6210\u529f\uff01");
            } else {
                rsp.setRespCode("14024");
                rsp.setRespDesc("\u5360\u5e93\u5931\u8d25\uff01\uff0c\u4eba\u6570\u5df2\u6ee1\uff01");
            }
        }
    }

    private void processOutStock(ActUpdateGroupActiveStockAtomReqBO atomReqBO, ActUpdateGroupActiveStockAtomRspBO rsp) {
        if (this.isOccupyStock) {
            String memLockRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 1);
            this.cacheManager.decrByCount(memLockRedisKey, 1L);
            String groupMenNumRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 2);
            this.cacheManager.incrByCount(groupMenNumRedisKey, 1L);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5165\u5e93\u6210\u529f\uff01");
        } else {
            Integer finalMemNum = this.getActGroupActiveInst(atomReqBO.getGroupInstId());
            Integer groupMenNum = this.getGroupMenNum(atomReqBO);
            if (groupMenNum >= finalMemNum) {
                if (ActCommConstant.StockHandleMode.FULL_CREATE_NEW.equals(this.stockHandleMode)) {
                    Long groupInstId = Sequence.getInstance().nextId();
                    String groupMenNumRedisKey = this.getRedisKey(atomReqBO.getActiveId(), groupInstId, 2);
                    this.cacheManager.incrByCount(groupMenNumRedisKey, 1L);
                    rsp.setGroupInstId(groupInstId);
                    rsp.setIsFullCreateNewGroup(true);
                    rsp.setRespCode("0000");
                    rsp.setRespDesc("\u4eba\u6570\u5df2\u6ee1\uff0c\u5f00\u65b0\u56e2\uff01");
                } else {
                    rsp.setRespCode("14024");
                    rsp.setRespDesc("\u51fa\u5e93\u5931\u8d25\uff01\uff0c\u4eba\u6570\u5df2\u6ee1\uff01");
                }
            } else {
                String groupMenNumRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 2);
                this.cacheManager.incrByCount(groupMenNumRedisKey, 1L);
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u5165\u5e93\u6210\u529f\uff01");
            }
        }
    }

    private void processInsertStock(ActUpdateGroupActiveStockAtomReqBO atomReqBO, ActUpdateGroupActiveStockAtomRspBO rsp) {
        String groupMenNumRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 2);
        this.cacheManager.decrByCount(groupMenNumRedisKey, 1L);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u51fa\u5e93\u6210\u529f\uff01");
    }

    private void processUnOcuppyStock(ActUpdateGroupActiveStockAtomReqBO atomReqBO, ActUpdateGroupActiveStockAtomRspBO rsp) {
        String memLockRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 1);
        this.cacheManager.decrByCount(memLockRedisKey, 1L);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u89e3\u5360\u5e93\u6210\u529f\uff01");
    }

    private String getRedisKey(Long activeId, Long groupInstId, int type) {
        String redisKey = "";
        if (type == 1) {
            redisKey = "LOCK_TOTAL_" + activeId + "_" + groupInstId;
        } else if (type == 2) {
            redisKey = "SALES_TOTAL_" + activeId + "_" + groupInstId;
        }
        return redisKey;
    }

    private Integer getGroupMenNum(ActUpdateGroupActiveStockAtomReqBO atomReqBO) {
        String groupMenNumRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 2);
        Long groupMenNum = this.cacheManager.incrByCount(groupMenNumRedisKey, 0L);
        return groupMenNum.intValue();
    }

    private Integer getLockMemNum(ActUpdateGroupActiveStockAtomReqBO atomReqBO) {
        String memLockRedisKey = this.getRedisKey(atomReqBO.getActiveId(), atomReqBO.getGroupInstId(), 1);
        Long lockMemNum = this.cacheManager.incrByCount(memLockRedisKey, 0L);
        return lockMemNum.intValue();
    }

    private Integer getActGroupActiveInst(Long groupInstId) {
        ActGroupActiveInstPO actGroupActiveInstPO = this.actGroupActiveInstMapper.selectByPrimaryKey(groupInstId);
        if (null == actGroupActiveInstPO) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u62fc\u56e2\u5b9e\u4f8b\u3010" + groupInstId + "\u3011");
        }
        Integer finalMemNum = actGroupActiveInstPO.getFinalMemNum();
        return finalMemNum;
    }
}

