/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.atom.ActUpdateGroupActiveStockAtomService;
import com.tydic.active.app.atom.bo.ActUpdateGroupActiveStockAtomReqBO;
import com.tydic.active.app.atom.bo.ActUpdateGroupActiveStockAtomRspBO;
import com.tydic.active.app.busi.ActCreateGroupActiveInstBusiService;
import com.tydic.active.app.busi.bo.ActCreateGroupActiveInstBusiReqBO;
import com.tydic.active.app.busi.bo.ActCreateGroupActiveInstBusiRspBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstDetailBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActGroupActiveExtMapper;
import com.tydic.active.app.dao.ActGroupActiveInstDetailMapper;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveExtPO;
import com.tydic.active.app.dao.po.ActGroupActiveInstDetailPO;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActCreateGroupActiveInstBusiServiceImpl
implements ActCreateGroupActiveInstBusiService {
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Autowired
    private ActGroupActiveInstDetailMapper actGroupActiveInstDetailMapper;
    @Autowired
    private ActGroupActiveExtMapper actGroupActiveExtMapper;
    @Autowired
    private ActUpdateGroupActiveStockAtomService actUpdateGroupActiveStockAtomService;
    @Value(value="${STOCK_HANDLE_MODE}")
    private Byte stockHandleMode;

    public ActCreateGroupActiveInstBusiRspBO createGroupActiveInst(ActCreateGroupActiveInstBusiReqBO busiReqBO) {
        ActCreateGroupActiveInstBusiRspBO rsp = new ActCreateGroupActiveInstBusiRspBO();
        ActGroupActiveExtPO actGroupActiveExtPO = this.actGroupActiveExtMapper.selectByPrimaryKey(busiReqBO.getActiveId());
        if (null == actGroupActiveExtPO) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u6d3b\u52a8\u3010" + busiReqBO.getActiveId() + "\u3011!");
        }
        if (ActCommConstant.GroupActiveOperType.OPENING_A_REGIMENT.equals(busiReqBO.getOperType())) {
            this.openingRegiment(busiReqBO, actGroupActiveExtPO);
        } else if (ActCommConstant.GroupActiveOperType.JOIN_THE_DELEGATION.equals(busiReqBO.getOperType())) {
            if (!ActCommConstant.StockHandleMode.NO_STOCK_LIMIT.equals(this.stockHandleMode)) {
                ActUpdateGroupActiveStockAtomRspBO actUpdateGroupActiveStockAtomRspBO = this.doActUpdateGroupActiveStockAtomService(busiReqBO, ActCommConstant.GroupActiveStockOperateType.OUT_STOCK);
                if (actUpdateGroupActiveStockAtomRspBO.isIsFullCreateNewGroup()) {
                    ActGroupActiveInstBO actGroupActiveInstBO = busiReqBO.getActGroupActiveInstBO();
                    actGroupActiveInstBO.setGroupInstId(actUpdateGroupActiveStockAtomRspBO.getGroupInstId());
                    this.openingRegiment(busiReqBO, actGroupActiveExtPO);
                } else {
                    try {
                        this.joinDelegation(busiReqBO, actGroupActiveExtPO);
                    }
                    catch (Exception e) {
                        this.doActUpdateGroupActiveStockAtomService(busiReqBO, ActCommConstant.GroupActiveStockOperateType.INSERT_STOCK);
                        throw new BusinessException("14059", e.getMessage());
                    }
                }
            } else {
                this.joinDelegation(busiReqBO, actGroupActiveExtPO);
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62fc\u56e2\u5b9e\u4f8b\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    private void joinDelegation(ActCreateGroupActiveInstBusiReqBO busiReqBO, ActGroupActiveExtPO actGroupActiveExtPO) {
        Long groupInstId = busiReqBO.getActGroupActiveInstBO().getGroupInstId();
        ActGroupActiveInstPO actGroupActiveInstPO = this.actGroupActiveInstMapper.selectByPrimaryKey(groupInstId);
        if (null == actGroupActiveInstPO) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u62fc\u56e2\u6d3b\u52a8\u5b9e\u4f8b\u3010" + groupInstId + "\u3011!");
        }
        for (ActGroupActiveInstDetailBO bo : busiReqBO.getActGroupActiveInstBO().getActGroupActiveInstDetailBOs()) {
            if (bo.getMemId().equals(actGroupActiveInstPO.getCreateMemId())) {
                throw new BusinessException("14060", "\u60a8\u4e0d\u80fd\u53c2\u52a0\u81ea\u5df1\u5f00\u56e2\u7684\u62fc\u56e2\u6d3b\u52a8!");
            }
            ActGroupActiveInstDetailPO actGroupActiveInstDetailPO = new ActGroupActiveInstDetailPO();
            actGroupActiveInstDetailPO.setActiveId(busiReqBO.getActiveId());
            actGroupActiveInstDetailPO.setAdmOrgId(busiReqBO.getOrgIdIn());
            actGroupActiveInstDetailPO.setGroupInstId(busiReqBO.getActGroupActiveInstBO().getGroupInstId());
            actGroupActiveInstDetailPO.setMemId(bo.getMemId());
            int joinGroupNumLimit = this.actGroupActiveInstDetailMapper.selectJoinGroupNumLimit(actGroupActiveInstDetailPO);
            if (joinGroupNumLimit < actGroupActiveExtPO.getJoinGroupNumLimit()) continue;
            throw new BusinessException("14058", "\u4f1a\u5458\u3010" + bo.getMemId() + "\u3011\u5df2\u8d85\u51fa\u53c2\u56e2\u6b21\u6570\u9650\u5236\uff01");
        }
        this.insertGroupAvtiveInstDetail(busiReqBO, groupInstId, ActCommConstant.IsHeadFlag.NO);
        if (ActCommConstant.StockHandleMode.NO_STOCK_LIMIT.equals(this.stockHandleMode)) {
            if (actGroupActiveInstPO.getGroupMenNum() >= actGroupActiveInstPO.getFinalMemNum()) {
                throw new BusinessException("14059", "\u6d3b\u52a8\u5b9e\u4f8b\u3010" + groupInstId + "\u3011\u53c2\u56e2\u4eba\u6570\u5df2\u6ee1!");
            }
            ActGroupActiveInstPO updateNumPO = new ActGroupActiveInstPO();
            updateNumPO.setGroupInstId(actGroupActiveInstPO.getGroupInstId());
            updateNumPO.setGroupMenNum(actGroupActiveInstPO.getGroupMenNum() + 1);
            int isUpdate = this.actGroupActiveInstMapper.updateByPrimaryKeySelective(updateNumPO);
            if (isUpdate < 1) {
                throw new BusinessException("14012", "\u66f4\u65b0\u5b9e\u4f8b\u8868\u5df2\u53c2\u56e2\u4eba\u6570\u5931\u8d25\uff01");
            }
        }
    }

    private void openingRegiment(ActCreateGroupActiveInstBusiReqBO busiReqBO, ActGroupActiveExtPO actGroupActiveExtPO) {
        ActGroupActiveInstPO actGroupActiveInst = new ActGroupActiveInstPO();
        actGroupActiveInst.setActiveId(busiReqBO.getActiveId());
        actGroupActiveInst.setAdmOrgId(busiReqBO.getOrgIdIn());
        actGroupActiveInst.setCreateMemId(busiReqBO.getMemIdIn().toString());
        int launchGroupNumLimit = this.actGroupActiveInstMapper.selectLaunchGroupNumLimit(actGroupActiveInst);
        if (launchGroupNumLimit >= actGroupActiveExtPO.getLaunchGroupNumLimit()) {
            throw new BusinessException("14058", "\u60a8\u5df2\u8d85\u51fa\u5f00\u56e2\u6b21\u6570\u9650\u5236\uff01");
        }
        ActGroupActiveInstBO actGroupActiveInstBO = busiReqBO.getActGroupActiveInstBO();
        if (null == actGroupActiveInstBO.getGroupInstId()) {
            actGroupActiveInstBO.setGroupInstId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        ActGroupActiveInstPO actGroupActiveInstPO = new ActGroupActiveInstPO();
        BeanUtils.copyProperties((Object)actGroupActiveInstBO, (Object)actGroupActiveInstPO);
        actGroupActiveInstPO.setGroupInstId(actGroupActiveInstBO.getGroupInstId());
        actGroupActiveInstPO.setActiveId(busiReqBO.getActiveId());
        actGroupActiveInstPO.setAdmOrgId(busiReqBO.getOrgIdIn());
        actGroupActiveInstPO.setTargetMemNum(actGroupActiveExtPO.getTargetMemNum());
        actGroupActiveInstPO.setFinalMemNum(actGroupActiveExtPO.getFinalMemNum());
        actGroupActiveInstPO.setGroupMenNum(1);
        actGroupActiveInstPO.setLockMemNum(0);
        actGroupActiveInstPO.setState(ActCommConstant.GroupActiveState.UNFORMED);
        Date nowTime = new Date();
        actGroupActiveInstPO.setCreateTime(nowTime);
        actGroupActiveInstPO.setEndTime(this.caculateEndTime(nowTime, actGroupActiveExtPO.getExpTimeInternal()));
        actGroupActiveInstPO.setCreateMemId(busiReqBO.getMemIdIn().toString());
        int isInsert = this.actGroupActiveInstMapper.insert(actGroupActiveInstPO);
        if (isInsert < 1) {
            throw new BusinessException("14010", "\u63d2\u5165\u62fc\u56e2\u5b9e\u4f8b\u8868\u5931\u8d25\uff01");
        }
        this.insertGroupAvtiveInstDetail(busiReqBO, actGroupActiveInstBO.getGroupInstId(), ActCommConstant.IsHeadFlag.YES);
        if (!ActCommConstant.StockHandleMode.NO_STOCK_LIMIT.equals(this.stockHandleMode)) {
            this.doActUpdateGroupActiveStockAtomService(busiReqBO, ActCommConstant.GroupActiveStockOperateType.OUT_STOCK);
        }
    }

    private ActUpdateGroupActiveStockAtomRspBO doActUpdateGroupActiveStockAtomService(ActCreateGroupActiveInstBusiReqBO busiReqBO, Integer groupActiveStockOperateType) {
        ActUpdateGroupActiveStockAtomReqBO actUpdateGroupActiveStockAtomReqBO = new ActUpdateGroupActiveStockAtomReqBO();
        actUpdateGroupActiveStockAtomReqBO.setActiveId(busiReqBO.getActiveId());
        actUpdateGroupActiveStockAtomReqBO.setGroupInstId(busiReqBO.getActGroupActiveInstBO().getGroupInstId());
        actUpdateGroupActiveStockAtomReqBO.setGroupActiveOperType(busiReqBO.getOperType());
        actUpdateGroupActiveStockAtomReqBO.setStockOperType(groupActiveStockOperateType);
        ActUpdateGroupActiveStockAtomRspBO actUpdateGroupActiveStockAtomRspBO = this.actUpdateGroupActiveStockAtomService.updateGroupActiveStock(actUpdateGroupActiveStockAtomReqBO);
        return actUpdateGroupActiveStockAtomRspBO;
    }

    private void insertGroupAvtiveInstDetail(ActCreateGroupActiveInstBusiReqBO busiReqBO, Long groupInstId, Integer isHeadFlag) {
        ArrayList<ActGroupActiveInstDetailPO> list = new ArrayList<ActGroupActiveInstDetailPO>();
        for (ActGroupActiveInstDetailBO bo : busiReqBO.getActGroupActiveInstBO().getActGroupActiveInstDetailBOs()) {
            ActGroupActiveInstDetailPO checkActGroupActiveInstDetailPO = new ActGroupActiveInstDetailPO();
            checkActGroupActiveInstDetailPO.setActiveId(busiReqBO.getActiveId());
            checkActGroupActiveInstDetailPO.setOrderId(bo.getOrderId());
            checkActGroupActiveInstDetailPO.setOrderStatus("1");
            ActGroupActiveInstDetailPO checkActGroupActiveInstDetail = this.actGroupActiveInstDetailMapper.getModelBy(checkActGroupActiveInstDetailPO);
            if (null != checkActGroupActiveInstDetail) {
                throw new BusinessException("14061", "\u6570\u636e\u5e93\u5df2\u5b58\u5728active\u3010" + busiReqBO.getActiveId() + "\u3011,orderId\u3010" + bo.getOrderId() + "\u3011\u7684\u62fc\u56e2\u5b9e\u4f8b\u660e\u7ec6");
            }
            ActGroupActiveInstDetailPO po = new ActGroupActiveInstDetailPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setInstDetailId(Sequence.getInstance().nextId());
            po.setGroupInstId(groupInstId);
            po.setActiveId(busiReqBO.getActiveId());
            po.setAdmOrgId(busiReqBO.getOrgIdIn());
            po.setCreateTime(new Date());
            po.setIsHeadFlag(isHeadFlag);
            po.setOrderStatus("1");
            if (ActCommConstant.GroupActiveOperType.OPENING_A_REGIMENT.equals(busiReqBO.getOperType())) {
                po.setMemId(busiReqBO.getMemIdIn().toString());
            }
            list.add(po);
        }
        int isInsert2 = this.actGroupActiveInstDetailMapper.insertBatch(list);
        if (isInsert2 != list.size()) {
            throw new BusinessException("14010", "\u63d2\u5165\u62fc\u56e2\u5b9e\u4f8b\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }

    private Date caculateEndTime(Date nowTime, Long expTimeInternal) {
        Calendar endTImeCal = Calendar.getInstance();
        endTImeCal.setTime(nowTime);
        endTImeCal.add(13, expTimeInternal.intValue());
        return endTImeCal.getTime();
    }
}

