/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.tydic.active.app.busi.ActRedEnvelopesCalculationBusiService;
import com.tydic.active.app.busi.bo.ActRedEnvelopesCalculationBusiReqBO;
import com.tydic.active.app.busi.bo.ActRedEnvelopesCalculationBusiRspBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.stereotype.Service;

@Service(value="actRedEnvelopesCalculationBusiService")
public class ActRedEnvelopesCalculationBusiServiceImpl
implements ActRedEnvelopesCalculationBusiService {
    public ActRedEnvelopesCalculationBusiRspBO redEnvelopesCalculatePrice(ActRedEnvelopesCalculationBusiReqBO busiReqBO) {
        ActRedEnvelopesCalculationBusiRspBO rsp = new ActRedEnvelopesCalculationBusiRspBO();
        BigDecimal totalDiscountPrice = new BigDecimal(0);
        BigDecimal totalPrice = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : busiReqBO.getSkuInfoList()) {
            bo.setTotalPrice(bo.getSalePrice().multiply(bo.getActCount()));
        }
        for (SkuCalculationActiveBO bo : busiReqBO.getSkuInfoList()) {
            totalPrice = totalPrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            totalDiscountPrice = totalDiscountPrice.add(bo.getDiscountPrice());
        }
        BigDecimal redEnvelopesMoney = busiReqBO.getRedEnvelopesMoney();
        BigDecimal alreadyDiscountPrice = busiReqBO.getRedEnvelopesMoney();
        for (int i = 0; i < busiReqBO.getSkuInfoList().size(); ++i) {
            if (i + 1 == busiReqBO.getSkuInfoList().size()) {
                ((SkuCalculationActiveBO)busiReqBO.getSkuInfoList().get(i)).setDiscountPrice(alreadyDiscountPrice);
                break;
            }
            BigDecimal moleculeTotalPrice = ((SkuCalculationActiveBO)busiReqBO.getSkuInfoList().get(i)).getTotalPrice().multiply(redEnvelopesMoney).setScale(2, RoundingMode.HALF_UP);
            BigDecimal singelDiscountPrice = moleculeTotalPrice.divide(totalPrice, 2, RoundingMode.HALF_UP);
            ((SkuCalculationActiveBO)busiReqBO.getSkuInfoList().get(i)).setDiscountPrice(singelDiscountPrice);
            alreadyDiscountPrice = alreadyDiscountPrice.subtract(singelDiscountPrice);
        }
        rsp.setRows(busiReqBO.getSkuInfoList());
        rsp.setTotalPrice(totalPrice);
        rsp.setTotalDiscountPrice(totalDiscountPrice);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u7ea2\u5305\u62b5\u6263\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

