/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActSyncKillPriceAtomService;
import com.tydic.active.app.atom.bo.ActSyncKillPriceAtomReqBO;
import com.tydic.active.app.atom.bo.ActSyncKillPriceAtomRspBO;
import com.tydic.active.app.busi.ActUpdateKillSkuByBatchBusiService;
import com.tydic.active.app.busi.bo.ActUpdateKillSkuByBatchBusiReqBO;
import com.tydic.active.app.busi.bo.ActUpdateKillSkuByBatchBusiRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillDayMapper;
import com.tydic.active.app.dao.ActKillSkuMapper;
import com.tydic.active.app.dao.ActKillTimeMapper;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.po.ActKillDayPO;
import com.tydic.active.app.dao.po.ActKillSkuPO;
import com.tydic.active.app.dao.po.ActKillTimePO;
import com.tydic.active.app.dao.po.ActivityPO;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActUpdateKillSkuByBatchBusiServiceImpl
implements ActUpdateKillSkuByBatchBusiService {
    @Autowired
    private ActKillSkuMapper actKillSkuMapper;
    @Autowired
    private ActKillDayMapper actKillDayMapper;
    @Autowired
    private ActKillTimeMapper actKillTimeMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActSyncKillPriceAtomService actSyncKillPriceAtomService;

    public ActUpdateKillSkuByBatchBusiRspBO updateKillSkuByBatch(ActUpdateKillSkuByBatchBusiReqBO busiReqBO) {
        ActUpdateKillSkuByBatchBusiRspBO busiRspBO = new ActUpdateKillSkuByBatchBusiRspBO();
        ActivityPO activityPO = new ActivityPO();
        activityPO.setActiveId(busiReqBO.getActiveId());
        activityPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        activityPO.setAdmOrgId(busiReqBO.getOrgIdIn());
        ActivityPO activity = this.activityMapper.getModelBy(activityPO);
        if (null == activity) {
            throw new BusinessException("0101", "\u6d3b\u52a8\u3010" + busiReqBO.getActiveId() + "\u3011\u4e0d\u5b58\u5728");
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getActKillSkuBOlist())) {
            ArrayList<Long> skuIds = new ArrayList<Long>();
            for (ActKillSkuBO actKillSkuBO : busiReqBO.getActKillSkuBOlist()) {
                ActKillSkuPO actKillSkuPO = new ActKillSkuPO();
                BeanUtils.copyProperties((Object)actKillSkuBO, (Object)actKillSkuPO);
                actKillSkuPO.setAdmOrgId(activity.getAdmOrgId());
                actKillSkuPO.setActiveId(busiReqBO.getActiveId());
                int count = this.actKillSkuMapper.updateByPrimaryKeySelective(actKillSkuPO);
                if (count != 1) {
                    throw new BusinessException("14012", "skuId\u3010" + actKillSkuPO.getSkuId() + "\u3011\u4e0d\u5b58\u5728");
                }
                this.updateKillDay(busiReqBO, actKillSkuBO);
                this.updateKillTime(busiReqBO, actKillSkuBO);
                skuIds.add(Long.parseLong(actKillSkuBO.getSkuId()));
            }
            if (ActCommConstant.ActivityState.STATE_EFFECTIVE.equals(activity.getActiveStatus())) {
                ActSyncKillPriceAtomReqBO atomReqBO = new ActSyncKillPriceAtomReqBO();
                atomReqBO.setActiveId(busiReqBO.getActiveId());
                atomReqBO.setOperType(0);
                atomReqBO.setSkuIds(skuIds);
                ActSyncKillPriceAtomRspBO atomRspBO = this.actSyncKillPriceAtomService.syncKillPrice(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                }
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u79d2\u6740\u5355\u54c1\u6279\u91cf\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private void updateKillDay(ActUpdateKillSkuByBatchBusiReqBO busiReqBO, ActKillSkuBO actKillSkuBO) {
        if ("1".equals(actKillSkuBO.getModifyDayStockNum()) || "1".equals(actKillSkuBO.getModifyDayMemLimitNum())) {
            ActKillDayPO actKillDayPO = new ActKillDayPO();
            if ("1".equals(actKillSkuBO.getModifyDayStockNum())) {
                actKillDayPO.setActualNum(actKillSkuBO.getDayStockNum() == null ? -1 : actKillSkuBO.getDayStockNum());
            }
            if ("1".equals(actKillSkuBO.getModifyDayMemLimitNum())) {
                actKillDayPO.setMemLimitNum(actKillSkuBO.getDayMemLimitNum() == null ? -1 : actKillSkuBO.getDayMemLimitNum());
            }
            actKillDayPO.setActiveId(busiReqBO.getActiveId());
            actKillDayPO.setAdmOrgId(busiReqBO.getOrgIdIn());
            actKillDayPO.setSkuId(actKillSkuBO.getSkuId());
            this.actKillDayMapper.updateByPrimaryKeySelective(actKillDayPO);
        }
    }

    private void updateKillTime(ActUpdateKillSkuByBatchBusiReqBO busiReqBO, ActKillSkuBO actKillSkuBO) {
        if ("1".equals(actKillSkuBO.getModifyTimeStockNum()) || "1".equals(actKillSkuBO.getModifyTimeMemLimitNum())) {
            ActKillTimePO actKillTimePO = new ActKillTimePO();
            if ("1".equals(actKillSkuBO.getModifyTimeStockNum())) {
                actKillTimePO.setActualNum(actKillSkuBO.getTimeStockNum() == null ? -1 : actKillSkuBO.getTimeStockNum());
            }
            if ("1".equals(actKillSkuBO.getModifyTimeMemLimitNum())) {
                actKillTimePO.setMemLimitNum(actKillSkuBO.getTimeMemLimitNum() == null ? -1 : actKillSkuBO.getTimeMemLimitNum());
            }
            actKillTimePO.setActiveId(busiReqBO.getActiveId());
            actKillTimePO.setAdmOrgId(busiReqBO.getOrgIdIn());
            actKillTimePO.setSkuId(actKillSkuBO.getSkuId());
            this.actKillTimeMapper.updateByPrimaryKeySelective(actKillTimePO);
        }
    }
}

