/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.ActRedisManager;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.atom.ActQryKillSkuStockPriceAtomService;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomRspBO;
import com.tydic.active.app.busi.ActUpdateKillSkuStockBusiService;
import com.tydic.active.app.busi.bo.ActUpdateKillSkuStockBusiReqBO;
import com.tydic.active.app.busi.bo.ActUpdateKillSkuStockBusiRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.common.bo.ActUpdateKillSkuStockBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillSkuLogMapper;
import com.tydic.active.app.dao.po.ActKillSkuLogPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActUpdateKillSkuStockBusiServiceImpl
implements ActUpdateKillSkuStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActUpdateKillSkuStockBusiServiceImpl.class);
    @Autowired
    private ActRedisManager cacheManager;
    @Autowired
    private ActQryKillSkuStockPriceAtomService actQryKillSkuStockPriceAtomService;
    @Autowired
    private ActKillSkuLogMapper actKillSkuLogMapper;

    public ActUpdateKillSkuStockBusiRspBO updateKillSkuStock(ActUpdateKillSkuStockBusiReqBO busiReqBO) {
        ActUpdateKillSkuStockBusiRspBO busiRspBO = new ActUpdateKillSkuStockBusiRspBO();
        ActQryKillSkuStockPriceAtomReqBO atomReqBO = new ActQryKillSkuStockPriceAtomReqBO();
        atomReqBO.setSkuIds(busiReqBO.getSkuIds());
        atomReqBO.setActiveId(busiReqBO.getActiveId());
        atomReqBO.setStartTime(busiReqBO.getStartTime());
        atomReqBO.setEndTime(busiReqBO.getEndTime());
        ActQryKillSkuStockPriceAtomRspBO atomRspBO = this.actQryKillSkuStockPriceAtomService.qryKillSkuStockPrice(atomReqBO);
        log.info("\u67e5\u8be2\u79d2\u6740\u5355\u54c1\u5e93\u5b58 \u4ef7\u683c \u9650\u8d2d\u7b49\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)((Object)atomRspBO)));
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        if (ActCommConstant.KillSkuStockOperateType.OCCUPY_STOCK.equals(busiReqBO.getOperType())) {
            this.processOccupyStock(atomRspBO, busiReqBO);
        } else if (ActCommConstant.KillSkuStockOperateType.OUT_STOCK.equals(busiReqBO.getOperType())) {
            this.processOutStock(atomRspBO, busiReqBO);
        } else if (ActCommConstant.KillSkuStockOperateType.INSERT_STOCK.equals(busiReqBO.getOperType())) {
            this.processInsertStock(atomRspBO, busiReqBO);
        } else if (ActCommConstant.KillSkuStockOperateType.UN_OCCUPY_STOCK.equals(busiReqBO.getOperType())) {
            this.processUnOcuppyStock(atomRspBO, busiReqBO);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return busiRspBO;
    }

    private void processOccupyStock(ActQryKillSkuStockPriceAtomRspBO atomRspBO, ActUpdateKillSkuStockBusiReqBO busiReqBO) {
        log.info("\u5360\u5e93\u8c03\u7528\u5f00\u59cb======" + JSON.toJSONString((Object)busiReqBO));
        Map<String, ActKillSkuBO> skuIdKillSkuBOMap = atomRspBO.getSkuIdKillSkuBOMap();
        for (ActUpdateKillSkuStockBO actUpdateKillSkuStockBO : busiReqBO.getActUpdateKillSkuStockBOList()) {
            if (skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString()) == null) {
                throw new BusinessException("14056", "\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u4e0d\u662f\u79d2\u6740\u5546\u54c1");
            }
            ActKillSkuBO actKillSkuBO = skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString());
            if (actUpdateKillSkuStockBO.getOperateNum() <= actKillSkuBO.getCurrentAvilabeStockNum()) continue;
            throw new BusinessException("14057", "\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
        }
        HashMap<Long, Long> lockStockSkuIdMap = new HashMap<Long, Long>();
        Boolean returnFlag = false;
        Long errorSkuId = null;
        ArrayList<ActKillSkuLogPO> actKillSkuLogPOS = new ArrayList<ActKillSkuLogPO>();
        for (ActUpdateKillSkuStockBO actUpdateKillSkuStockBO : busiReqBO.getActUpdateKillSkuStockBOList()) {
            errorSkuId = actUpdateKillSkuStockBO.getSkuId();
            ActKillSkuBO actKillSkuBO1 = skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString());
            String timeLockRedisKey = "TIME_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getEndTime()) + "_" + actKillSkuBO1.getSkuId();
            String dayLockRedisKey = "DAY_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + actKillSkuBO1.getSkuId();
            String skuLockRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuBO1.getActiveId() + "_" + actKillSkuBO1.getSkuId();
            lockStockSkuIdMap.put(actUpdateKillSkuStockBO.getSkuId(), actUpdateKillSkuStockBO.getOperateNum().longValue());
            if (ActCommConstant.KillSkuControlRange.TIME.equals(actKillSkuBO1.getStockControlRange())) {
                log.info(actUpdateKillSkuStockBO.getSkuId() + "\u5e93\u5b58\u63a7\u5236\u5728\u65f6\u6bb5");
                Long timeTempLockNum = this.cacheManager.incrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                log.info(timeLockRedisKey + "=\u65f6\u6bb5\u9501\u5b9a\u5e93\u5b58\u4e3a==" + timeTempLockNum);
                this.cacheManager.incrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                this.cacheManager.incrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                if (timeTempLockNum <= (long)actKillSkuBO1.getCurrentTotalStockNum().intValue()) continue;
                returnFlag = true;
                break;
            }
            if (ActCommConstant.KillSkuControlRange.DAY.equals(actKillSkuBO1.getStockControlRange())) {
                log.info(actUpdateKillSkuStockBO.getSkuId() + "\u5e93\u5b58\u63a7\u5236\u5728\u65e5\u671f");
                this.cacheManager.incrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                this.cacheManager.incrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                Long dayTempLockNum = this.cacheManager.incrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                log.info(timeLockRedisKey + "=\u65e5\u671f\u9501\u5b9a\u5e93\u5b58\u4e3a==" + dayTempLockNum);
                if (dayTempLockNum <= (long)actKillSkuBO1.getCurrentTotalStockNum().intValue()) continue;
                returnFlag = true;
                break;
            }
            if (ActCommConstant.KillSkuControlRange.SKU.equals(actKillSkuBO1.getStockControlRange())) {
                log.info(actUpdateKillSkuStockBO.getSkuId() + "\u5e93\u5b58\u63a7\u5236\u5728\u5355\u54c1");
                this.cacheManager.incrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                this.cacheManager.incrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                Long skuTempLockNum = this.cacheManager.incrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
                log.info(timeLockRedisKey + "=\u5355\u54c1\u9501\u5b9a\u5e93\u5b58\u4e3a==" + skuTempLockNum);
                if (skuTempLockNum > (long)actKillSkuBO1.getCurrentTotalStockNum().intValue()) {
                    returnFlag = true;
                    break;
                }
            }
            log.info(actUpdateKillSkuStockBO.getSkuId() + "\u6ca1\u6709\u63a7\u5236\u5e93\u5b58\u4fe1\u606f");
            this.cacheManager.incrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.incrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.incrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            ActKillSkuLogPO actKillSkuLogPO = new ActKillSkuLogPO();
            actKillSkuLogPO.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPO.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPO.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPO.setCommodityId(actKillSkuBO1.getCommodityId());
            actKillSkuLogPO.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPO.setOperateNum(actUpdateKillSkuStockBO.getOperateNum());
            actKillSkuLogPO.setStartTime(actKillSkuBO1.getStartTime());
            actKillSkuLogPO.setEndTime(actKillSkuBO1.getEndTime());
            actKillSkuLogPO.setOperateTime(new Date());
            actKillSkuLogPO.setOperateType(ActCommConstant.KillSkuStockOperateType.OCCUPY_STOCK.toString());
            actKillSkuLogPOS.add(actKillSkuLogPO);
        }
        if (returnFlag.booleanValue()) {
            log.info("\u5360\u5e93\u56de\u9000\u8c03\u7528\u5f00\u59cb===============================");
            for (Long skuId : lockStockSkuIdMap.keySet()) {
                String timeLockRedisKey = "TIME_LOCK_TOTAL_" + busiReqBO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)busiReqBO.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)busiReqBO.getEndTime()) + "_" + skuId;
                String dayLockRedisKey = "DAY_LOCK_TOTAL_" + busiReqBO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)busiReqBO.getStartTime()) + "_" + skuId;
                String skuLockRedisKey = "SKU_LOCK_TOTALL_" + busiReqBO.getActiveId() + "_" + skuId;
                this.cacheManager.decrByCount(timeLockRedisKey, (Long)lockStockSkuIdMap.get(skuId));
                this.cacheManager.decrByCount(dayLockRedisKey, (Long)lockStockSkuIdMap.get(skuId));
                this.cacheManager.decrByCount(skuLockRedisKey, (Long)lockStockSkuIdMap.get(skuId));
            }
            throw new BusinessException("14057", "\u3010" + errorSkuId + "\u3011\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
        }
        if (!CollectionUtils.isEmpty(actKillSkuLogPOS)) {
            this.actKillSkuLogMapper.insertBatch(actKillSkuLogPOS);
        }
    }

    private void processOutStock(ActQryKillSkuStockPriceAtomRspBO atomRspBO, ActUpdateKillSkuStockBusiReqBO busiReqBO) {
        log.info("\u51fa\u5e93\u8c03\u7528\u5f00\u59cb======" + JSON.toJSONString((Object)busiReqBO));
        Map<String, ActKillSkuBO> skuIdKillSkuBOMap = atomRspBO.getSkuIdKillSkuBOMap();
        ArrayList<ActKillSkuLogPO> actKillSkuLogPOS = new ArrayList<ActKillSkuLogPO>();
        for (ActUpdateKillSkuStockBO actUpdateKillSkuStockBO : busiReqBO.getActUpdateKillSkuStockBOList()) {
            ActKillSkuBO actKillSkuBO1 = skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString());
            if (actKillSkuBO1 == null) {
                throw new BusinessException("14056", "\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u4e0d\u662f\u79d2\u6740\u5546\u54c1");
            }
            ActKillSkuLogPO actKillSkuLogPOReq = new ActKillSkuLogPO();
            actKillSkuLogPOReq.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPOReq.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPOReq.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPOReq.setStartTime(busiReqBO.getStartTime());
            actKillSkuLogPOReq.setEndTime(busiReqBO.getEndTime());
            actKillSkuLogPOReq.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPOReq.setOperateType(ActCommConstant.KillSkuStockOperateType.OCCUPY_STOCK.toString());
            ActKillSkuLogPO actKillSkuLogPORsp = this.actKillSkuLogMapper.selectByRecord(actKillSkuLogPOReq);
            if (null == actKillSkuLogPORsp) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u6ca1\u6709\u5360\u5e93\u8bb0\u5f55");
            }
            if (actUpdateKillSkuStockBO.getOperateNum() != actKillSkuLogPORsp.getOperateNum()) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u5360\u5e93\u6570\u91cf\u548c\u51fa\u5e93\u6570\u91cf\u4e0d\u76f8\u7b49");
            }
            String timeLockRedisKey = "TIME_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getEndTime()) + "_" + actKillSkuBO1.getSkuId();
            String timeSalesRedisKey = "TIME_SALES_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getEndTime()) + "_" + actKillSkuBO1.getSkuId();
            String dayLockRedisKey = "DAY_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + actKillSkuBO1.getSkuId();
            String daySalesRedisKey = "DAY_SALES_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + actKillSkuBO1.getSkuId();
            String skuLockRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuBO1.getActiveId() + "_" + actKillSkuBO1.getSkuId();
            String skuSalesRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuBO1.getActiveId() + "_" + actKillSkuBO1.getSkuId();
            this.cacheManager.decrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.incrByCount(timeSalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.incrByCount(daySalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.incrByCount(skuSalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            ActKillSkuLogPO actKillSkuLogPO = new ActKillSkuLogPO();
            actKillSkuLogPO.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPO.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPO.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPO.setCommodityId(actKillSkuBO1.getCommodityId());
            actKillSkuLogPO.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPO.setOperateNum(actUpdateKillSkuStockBO.getOperateNum());
            actKillSkuLogPO.setStartTime(actKillSkuBO1.getStartTime());
            actKillSkuLogPO.setEndTime(actKillSkuBO1.getEndTime());
            actKillSkuLogPO.setOperateTime(new Date());
            actKillSkuLogPO.setOperateType(ActCommConstant.KillSkuStockOperateType.OUT_STOCK.toString());
            actKillSkuLogPOS.add(actKillSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(actKillSkuLogPOS)) {
            this.actKillSkuLogMapper.insertBatch(actKillSkuLogPOS);
        }
    }

    private void processInsertStock(ActQryKillSkuStockPriceAtomRspBO atomRspBO, ActUpdateKillSkuStockBusiReqBO busiReqBO) {
        log.info("\u5165\u5e93\u8c03\u7528\u5f00\u59cb======" + JSON.toJSONString((Object)busiReqBO));
        Map<String, ActKillSkuBO> skuIdKillSkuBOMap = atomRspBO.getSkuIdKillSkuBOMap();
        ArrayList<ActKillSkuLogPO> actKillSkuLogPOS = new ArrayList<ActKillSkuLogPO>();
        for (ActUpdateKillSkuStockBO actUpdateKillSkuStockBO : busiReqBO.getActUpdateKillSkuStockBOList()) {
            ActKillSkuBO actKillSkuBO1 = skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString());
            if (actKillSkuBO1 == null) {
                throw new BusinessException("14056", "\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u4e0d\u662f\u79d2\u6740\u5546\u54c1");
            }
            ActKillSkuLogPO actKillSkuLogPOReq = new ActKillSkuLogPO();
            actKillSkuLogPOReq.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPOReq.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPOReq.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPOReq.setStartTime(busiReqBO.getStartTime());
            actKillSkuLogPOReq.setEndTime(busiReqBO.getEndTime());
            actKillSkuLogPOReq.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPOReq.setOperateType(ActCommConstant.KillSkuStockOperateType.OUT_STOCK.toString());
            ActKillSkuLogPO actKillSkuLogPORsp = this.actKillSkuLogMapper.selectByRecord(actKillSkuLogPOReq);
            if (null == actKillSkuLogPORsp) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u6ca1\u6709\u51fa\u5e93\u8bb0\u5f55");
            }
            if (actUpdateKillSkuStockBO.getOperateNum() != actKillSkuLogPORsp.getOperateNum()) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u51fa\u5e93\u6570\u91cf\u548c\u5165\u5e93\u6570\u91cf\u4e0d\u76f8\u7b49");
            }
            String timeSalesRedisKey = "TIME_SALES_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getEndTime()) + "_" + actKillSkuBO1.getSkuId();
            String daySalesRedisKey = "DAY_SALES_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + actKillSkuBO1.getSkuId();
            String skuSalesRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuBO1.getActiveId() + "_" + actKillSkuBO1.getSkuId();
            this.cacheManager.decrByCount(timeSalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(daySalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(skuSalesRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            ActKillSkuLogPO actKillSkuLogPO = new ActKillSkuLogPO();
            actKillSkuLogPO.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPO.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPO.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPO.setCommodityId(actKillSkuBO1.getCommodityId());
            actKillSkuLogPO.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPO.setOperateNum(actUpdateKillSkuStockBO.getOperateNum());
            actKillSkuLogPO.setStartTime(actKillSkuBO1.getStartTime());
            actKillSkuLogPO.setEndTime(actKillSkuBO1.getEndTime());
            actKillSkuLogPO.setOperateTime(new Date());
            actKillSkuLogPO.setOperateType(ActCommConstant.KillSkuStockOperateType.INSERT_STOCK.toString());
            actKillSkuLogPOS.add(actKillSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(actKillSkuLogPOS)) {
            this.actKillSkuLogMapper.insertBatch(actKillSkuLogPOS);
        }
    }

    private void processUnOcuppyStock(ActQryKillSkuStockPriceAtomRspBO atomRspBO, ActUpdateKillSkuStockBusiReqBO busiReqBO) {
        log.info("\u89e3\u5360\u5e93\u8c03\u7528\u5f00\u59cb======" + JSON.toJSONString((Object)busiReqBO));
        Map<String, ActKillSkuBO> skuIdKillSkuBOMap = atomRspBO.getSkuIdKillSkuBOMap();
        ArrayList<ActKillSkuLogPO> actKillSkuLogPOS = new ArrayList<ActKillSkuLogPO>();
        for (ActUpdateKillSkuStockBO actUpdateKillSkuStockBO : busiReqBO.getActUpdateKillSkuStockBOList()) {
            ActKillSkuBO actKillSkuBO1 = skuIdKillSkuBOMap.get(actUpdateKillSkuStockBO.getSkuId().toString());
            if (actKillSkuBO1 == null) {
                throw new BusinessException("14056", "\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u4e0d\u662f\u79d2\u6740\u5546\u54c1");
            }
            ActKillSkuLogPO actKillSkuLogPOReq = new ActKillSkuLogPO();
            actKillSkuLogPOReq.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPOReq.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPOReq.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPOReq.setStartTime(busiReqBO.getStartTime());
            actKillSkuLogPOReq.setEndTime(busiReqBO.getEndTime());
            actKillSkuLogPOReq.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPOReq.setOperateType(ActCommConstant.KillSkuStockOperateType.OCCUPY_STOCK.toString());
            ActKillSkuLogPO actKillSkuLogPORsp = this.actKillSkuLogMapper.selectByRecord(actKillSkuLogPOReq);
            if (null == actKillSkuLogPORsp) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u6ca1\u6709\u5360\u5e93\u8bb0\u5f55");
            }
            if (actUpdateKillSkuStockBO.getOperateNum() != actKillSkuLogPORsp.getOperateNum()) {
                throw new BusinessException("14003", "\u5355\u54c1\u3010" + actUpdateKillSkuStockBO.getSkuId() + "\u3011\u5360\u5e93\u6570\u91cf\u548c\u89e3\u5360\u5e93\u6570\u91cf\u4e0d\u76f8\u7b49");
            }
            String timeLockRedisKey = "TIME_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getEndTime()) + "_" + actKillSkuBO1.getSkuId();
            String dayLockRedisKey = "DAY_LOCK_TOTAL_" + actKillSkuBO1.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuBO1.getStartTime()) + "_" + actKillSkuBO1.getSkuId();
            String skuLockRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuBO1.getActiveId() + "_" + actKillSkuBO1.getSkuId();
            this.cacheManager.decrByCount(timeLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(dayLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            this.cacheManager.decrByCount(skuLockRedisKey, actUpdateKillSkuStockBO.getOperateNum().longValue());
            ActKillSkuLogPO actKillSkuLogPO = new ActKillSkuLogPO();
            actKillSkuLogPO.setOrderId(busiReqBO.getOrderId());
            actKillSkuLogPO.setActiveId(busiReqBO.getActiveId());
            actKillSkuLogPO.setAdmOrgId(actKillSkuBO1.getAdmOrgId());
            actKillSkuLogPO.setCommodityId(actKillSkuBO1.getCommodityId());
            actKillSkuLogPO.setSkuId(actUpdateKillSkuStockBO.getSkuId().toString());
            actKillSkuLogPO.setOperateNum(actUpdateKillSkuStockBO.getOperateNum());
            actKillSkuLogPO.setStartTime(actKillSkuBO1.getStartTime());
            actKillSkuLogPO.setEndTime(actKillSkuBO1.getEndTime());
            actKillSkuLogPO.setOperateTime(new Date());
            actKillSkuLogPO.setOperateType(ActCommConstant.KillSkuStockOperateType.UN_OCCUPY_STOCK.toString());
            actKillSkuLogPOS.add(actKillSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(actKillSkuLogPOS)) {
            this.actKillSkuLogMapper.insertBatch(actKillSkuLogPOS);
        }
    }
}

