/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.bo.ActQueryOrgListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryOrgListAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantDetailInfoRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantOverviewAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantOverviewBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageRsqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantAbilityRspBO;
import com.tydic.active.app.ability.bo.WelfarePointGrantAuthReqBO;
import com.tydic.active.app.ability.bo.WelfarePointGrantDetailInfoBO;
import com.tydic.active.app.ability.bo.WelfarePointOrgBO;
import com.tydic.active.app.ability.bo.WelfarePointsAttachBO;
import com.tydic.active.app.busi.ActWelfarePointGrantBusiService;
import com.tydic.active.app.busi.ActWelfarePointGrantUserBusiService;
import com.tydic.active.app.busi.ActWelfarePointsAttachBusiService;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChargePageBusiReqBO;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChargePageBusiRspBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantOverviewBusiBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantPageBusiReqBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantUserCountBusiReqBO;
import com.tydic.active.app.busi.bo.WelfarePointOrgBusiBO;
import com.tydic.active.app.busi.bo.WelfarePointsAttachBusiReqBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.constant.ActEnumConstant;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsAttachMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.WelfarePointsGrantMemMapper;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsAttachPO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.uac.util.GenerateIdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActWelfarePointGrantBusiServiceImpl
implements ActWelfarePointGrantBusiService {
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private WelfarePointsGrantMemMapper memMapper;
    @Autowired
    private WelfarePointsAttachMapper welfarePointsAttachMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private ActWelfarePointsAttachBusiService attachBusiService;
    @Autowired
    private ActWelfarePointGrantUserBusiService actWelfarePointGrantUserBusiService;

    public ActQueryWelfarePointGrantOverviewAbilityRspBO queryOverviewInfo(ActQueryWelfarePointGrantAbilityReqBO reqBO) {
        WelfarePointGrantPO reqPo = new WelfarePointGrantPO();
        reqPo.setOrgId(reqBO.getOrgIdWeb());
        List<WelfarePointGrantOverviewBusiBO> overviewList = this.welfarePointGrantMapper.queryOverviewInfoList(reqPo);
        ActQueryWelfarePointGrantOverviewAbilityRspBO resp = new ActQueryWelfarePointGrantOverviewAbilityRspBO();
        if (CollectionUtils.isEmpty(overviewList)) {
            resp.setRespCode("0000");
            resp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return resp;
        }
        ActQueryWelfarePointGrantOverviewBO overviewBO = new ActQueryWelfarePointGrantOverviewBO();
        BigDecimal defVal = BigDecimal.ZERO;
        overviewBO.setCompanyAllAmount(defVal);
        overviewBO.setCompanyGrantAmount(defVal);
        overviewBO.setCompanyAvailableAmount(defVal);
        overviewBO.setTradeUnionAllAmount(defVal);
        overviewBO.setTradeUnionGrantAmount(defVal);
        overviewBO.setTradeUnionAvailableAmount(defVal);
        for (WelfarePointGrantOverviewBusiBO overviewBusiBO : overviewList) {
            Byte welfareType = overviewBusiBO.getWelfareType();
            if (ActActiveConstant.WelfareType.COMPANY.equals(welfareType)) {
                overviewBO.setCompanyAllAmount(overviewBusiBO.getAllCount());
                overviewBO.setCompanyGrantAmount(overviewBusiBO.getGrantCount());
                overviewBO.setCompanyAvailableAmount(overviewBusiBO.getAvailableCount());
                continue;
            }
            if (!ActActiveConstant.WelfareType.TRADE_UNION.equals(welfareType)) continue;
            overviewBO.setTradeUnionAllAmount(overviewBusiBO.getAllCount());
            overviewBO.setTradeUnionGrantAmount(overviewBusiBO.getGrantCount());
            overviewBO.setTradeUnionAvailableAmount(overviewBusiBO.getAvailableCount());
        }
        BeanUtil.copyProperties((Object)overviewBO, (Object)resp);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return resp;
    }

    public ActQueryWelfarePointGrantPageAbilityRspBO queryList(ActQueryWelfarePointGrantPageAbilityReqBO reqBO) {
        WelfarePointGrantPageBusiReqBO queryPO = new WelfarePointGrantPageBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        List<WelfarePointGrantPO> grantPOList = this.welfarePointGrantMapper.selectByCondition(queryPO, (Page<WelfarePointGrantPO>)page);
        ActQueryWelfarePointGrantPageAbilityRspBO busiRspBO = new ActQueryWelfarePointGrantPageAbilityRspBO();
        if (CollectionUtils.isEmpty(grantPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<ActQueryWelfarePointGrantPageBO> rows = new ArrayList<ActQueryWelfarePointGrantPageBO>();
        List grantIdList = grantPOList.stream().map(WelfarePointGrantPO::getWelfarePointGrantId).collect(Collectors.toList());
        WelfarePointGrantUserCountBusiReqBO userCountBusiReqBO = new WelfarePointGrantUserCountBusiReqBO();
        userCountBusiReqBO.setGrantIdList(grantIdList);
        Map countMap = this.actWelfarePointGrantUserBusiService.queryGrantUserCount(userCountBusiReqBO).getUserCountMap();
        for (WelfarePointGrantPO welfarePointGrantPO : grantPOList) {
            ActQueryWelfarePointGrantPageBO rspBO = new ActQueryWelfarePointGrantPageBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)rspBO);
            rspBO.setStatusStr(ActEnumConstant.GrantAuditStatus.getDesc(welfarePointGrantPO.getStatus()));
            rspBO.setWelfarePointTypeStr(ActEnumConstant.WelfarePointType.getDesc(welfarePointGrantPO.getWelfarePointType()));
            rspBO.setWelfareTypeStr(ActEnumConstant.WelfareType.getDesc(welfarePointGrantPO.getWelfareType()));
            rspBO.setGrantUserCount((Integer)countMap.get(welfarePointGrantPO.getWelfarePointGrantId()));
            rows.add(rspBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u798f\u70b9\u53d1\u653e\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    public ActQueryWelfarePointGrantDetailInfoRspBO queryDetail(ActQueryWelfarePointGrantAbilityReqBO reqBO) {
        WelfarePointGrantPO queryPO = new WelfarePointGrantPO();
        queryPO.setWelfarePointGrantId(reqBO.getWelfarePointGrantId());
        queryPO.setWelfarePointCode(reqBO.getWelfarePointCode());
        WelfarePointGrantPO grantRecord = this.welfarePointGrantMapper.getModelBy(queryPO);
        ActQueryWelfarePointGrantDetailInfoRspBO resp = new ActQueryWelfarePointGrantDetailInfoRspBO();
        if (grantRecord == null) {
            resp.setRespCode("0000");
            resp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return resp;
        }
        WelfarePointGrantDetailInfoBO detailInfoBO = new WelfarePointGrantDetailInfoBO();
        BeanUtils.copyProperties((Object)grantRecord, (Object)detailInfoBO);
        detailInfoBO.setWelfarePointTypeStr(ActEnumConstant.WelfarePointType.getDesc(grantRecord.getWelfarePointType()));
        detailInfoBO.setWelfareTypeStr(ActEnumConstant.WelfareType.getDesc(grantRecord.getWelfareType()));
        List<WelfarePointsAttachPO> welfareActiveAttachPOList = this.welfarePointsAttachMapper.selectListByRelatedId(grantRecord.getWelfarePointGrantId());
        ArrayList<WelfarePointsAttachBO> welfareActiveAttachBOList = new ArrayList<WelfarePointsAttachBO>();
        if (CollUtil.isNotEmpty(welfareActiveAttachPOList)) {
            for (WelfarePointsAttachPO attachPO : welfareActiveAttachPOList) {
                WelfarePointsAttachBO attachBO = new WelfarePointsAttachBO();
                BeanUtils.copyProperties((Object)attachPO, (Object)attachBO);
                welfareActiveAttachBOList.add(attachBO);
            }
        }
        detailInfoBO.setOrgIdWeb(grantRecord.getOrgId());
        detailInfoBO.setOrgNameWeb(grantRecord.getOrgName());
        detailInfoBO.setOrgCodeWeb(grantRecord.getOrgCode());
        detailInfoBO.setWelfareActiveAttachList(welfareActiveAttachBOList);
        resp.setDetailInfoBO(detailInfoBO);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u53d1\u653e\u8be6\u60c5\u6210\u529f\uff01");
        return resp;
    }

    public ActWelfarePointGrantAbilityRspBO addGrantInfo(WelfarePointGrantAuthReqBO reqBO) {
        WelfarePointGrantPO queryPO = new WelfarePointGrantPO();
        queryPO.setWelfarePointCode(reqBO.getWelfarePointCode());
        WelfarePointGrantPO grantRecord = this.welfarePointGrantMapper.getModelBy(queryPO);
        WelfarePointGrantPO grantPO = new WelfarePointGrantPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)grantPO);
        grantPO.setOrgId(reqBO.getOrgIdWeb());
        grantPO.setOrgName(reqBO.getOrgNameWeb());
        grantPO.setOrgCode(reqBO.getOrgCodeWeb());
        int isSuccess = 0;
        String errorMsg = "\u798f\u70b9\u53d1\u653e\u65b0\u589e\u5931\u8d25\uff01";
        String succMsg = "\u798f\u70b9\u53d1\u653e\u65b0\u589e\u6210\u529f\uff01";
        Long welfarePointGrantId = 0L;
        if (grantRecord == null) {
            welfarePointGrantId = this.idUtil.nextId();
            grantPO.setWelfarePointGrantId(welfarePointGrantId);
            grantPO.setStatus(ActActiveConstant.GrantStatus.WAIT_SAVE);
            this.setOperateInfo(reqBO, grantPO);
            isSuccess = this.welfarePointGrantMapper.insert(grantPO);
        } else {
            errorMsg = "\u798f\u70b9\u53d1\u653e\u4fee\u6539\u5931\u8d25\uff01";
            succMsg = "\u798f\u70b9\u53d1\u653e\u4fee\u6539\u6210\u529f\uff01";
            welfarePointGrantId = grantRecord.getWelfarePointGrantId();
            grantPO.setWelfarePointGrantId(welfarePointGrantId);
            this.setOperateInfo(reqBO, grantPO);
            isSuccess = this.welfarePointGrantMapper.updateByPrimaryKeySelective(grantPO);
        }
        ActWelfarePointGrantAbilityRspBO rsp = new ActWelfarePointGrantAbilityRspBO();
        if (isSuccess < 1) {
            rsp.setRespCode("0101");
            rsp.setRespDesc(errorMsg);
            return rsp;
        }
        List attachBOList = reqBO.getWelfareActiveAttachList();
        if (CollUtil.isNotEmpty((Collection)attachBOList)) {
            WelfarePointsAttachBO delBO = new WelfarePointsAttachBO();
            delBO.setRelateId(welfarePointGrantId);
            this.attachBusiService.deleteAttach(delBO);
            WelfarePointsAttachBusiReqBO attachBusiReqBO = new WelfarePointsAttachBusiReqBO();
            attachBusiReqBO.setAttachBOList(attachBOList);
            attachBusiReqBO.setRelateId(welfarePointGrantId);
            attachBusiReqBO.setBusiType(ActCommConstant.WelfarePointsAttachBusiType.WELFARE_POINT_GRANT);
            this.attachBusiService.saveAttach(attachBusiReqBO);
        }
        rsp.setWelfarePointGrantId(welfarePointGrantId);
        rsp.setRespCode("0000");
        rsp.setRespDesc(succMsg);
        return rsp;
    }

    public ActQueryOrgListAbilityRspBO queryOrgList(ActQueryOrgListAbilityReqBO reqBO) {
        WelfarePointsChargePO welfarePointsChargePO = new WelfarePointsChargePO();
        welfarePointsChargePO.setIssuerId(reqBO.getUserId());
        welfarePointsChargePO.setIssuerName(reqBO.getUserName());
        ActQueryOrgListAbilityRspBO resp = new ActQueryOrgListAbilityRspBO();
        ArrayList<WelfarePointOrgBO> rows = new ArrayList<WelfarePointOrgBO>();
        WelfarePointOrgBO userOrg = new WelfarePointOrgBO();
        userOrg.setOrgId(reqBO.getOrgId());
        userOrg.setOrgCode(null);
        userOrg.setOrgName(reqBO.getOrgName());
        rows.add(userOrg);
        List<WelfarePointOrgBusiBO> orgList = this.welfarePointsChargeMapper.queryOrgList(welfarePointsChargePO);
        if (CollUtil.isNotEmpty(orgList)) {
            Map<Long, WelfarePointOrgBusiBO> orgMap = orgList.stream().collect(Collectors.toMap(WelfarePointOrgBusiBO::getOrgId, e -> e));
            for (Map.Entry<Long, WelfarePointOrgBusiBO> entry : orgMap.entrySet()) {
                WelfarePointOrgBusiBO orgBusiBO = entry.getValue();
                if (orgBusiBO.getOrgId() == null || userOrg.getOrgId().equals(orgBusiBO.getOrgId())) continue;
                WelfarePointOrgBO orgOrg = new WelfarePointOrgBO();
                BeanUtils.copyProperties((Object)orgBusiBO, (Object)orgOrg);
                rows.add(orgOrg);
            }
        }
        resp.setOrgList(rows);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u53d1\u653e\u8be6\u60c5\u6210\u529f\uff01");
        return resp;
    }

    public ActQueryWelfarePointsChargePageRsqBO queryChargeList(ActQueryWelfarePointsChargePageReqBO reqBO) {
        ActQueryWelfarePointsChargePageBusiReqBO queryPO = new ActQueryWelfarePointsChargePageBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        List<ActQueryWelfarePointsChargePageBusiRspBO> grantPOList = this.welfarePointsChargeMapper.selectListByGrantCondition(queryPO, (Page<ActQueryWelfarePointsChargePageBusiRspBO>)page);
        ActQueryWelfarePointsChargePageRsqBO busiRspBO = new ActQueryWelfarePointsChargePageRsqBO();
        if (CollectionUtils.isEmpty(grantPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<ActQueryWelfarePointsChargePageBO> rows = new ArrayList<ActQueryWelfarePointsChargePageBO>();
        for (ActQueryWelfarePointsChargePageBusiRspBO welfarePointGrantPO : grantPOList) {
            ActQueryWelfarePointsChargePageBO rspBO = new ActQueryWelfarePointsChargePageBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)rspBO);
            rspBO.setWelfareTypeStr(ActEnumConstant.WelfareType.getDesc(welfarePointGrantPO.getWelfareType()));
            rows.add(rspBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u798f\u70b9\u5145\u503c\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void setOperateInfo(WelfarePointGrantAuthReqBO reqBO, WelfarePointGrantPO grantPO) {
        grantPO.setOperateId(reqBO.getUserId());
        grantPO.setOperateName(reqBO.getUserName());
        grantPO.setOperateTime(new Date());
    }
}

