/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityRspBO;
import com.tydic.active.app.busi.ActWelfarePointGrantChangeApproveBusiService;
import com.tydic.active.app.busi.WelfareActiveAuditOperateService;
import com.tydic.active.app.busi.bo.WelfareActiveAuditCreateReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveAuditCreateRspBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditRspBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantBusiBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActWelfarePointGrantChangeApproveBusiServiceImpl
implements ActWelfarePointGrantChangeApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActWelfarePointGrantChangeApproveBusiServiceImpl.class);
    @Autowired
    private WelfareActiveAuditOperateService welfareActiveAuditOperateService;
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;

    public ActWelfarePointGrantApproveAbilityRspBO createAuditOrder(ActWelfarePointGrantApproveAbilityReqBO reqBO) {
        ActWelfarePointGrantApproveAbilityRspBO rspBO = new ActWelfarePointGrantApproveAbilityRspBO();
        List changeIds = reqBO.getChangeIds();
        WelfarePointGrantBusiBO grantBusiBO = new WelfarePointGrantBusiBO();
        grantBusiBO.setChangeIdList(changeIds);
        List<WelfarePointsChangePO> changePOList = this.welfarePointsChangeMapper.selectChangeListBy(grantBusiBO);
        Map<Long, WelfarePointsChangePO> changeMap = changePOList.stream().collect(Collectors.toMap(WelfarePointsChangePO::getChangeId, c -> c));
        int failCount = 0;
        for (Long changeId : changeIds) {
            WelfarePointsChangePO changePO = changeMap.get(changeId);
            if (changePO != null) {
                if (!changePO.getChangeStatus().equals(ActCommConstant.WelfarePointsChangeApproveStatus.PASS)) continue;
                throw new BusinessException("8888", "\u53d8\u66f4id\u3010" + changeId + "\u3011\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7");
            }
            throw new BusinessException("8888", "\u53d8\u66f4id\u3010" + changeId + "\u3011\u53d1\u653e\u53d8\u66f4\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        for (Long changeId : changeIds) {
            WelfareActiveAuditCreateReqBO auditCreateReqBO = new WelfareActiveAuditCreateReqBO();
            auditCreateReqBO.setObjId(changeId.toString());
            auditCreateReqBO.setOrderId(changeId);
            auditCreateReqBO.setOrgId(reqBO.getOrgIdIn());
            auditCreateReqBO.setUserId(String.valueOf(reqBO.getUserId()));
            auditCreateReqBO.setUserName(reqBO.getName());
            auditCreateReqBO.setMenuId("M003005");
            auditCreateReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_GRANT_CHANGE_AUDIT);
            auditCreateReqBO.setProcDefKey("welfareGrantChange");
            WelfareActiveAuditCreateRspBO auditCreateRspBO = this.welfareActiveAuditOperateService.createAuditOrder(auditCreateReqBO);
            if ("0000".equals(auditCreateRspBO.getRespCode())) continue;
            log.error("\u53d8\u66f4id\u3010" + changeId + "\u3011\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c" + auditCreateRspBO.getRespDesc());
            ++failCount;
        }
        if (failCount > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u521b\u5efa\u5ba1\u6279\u5355\u6210\u529f");
        }
        return rspBO;
    }

    public ActWelfarePointGrantApproveAbilityRspBO dealAuditOrder(ActWelfarePointGrantApproveAbilityReqBO reqBO) {
        ActWelfarePointGrantApproveAbilityRspBO rspBO = new ActWelfarePointGrantApproveAbilityRspBO();
        WelfareActiveInvokeAuditReqBO invokeAuditReqBO = new WelfareActiveInvokeAuditReqBO();
        if (reqBO.getUserIdIn() == null) {
            reqBO.setUserIdIn(Long.valueOf(0L));
        }
        List changeIds = reqBO.getChangeIds();
        BeanUtils.copyProperties((Object)reqBO, (Object)invokeAuditReqBO);
        invokeAuditReqBO.setObjIds(new HashSet(changeIds));
        invokeAuditReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_GRANT_CHANGE_AUDIT);
        WelfareActiveInvokeAuditRspBO auditRspBO = this.welfareActiveAuditOperateService.invokeAuditOrder(invokeAuditReqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(auditRspBO.getRespDesc());
            return rspBO;
        }
        for (Long changeId : changeIds) {
            Boolean finishFlag = (Boolean)auditRspBO.getAuditFinishMap().get(changeId);
            if (!finishFlag.booleanValue()) continue;
            WelfarePointsChangePO pointsChangePO = new WelfarePointsChangePO();
            pointsChangePO.setChangeId(changeId);
            if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
                pointsChangePO.setChangeStatus(ActCommConstant.WelfarePointsChangeApproveStatus.PASS);
                pointsChangePO.setStatus(ActActiveConstant.GrantChangeStatus.APPROVE_PASS);
            } else if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.NOT_PASS)) {
                pointsChangePO.setChangeStatus(ActCommConstant.WelfarePointsChangeApproveStatus.REJECT);
                pointsChangePO.setStatus(ActActiveConstant.GrantChangeStatus.APPROVE_FAIL);
            }
            this.welfarePointsChangeMapper.updateByPrimaryKeySelective(pointsChangePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

