/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.bo.WelfareActiveApproveReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveApproveRspBO;
import com.tydic.active.app.busi.WelfareActiveApproveBusiService;
import com.tydic.active.app.busi.WelfareActiveAuditOperateService;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.uac.exception.BusinessException;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WelfareActiveApproveBusiServiceImpl
implements WelfareActiveApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(WelfareActiveApproveBusiServiceImpl.class);
    @Autowired
    private WelfareActiveAuditOperateService welfareActiveAuditOperateService;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;

    public WelfareActiveApproveRspBO activeApprove(WelfareActiveApproveReqBO reqBO) {
        WelfareActiveApproveRspBO rspBO = new WelfareActiveApproveRspBO();
        WelfareActivePO welfareActivePO = new WelfareActivePO();
        welfareActivePO.setActiveIds(reqBO.getActiveIds());
        List<WelfareActivePO> welfareActivePOList = this.welfareActiveMapper.selectListPageByCondition(welfareActivePO, (Page<WelfareActivePO>)new Page(-1, -1));
        if (CollectionUtils.isEmpty(welfareActivePOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return rspBO;
        }
        for (WelfareActivePO activePO : welfareActivePOList) {
            if (activePO.getActiveStatus().equals(ActCommConstant.WelfareActiveStatus.NOT_COMPLETE)) {
                throw new BusinessException("8888", "\u6d3b\u52a8\u3010" + activePO.getActiveCode() + "\u3011\u72b6\u6001\u9519\u8bef");
            }
            if (activePO.getAuditStatus().equals(ActCommConstant.WelfareActiveAuditStatus.IN_AUDIT)) continue;
            throw new BusinessException("8888", "\u6d3b\u52a8\u3010" + activePO.getActiveCode() + "\u3011\u5ba1\u6279\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u4e2d");
        }
        WelfareActiveInvokeAuditReqBO welfareActiveInvokeAuditReqBO = new WelfareActiveInvokeAuditReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)welfareActiveInvokeAuditReqBO);
        welfareActiveInvokeAuditReqBO.setObjIds(new HashSet(reqBO.getActiveIds()));
        welfareActiveInvokeAuditReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_ACTIVE_AUDIT);
        WelfareActiveInvokeAuditRspBO welfareActiveInvokeAuditRspBO = this.welfareActiveAuditOperateService.invokeAuditOrder(welfareActiveInvokeAuditReqBO);
        if (!"0000".equals(welfareActiveInvokeAuditRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(welfareActiveInvokeAuditRspBO.getRespDesc());
            return rspBO;
        }
        for (Long activeId : reqBO.getActiveIds()) {
            Boolean finishFlag = (Boolean)welfareActiveInvokeAuditRspBO.getAuditFinishMap().get(activeId);
            if (!finishFlag.booleanValue()) continue;
            WelfareActivePO updatePO = new WelfareActivePO();
            updatePO.setActiveId(activeId);
            if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
                updatePO.setActiveStatus(ActCommConstant.WelfareActiveStatus.ENABLE);
                updatePO.setAuditStatus(ActCommConstant.WelfareActiveAuditStatus.PASS);
            } else if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.NOT_PASS)) {
                updatePO.setAuditStatus(ActCommConstant.WelfareActiveAuditStatus.REJECT);
            }
            this.welfareActiveMapper.updateByPrimaryKeySelective(updatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

