/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.WelfareActiveCopyReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveCopyRspBO;
import com.tydic.active.app.busi.WelfareActiveCopyBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfareActiveAttachMapper;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfareActiveSkuMapper;
import com.tydic.active.app.dao.po.WelfareActiveAttachPO;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfareActiveSkuPO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WelfareActiveCopyBusiServiceImpl
implements WelfareActiveCopyBusiService {
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfareActiveAttachMapper welfareActiveAttachMapper;
    @Autowired
    private WelfareActiveSkuMapper welfareActiveSkuMapper;

    public WelfareActiveCopyRspBO copyActive(WelfareActiveCopyReqBO reqBO) {
        WelfareActiveCopyRspBO rspBO = new WelfareActiveCopyRspBO();
        WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(reqBO.getCopyActiveId());
        if (welfareActivePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u590d\u5236\u76ee\u6807\u6d3b\u52a8\u4e0d\u5b58\u5728,\u590d\u5236\u5931\u8d25\uff01");
            return rspBO;
        }
        Long activeId = Sequence.getInstance().nextId();
        WelfareActivePO copyWelfareActivePO = (WelfareActivePO)JSON.parseObject((String)JSON.toJSONString((Object)welfareActivePO), WelfareActivePO.class);
        copyWelfareActivePO.setCreateTime(new Date());
        copyWelfareActivePO.setActiveId(activeId);
        copyWelfareActivePO.setCreateName(reqBO.getName());
        copyWelfareActivePO.setCreateId(reqBO.getUserId());
        copyWelfareActivePO.setCreateCode(reqBO.getOccupation());
        copyWelfareActivePO.setCreateOrgId(reqBO.getOrgId());
        copyWelfareActivePO.setCreateOrgName(reqBO.getOrgName());
        copyWelfareActivePO.setCreateOrgCode(reqBO.getOrgCodeIn());
        copyWelfareActivePO.setActiveStatus(ActCommConstant.WelfareActiveStatus.NOT_COMPLETE);
        int insert = this.welfareActiveMapper.insert(copyWelfareActivePO);
        if (insert <= 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6d3b\u52a8\u4e3b\u4f53\u590d\u5236\u5931\u8d25\uff01");
            return rspBO;
        }
        List<WelfareActiveAttachPO> welfareActiveAttachPOS = this.welfareActiveAttachMapper.selectListByRelatedId(welfareActivePO.getActiveId());
        if (!CollectionUtils.isEmpty(welfareActiveAttachPOS)) {
            welfareActiveAttachPOS.forEach(welfareActiveAttachPO -> {
                welfareActiveAttachPO.setActiveId(activeId);
                welfareActiveAttachPO.setId(Sequence.getInstance().nextId());
            });
            int result = this.welfareActiveAttachMapper.insertBatch(welfareActiveAttachPOS);
            if (result != welfareActiveAttachPOS.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u9644\u4ef6\u63d2\u5165\u5931\u8d25\uff01");
                return rspBO;
            }
        }
        WelfareActiveSkuPO welfareActiveSkuPO = new WelfareActiveSkuPO();
        welfareActiveSkuPO.setActiveId(welfareActivePO.getActiveId());
        Page page = new Page(1, 1000);
        List<WelfareActiveSkuPO> welfareActiveSkuPOList = this.welfareActiveSkuMapper.selectListPageByCondition(welfareActiveSkuPO, (Page<WelfareActiveSkuPO>)page);
        if (page.getTotalPages() == 1) {
            this.copySku(welfareActiveSkuPOList, activeId);
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                welfareActiveSkuPOList = this.welfareActiveSkuMapper.selectListPageByCondition(welfareActiveSkuPO, (Page<WelfareActiveSkuPO>)page);
                this.copySku(welfareActiveSkuPOList, activeId);
            }
        }
        rspBO.setActiveId(activeId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void copySku(List<WelfareActiveSkuPO> welfareActiveSkuPOS, Long newActiveId) {
        if (!CollectionUtils.isEmpty(welfareActiveSkuPOS)) {
            welfareActiveSkuPOS.forEach(welfareActiveSkuPO -> {
                welfareActiveSkuPO.setActiveId(newActiveId);
                welfareActiveSkuPO.setId(Sequence.getInstance().nextId());
            });
            this.welfareActiveSkuMapper.insertBatch(welfareActiveSkuPOS);
        }
    }
}

