/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.timetask.impl;

import com.tydic.active.app.dao.ActActiveMerchantMapper;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.ActKillSkuMapper;
import com.tydic.active.app.dao.po.ActKillSkuPO;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import com.tydic.active.app.facde.ActUgcServiceHolder;
import com.tydic.active.app.timetask.ActRemoveKillPriceToUccTimeTaskService;
import com.tydic.active.app.timetask.bo.ActTimeTaskReqBO;
import com.tydic.active.app.timetask.bo.ActTimeTaskRspBO;
import com.tydic.active.app.utils.ActDateUtils;
import com.tydic.active.external.api.commodity.bo.ActSyncSceneCommodityToEsAbilityReqBO;
import com.tydic.active.external.api.common.bo.ActSpuEsForActivityBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.timetask.ActRemoveKillPriceToUccTimeTaskService"})
public class ActRemoveKillPriceToUccTimeTaskServiceImpl
implements ActRemoveKillPriceToUccTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ActRemoveKillPriceToUccTimeTaskServiceImpl.class);
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private ActKillSkuMapper actKillSkuMapper;
    @Autowired
    private ActUgcServiceHolder actUgcServiceHolder;
    @Autowired
    private ActActiveMerchantMapper actActiveMerchantMapper;

    @PostMapping(value={"execute"})
    public ActTimeTaskRspBO execute(@RequestBody ActTimeTaskReqBO actTimeTaskReqBO) {
        ActTimeTaskRspBO rsp = new ActTimeTaskRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u5f00\u59cb\u6267\u884c\u7ed9\u5546\u54c1\u4e2d\u5fc3\u53bb\u6389\u79d2\u6740\u4ef7\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("2");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (log.isDebugEnabled()) {
                log.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return rsp;
        }
        String nowTimeToDayStr = ActDateUtils.dateToStr(new Date());
        String nowTimeToHourStr = ActDateUtils.dateToStrHour(new Date());
        Date nowTimeToHour = ActDateUtils.strToDateLong(nowTimeToHourStr);
        List<ActKillSkuPO> actKillSkuPOs = this.actKillSkuMapper.getKillPriceAndSkuId(nowTimeToHour, nowTimeToDayStr, dictionaryPO.getTitle(), actTimeTaskReqBO.getShardingItem());
        if (!CollectionUtils.isEmpty(actKillSkuPOs)) {
            for (ActKillSkuPO po : actKillSkuPOs) {
                Set<Long> sceneIds = this.actActiveMerchantMapper.getSceneIds(po.getAdmOrgId(), null, po.getActiveId(), "10");
                ActSyncSceneCommodityToEsAbilityReqBO actSyncSceneCommodityToEsAbilityReqBO = new ActSyncSceneCommodityToEsAbilityReqBO();
                actSyncSceneCommodityToEsAbilityReqBO.setOperType(Integer.valueOf(1));
                actSyncSceneCommodityToEsAbilityReqBO.setSyncType(Integer.valueOf(2));
                if (!CollectionUtils.isEmpty(sceneIds)) {
                    actSyncSceneCommodityToEsAbilityReqBO.setSceneId(sceneIds.iterator().next());
                }
                ArrayList<ActSpuEsForActivityBO> spuEsForActivityBOS = new ArrayList<ActSpuEsForActivityBO>();
                ActSpuEsForActivityBO actSpuEsForActivityBO = new ActSpuEsForActivityBO();
                if (StringUtils.isNotBlank((CharSequence)po.getCommodityId())) {
                    actSpuEsForActivityBO.setCommodityId(Long.valueOf(po.getCommodityId()));
                }
                if (StringUtils.isNotBlank((CharSequence)po.getSkuId())) {
                    actSpuEsForActivityBO.setSkuId(Long.valueOf(po.getSkuId()));
                }
                spuEsForActivityBOS.add(actSpuEsForActivityBO);
                actSyncSceneCommodityToEsAbilityReqBO.setSpuEsForActivityBOS(spuEsForActivityBOS);
                this.actUgcServiceHolder.getActSyncSceneCommodityToEsAbilityService().syncSceneCommodityToEs(actSyncSceneCommodityToEsAbilityReqBO);
            }
        }
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u7ed9\u5546\u54c1\u4e2d\u5fc3\u53bb\u6389\u79d2\u6740\u4ef7\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        return rsp;
    }
}

