/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.WelfareActiveAuditProcessListPageService;
import com.tydic.active.app.ability.bo.ActApprovalLogBO;
import com.tydic.active.app.busi.bo.WelfareActiveAuditProcessListPageReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveAuditProcessListPageRspBO;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.WelfareActiveAuditProcessListPageService"})
public class WelfareActiveAuditProcessListPageServiceImpl
implements WelfareActiveAuditProcessListPageService {
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private UacOrdTaskMapper ordTaskMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;

    @PostMapping(value={"auditProcessListPage"})
    public WelfareActiveAuditProcessListPageRspBO auditProcessListPage(@RequestBody WelfareActiveAuditProcessListPageReqBO reqBO) {
        WelfareActiveAuditProcessListPageRspBO rspBO = new WelfareActiveAuditProcessListPageRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getObjId()) && reqBO.getOrderId() == null) {
            throw new BusinessException("8888", "objId \u548c orderId \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        ApprovalObjPO approvalObjPO = new ApprovalObjPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
        List list = this.approvalObjMapper.getList(approvalObjPO);
        if (list == null || list.size() < 1) {
            throw new BusinessException("8888", "\u5ba1\u6279\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ApprovalObjPO approvalObj = (ApprovalObjPO)list.get(0);
        for (ApprovalObjPO itemPO : list) {
            if (itemPO.getId() < approvalObj.getId()) continue;
            approvalObj = itemPO;
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setObjId(approvalObj.getObjId());
        uacQryAuditLogReqBO.setObjType(reqBO.getObjType());
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
            throw new BusinessException(uacQryAuditLogRspBO.getRespCode(), uacQryAuditLogRspBO.getRespDesc());
        }
        ArrayList<ActApprovalLogBO> approvalLogBOS = new ArrayList<ActApprovalLogBO>();
        String currentStepId = "";
        String nextStationId = "";
        Long auditOrderId = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List logRspBORows = uacQryAuditLogRspBO.getRows();
        if (logRspBORows != null && logRspBORows.size() > 0) {
            LocalDateTime lastDealTime = null;
            if (((ApprovalLogBO)logRspBORows.get(0)).getDealTime() != null) {
                lastDealTime = ((ApprovalLogBO)logRspBORows.get(0)).getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            for (int i = logRspBORows.size() - 1; i >= 0; --i) {
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)logRspBORows.get(i);
                ActApprovalLogBO uocApprovalLogBO = new ActApprovalLogBO();
                BeanUtils.copyProperties((Object)approvalLogBO, (Object)uocApprovalLogBO);
                if (approvalLogBO.getAuditResult() == null) {
                    uocApprovalLogBO.setAuditAdvice("");
                }
                currentStepId = approvalLogBO.getStepId();
                nextStationId = approvalLogBO.getNextStationId();
                auditOrderId = approvalLogBO.getAuditOrderId();
                uocApprovalLogBO.setUrgingFlag("0");
                LocalDateTime createTime = null;
                LocalDateTime dealTime = null;
                if (uocApprovalLogBO.getCreateTime() != null) {
                    createTime = uocApprovalLogBO.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setCreateTimeStr(df.format(createTime));
                }
                if (uocApprovalLogBO.getDealTime() != null) {
                    dealTime = uocApprovalLogBO.getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setDealTimeStr(df.format(dealTime));
                }
                if (createTime != null && dealTime != null) {
                    long seconds;
                    long minutes;
                    long hours;
                    Duration duration = Duration.between(createTime, dealTime);
                    StringBuilder durationTime = new StringBuilder();
                    long days = duration.toDays();
                    if (days > 0L) {
                        durationTime.append(days).append("\u5929");
                    }
                    if ((hours = duration.toHours()) > 0L) {
                        durationTime.append(hours).append("\u65f6");
                    }
                    if ((minutes = duration.toMinutes()) > 0L) {
                        durationTime.append(minutes).append("\u5206");
                    }
                    if ((seconds = duration.getSeconds()) > 60L) {
                        seconds /= 60L;
                    }
                    if (seconds > 0L) {
                        durationTime.append(seconds).append("\u79d2");
                    }
                    uocApprovalLogBO.setDurationTime(durationTime.toString());
                }
                approvalLogBOS.add(uocApprovalLogBO);
            }
        }
        if (!StringUtils.isBlank((CharSequence)nextStationId)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                for (UserBO itemBO : dycStationOrgSelectUserNameRspBO.getUserList()) {
                    ActApprovalLogBO uocApprovalLogBO = new ActApprovalLogBO();
                    uocApprovalLogBO.setOperName(itemBO.getName());
                    uocApprovalLogBO.setOperDept(itemBO.getCompanyFullName());
                    uocApprovalLogBO.setUrgingFlag("1");
                    approvalLogBOS.add(uocApprovalLogBO);
                }
            }
        }
        if (auditOrderId != null) {
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(reqBO.getOrderId());
            ordTaskPO.setObjId(auditOrderId);
            List ordTaskPOS = this.ordTaskMapper.getList(ordTaskPO);
            if (ordTaskPOS != null && ordTaskPOS.size() > 0) {
                rspBO.setProcDefId(((OrdTaskPO)ordTaskPOS.get(0)).getProcInstId());
            }
        }
        rspBO.setCurrentStepId(currentStepId);
        rspBO.setRows(approvalLogBOS);
        rspBO.setTotal(uacQryAuditLogRspBO.getTotalPages());
        rspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords());
        rspBO.setPageNo(uacQryAuditLogRspBO.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

