/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.ActImportResultLogAtomService;
import com.tydic.active.app.ability.WelfareActiveSkuAddAbilityService;
import com.tydic.active.app.ability.WelfareActiveSkuImportAbilityService;
import com.tydic.active.app.ability.bo.WelfareActiveSkuAddReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveSkuAddRspBO;
import com.tydic.active.app.ability.bo.WelfareActiveSkuBO;
import com.tydic.active.app.ability.bo.WelfareActiveSkuImportAbilityReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveSkuImportAbilityRspBO;
import com.tydic.active.app.busi.bo.ActImportResultLogAtomReqBO;
import com.tydic.active.app.busi.bo.ActImportResultLogAtomRspBO;
import com.tydic.active.app.utils.BatchImportUtils;
import com.tydic.commodity.common.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageBo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.WelfareActiveSkuImportAbilityService"})
public class WelfareActiveSkuImportAbilityServiceImpl
implements WelfareActiveSkuImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(WelfareActiveSkuImportAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private ActImportResultLogAtomService actImportResultLogAtomService;
    @Autowired
    private WelfareActiveSkuAddAbilityService welfareActiveSkuAddAbilityService;

    @PostMapping(value={"skuImport"})
    public WelfareActiveSkuImportAbilityRspBO skuImport(@RequestBody WelfareActiveSkuImportAbilityReqBO reqBO) {
        List<Map<String, Object>> importDataMap;
        WelfareActiveSkuImportAbilityRspBO rspBO = new WelfareActiveSkuImportAbilityRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u6587\u4ef6URL\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getActiveId() == null) {
            throw new BusinessException("8888", "\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ArrayList<WelfareActiveSkuBO> welfareActiveSkuBOList = new ArrayList<WelfareActiveSkuBO>();
        try {
            BatchImportUtils<WelfareActiveSkuBO> batchImportUtils = new BatchImportUtils<WelfareActiveSkuBO>(title, data, WelfareActiveSkuBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 6, 8, 3000);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        ArrayList<String> skuCodes = new ArrayList<String>();
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        for (Map<String, Object> map : importDataMap) {
            if (!map.get("impResult").toString().equals("0")) continue;
            skuCodes.add(String.valueOf(map.get("skuCode")));
        }
        if (!CollectionUtils.isEmpty(skuCodes)) {
            SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
            searchCommodityManageAbilityReqBo.setSkuCodes(skuCodes);
            SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo);
            if (!"0000".equals(searchCommodityManageAbilityRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u67e5\u8be2\u5931\u8d25:" + searchCommodityManageAbilityRspBo.getRespDesc());
            }
            Map skuCodeMap = searchCommodityManageAbilityRspBo.getResult().stream().collect(Collectors.toMap(SearchCommodityManageBo::getSkuCode, Function.identity(), (key1, key2) -> key2));
            for (Map<String, Object> map : importDataMap) {
                if (!map.get("impResult").toString().equals("0")) continue;
                WelfareActiveSkuBO welfareActiveSkuBO = (WelfareActiveSkuBO)JSON.parseObject((String)JSON.toJSONString(map), WelfareActiveSkuBO.class);
                SearchCommodityManageBo searchCommodityManageBo = (SearchCommodityManageBo)skuCodeMap.get(welfareActiveSkuBO.getSkuCode());
                if (searchCommodityManageBo != null) {
                    welfareActiveSkuBO.setBrand(searchCommodityManageBo.getBrandName());
                    welfareActiveSkuBO.setActiveId(reqBO.getActiveId());
                    welfareActiveSkuBO.setModel(searchCommodityManageBo.getModel());
                    welfareActiveSkuBO.setSpec(searchCommodityManageBo.getSpec());
                    welfareActiveSkuBO.setCatalogId(searchCommodityManageBo.getCatalogId());
                    welfareActiveSkuBO.setSkuId(searchCommodityManageBo.getSkuId());
                    welfareActiveSkuBO.setVendorId(searchCommodityManageBo.getVendorId());
                    welfareActiveSkuBO.setVendorName(searchCommodityManageBo.getVendorName());
                    welfareActiveSkuBO.setBuyPrice(searchCommodityManageBo.getSalePrice());
                    welfareActiveSkuBO.setWelfarePoint(searchCommodityManageBo.getSalePrice());
                    welfareActiveSkuBOList.add(welfareActiveSkuBO);
                    continue;
                }
                map.put("impRemark", "\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
                map.put("impResult", "1");
            }
            if (!CollectionUtils.isEmpty(welfareActiveSkuBOList)) {
                WelfareActiveSkuAddReqBO welfareActiveSkuAddReqBO = new WelfareActiveSkuAddReqBO();
                welfareActiveSkuAddReqBO.setWelfareActiveSkuList(welfareActiveSkuBOList);
                welfareActiveSkuAddReqBO.setActiveId(reqBO.getActiveId());
                WelfareActiveSkuAddRspBO welfareActiveSkuAddRspBO = this.welfareActiveSkuAddAbilityService.addActiveSku(welfareActiveSkuAddReqBO);
                if (!"0000".equals(welfareActiveSkuAddRspBO.getRespCode())) {
                    rspBO.setRespCode("8888");
                }
                rspBO.setRespDesc(welfareActiveSkuAddRspBO.getRespDesc());
                return rspBO;
            }
        }
        ActImportResultLogAtomReqBO actImportResultLogAtomReqBO = new ActImportResultLogAtomReqBO();
        actImportResultLogAtomReqBO.setMemId(reqBO.getUserId());
        actImportResultLogAtomReqBO.setImpType("ACTIVE_SKU_IMPORT");
        actImportResultLogAtomReqBO.setExportData(importDataMap);
        actImportResultLogAtomReqBO.setOutImpId(reqBO.getActiveId());
        ActImportResultLogAtomRspBO actImportResultLogAtomRspBO = this.actImportResultLogAtomService.importResultLog(actImportResultLogAtomReqBO);
        if (!actImportResultLogAtomRspBO.getRespCode().equals("0000")) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(actImportResultLogAtomRspBO.getRespDesc());
            return rspBO;
        }
        return rspBO;
    }
}

