/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActDeleteActiveRuleAtomService;
import com.tydic.active.app.atom.bo.ActDeleteActiveRuleAtomReqBO;
import com.tydic.active.app.atom.bo.ActDeleteActiveRuleAtomRspBO;
import com.tydic.active.app.dao.ActActiveRuleAttrMapper;
import com.tydic.active.app.dao.ActActiveRuleMapper;
import com.tydic.active.app.dao.po.ActActiveRuleAttrPO;
import com.tydic.active.app.dao.po.ActActiveRulePO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actDeleteActiveRuleAtomService")
public class ActDeleteActiveRuleAtomServiceImpl
implements ActDeleteActiveRuleAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActDeleteActiveRuleAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private ActActiveRuleMapper activeRuleMapper;
    @Autowired
    private ActActiveRuleAttrMapper activeRuleAttrMapper;

    @Override
    public ActDeleteActiveRuleAtomRspBO deleteActiveRule(ActDeleteActiveRuleAtomReqBO atomReqBO) {
        ActActiveRulePO rulePO = new ActActiveRulePO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)rulePO);
        int hasActiveId = this.activeRuleMapper.existsActiveId(rulePO);
        int hasRuleId = this.activeRuleMapper.existsRuleId(rulePO);
        if (hasActiveId < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u89c4\u5219\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\uff1aactiveId:[" + rulePO.getActiveId() + "]\u4e0d\u5b58\u5728");
            }
            throw new BusinessException("1003", "activeId:[" + rulePO.getActiveId() + "]\u4e0d\u5b58\u5728");
        }
        if (hasRuleId < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u89c4\u5219\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\uff1aactiveRuleId:[" + rulePO.getActiveRuleId() + "]\u4e0d\u5b58\u5728");
            }
            throw new BusinessException("1003", "activeRuleId:[" + rulePO.getActiveRuleId() + "]\u4e0d\u5b58\u5728");
        }
        ActDeleteActiveRuleAtomRspBO atomRspBO = new ActDeleteActiveRuleAtomRspBO();
        int delRuleResult = this.activeRuleMapper.deleteBy(rulePO);
        if (delRuleResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u89c4\u5219\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a\u5220\u9664\u6761\u6570:[" + delRuleResult + "]\u5c0f\u4e8e1");
            }
            throw new BusinessException("6022", "\u6d3b\u52a8\u89c4\u5219\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        ActActiveRuleAttrPO ruleAttrPO = new ActActiveRuleAttrPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)ruleAttrPO);
        int delRuleAttrResult = this.activeRuleAttrMapper.deleteBy(ruleAttrPO);
        if (delRuleAttrResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u89c4\u5219\u5c5e\u6027\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a\u5220\u9664\u6761\u6570:[" + delRuleAttrResult + "]\u5c0f\u4e8e1");
            }
            throw new BusinessException("6022", "\u89c4\u5219\u5c5e\u6027\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6d3b\u52a8\u89c4\u5219\u5220\u9664\u6210\u529f");
        return atomRspBO;
    }
}

