/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.tydic.active.app.atom.ActLadderCountFullReductionDiscountRateAtomService;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.active.app.common.bo.ActDiscountSkuListBO;
import com.tydic.active.app.common.bo.ActTemplateAttrBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import com.tydic.active.app.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderCountFullReductionDiscountRateAtomService")
public class ActLadderCountFullReductionDiscountRateAtomServiceImpl
implements ActLadderCountFullReductionDiscountRateAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderCountFullReductionDiscountRate(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalCount = totalCount.add(bo.getActCount());
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal countReachStar = new BigDecimal(0);
        BigDecimal countReachEnd = new BigDecimal(0);
        BigDecimal countReachDiscountRate = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("count_reach_star".equals(bo.getAttrCode())) {
                countReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("count_reach_end".equals(bo.getAttrCode())) {
                countReachEnd = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"count_reach_discountRate".equals(bo.getAttrCode())) continue;
            countReachDiscountRate = new BigDecimal(bo.getParaValue());
        }
        if (calculateMoney.compareTo(countReachStar) >= 0) {
            discountMoney = calculateMoney.subtract(calculateMoney.multiply(countReachDiscountRate));
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        BigDecimal alreadyDiscountPrice = discountMoney;
        for (int i = 0; i < atomReqBO.getSkuInfoList().size(); ++i) {
            if (i + 1 == atomReqBO.getSkuInfoList().size()) {
                skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), alreadyDiscountPrice);
                break;
            }
            BigDecimal moleculeTotalPrice = atomReqBO.getSkuInfoList().get(i).getTotalPrice().multiply(discountMoney).setScale(2, RoundingMode.HALF_UP);
            BigDecimal singelDiscountPrice = moleculeTotalPrice.divide(totalSalePrice, 2, RoundingMode.HALF_UP);
            skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), singelDiscountPrice);
            alreadyDiscountPrice = alreadyDiscountPrice.subtract(singelDiscountPrice);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

