/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.active.app.atom.ActCouponValidCheckAtomService;
import com.tydic.active.app.atom.ActReceiveCouponAtomService;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.active.app.atom.bo.ActReceiveCouponAtomReqBO;
import com.tydic.active.app.atom.bo.ActReceiveCouponAtomRspBO;
import com.tydic.active.app.busi.impl.ActReceiveCouponBusiServiceImpl;
import com.tydic.active.app.common.bo.CouponAttrBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.CouponAttrMapper;
import com.tydic.active.app.dao.CouponInstMapper;
import com.tydic.active.app.dao.CouponModMapper;
import com.tydic.active.app.dao.po.CouponAttrPO;
import com.tydic.active.app.dao.po.CouponInstPO;
import com.tydic.active.app.dao.po.CouponModPO;
import com.tydic.active.app.facde.ActUmcServiceHolder;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actReceiveCouponAtomService")
public class ActReceiveCouponAtomServiceImpl
implements ActReceiveCouponAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActReceiveCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private CouponInstMapper couponInstMapper;
    private CouponModMapper couponModMapper;
    private CouponAttrMapper couponAttrMapper;
    @Autowired
    private ActUmcServiceHolder actUmcServiceHolder;

    @Autowired
    public ActReceiveCouponAtomServiceImpl(ActCouponValidCheckAtomService actCouponValidCheckAtomService, CouponInstMapper couponInstMapper, CouponModMapper couponModMapper, CouponAttrMapper couponAttrMapper) {
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.couponInstMapper = couponInstMapper;
        this.couponModMapper = couponModMapper;
        this.couponAttrMapper = couponAttrMapper;
    }

    @Override
    public ActReceiveCouponAtomRspBO receiveCoupon(ActReceiveCouponAtomReqBO reqBO) {
        ActUmcReceiveCouponAbilityRspBO umcRspBO;
        ActReceiveCouponAtomRspBO rspBO = new ActReceiveCouponAtomRspBO();
        ActCouponValidCheckAtomReqBO checkAtomReqBO = new ActCouponValidCheckAtomReqBO();
        checkAtomReqBO.setCouponNo(reqBO.getCouponNo());
        ActCouponValidCheckAtomRspBO checkAtomRspBO = this.actCouponValidCheckAtomService.checkCouponValid(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
            rspBO.setRespCode("1021");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (!ActCommConstant.CouponValidMark.VALID.equals(checkAtomRspBO.getCouponValidMark())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        CouponInstPO couponInstPO = this.couponInstMapper.getModelById(reqBO.getCouponNo());
        if (null == couponInstPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25,\u8fd4\u56de\u7ed3\u679c\u4e3anull");
            }
            rspBO.setRespCode("1023");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        String couponValue = null;
        String couponJson = null;
        if (!ActCommConstant.CouponTypeCode.FREIGHT_FREE_ALL.equals(couponInstPO.getCouponType())) {
            CouponModPO couponModPO = new CouponModPO();
            couponModPO.setFmId(couponInstPO.getFmId());
            couponModPO.setTemplateType(Integer.valueOf("1"));
            CouponModPO modPO = this.couponModMapper.getModelBy(couponModPO);
            if (null == modPO) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u4fe1\u606f\u5931\u8d25,\u8fd4\u56de\u7ed3\u679c\u4e3anull");
                }
                rspBO.setRespCode("1023");
                rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
                return rspBO;
            }
            CouponAttrPO couponAttrPO = new CouponAttrPO();
            couponAttrPO.setFmId(couponInstPO.getFmId());
            List<CouponAttrPO> attrPOList = this.couponAttrMapper.getList(couponAttrPO);
            if (!CollectionUtils.isEmpty(attrPOList)) {
                ArrayList<CouponAttrBO> attrBOList = new ArrayList<CouponAttrBO>();
                for (CouponAttrPO attrPO : attrPOList) {
                    if (modPO.getTemplateId().equals(attrPO.getTemplateId())) {
                        couponValue = attrPO.getParaValue();
                    }
                    CouponAttrBO couponAttrBO = new CouponAttrBO();
                    BeanUtils.copyProperties((Object)attrPO, (Object)couponAttrBO);
                    attrBOList.add(couponAttrBO);
                }
                couponJson = JSON.toJSONString(attrBOList);
            }
        }
        if (!"0000".equals((umcRspBO = this.callMemCouponReceiveService(reqBO, couponInstPO, checkAtomRspBO, couponValue, couponJson)).getRespCode())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f18\u60e0\u5238\u9886\u53d6\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            }
            rspBO.setRespCode("1022");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25" + umcRspBO.getRespDesc());
            return rspBO;
        }
        int result = this.updateCouponInst(reqBO);
        if (result < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25\uff0cupdate\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            rspBO.setRespCode("1024");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f");
        return rspBO;
    }

    private ActUmcReceiveCouponAbilityRspBO callMemCouponReceiveService(ActReceiveCouponAtomReqBO reqBO, CouponInstPO couponInstPO, ActCouponValidCheckAtomRspBO checkAtomRspBO, String couponValue, String couponJson) {
        return null;
    }

    private int updateCouponInst(ActReceiveCouponAtomReqBO reqBO) {
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        couponInstPO.setMemId(reqBO.getMemId().toString());
        couponInstPO.setState(ActCommConstant.CouponState.TO_BE_USED);
        return this.couponInstMapper.updateById(couponInstPO);
    }
}

