/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.timetask.impl;

import com.tydic.active.app.busi.ActUpdateCouponStatusBusiService;
import com.tydic.active.app.busi.bo.ActUpdateCouponStatusBusiReqBO;
import com.tydic.active.app.busi.bo.ActUpdateCouponStatusBusiRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.CouponInstMapper;
import com.tydic.active.app.dao.po.CouponInstPO;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import com.tydic.active.app.timetask.ActUpdateCouponStatusTimeTaskService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.timetask.ActUpdateCouponStatusTimeTaskService"})
public class ActUpdateCouponStatusTimeTaskServiceImpl
implements ActUpdateCouponStatusTimeTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActUpdateCouponStatusTimeTaskServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private ActDicDictionaryMapper actDicDictionaryMapper;
    private CouponInstMapper couponInstMapper;
    private ActUpdateCouponStatusBusiService actUpdateCouponStatusBusiService;

    @Autowired
    public ActUpdateCouponStatusTimeTaskServiceImpl(ActDicDictionaryMapper actDicDictionaryMapper, CouponInstMapper couponInstMapper, ActUpdateCouponStatusBusiService actUpdateCouponStatusBusiService) {
        this.actDicDictionaryMapper = actDicDictionaryMapper;
        this.couponInstMapper = couponInstMapper;
        this.actUpdateCouponStatusBusiService = actUpdateCouponStatusBusiService;
    }

    @PostMapping(value={"execute"})
    public void execute(@RequestBody String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u5f00\u59cb\u6267\u884c\u4f18\u60e0\u5238\u72b6\u6001\u6821\u9a8c\u53ca\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("MSC_totalShardCount");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return;
        }
        Date now = new Date();
        List<CouponInstPO> couponInstPOList = this.couponInstMapper.select4UpdateStateTimeTask(dictionaryPO.getTitle(), currentShardValue, now);
        ActUpdateCouponStatusBusiReqBO updateCouponStatusBusiReqBO = new ActUpdateCouponStatusBusiReqBO();
        for (CouponInstPO couponInstPO : couponInstPOList) {
            if (now.before(couponInstPO.getEffTime())) {
                updateCouponStatusBusiReqBO.setState(ActCommConstant.CouponState.CREATED);
            } else if (now.after(couponInstPO.getExpTime())) {
                updateCouponStatusBusiReqBO.setState(ActCommConstant.CouponState.EXPIRED);
            } else if (now.after(couponInstPO.getEffTime()) && now.before(couponInstPO.getExpTime())) {
                if (null == couponInstPO.getMemId()) {
                    updateCouponStatusBusiReqBO.setState(ActCommConstant.CouponState.TO_BE_RECEIVED);
                } else {
                    updateCouponStatusBusiReqBO.setState(ActCommConstant.CouponState.TO_BE_USED);
                }
            }
            updateCouponStatusBusiReqBO.setCouponNo(couponInstPO.getCouponNo());
            ActUpdateCouponStatusBusiRspBO updateCouponStatusBusiRspBO = this.actUpdateCouponStatusBusiService.updateCouponStatus(updateCouponStatusBusiReqBO);
            if ("0000".equals(updateCouponStatusBusiRspBO.getRespCode())) continue;
            LOGGER.error("\u4f18\u60e0\u5238\u72b6\u6001\u6821\u9a8c\u53ca\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u72b6\u6001\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01" + updateCouponStatusBusiRspBO.getRespDesc());
        }
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u4f18\u60e0\u5238\u72b6\u6001\u6821\u9a8c\u53ca\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
    }
}

