/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.tydic.active.app.ability.ActUpdateWelfareActiveStatusTimeTaskService;
import com.tydic.active.app.ability.bo.ActUpdateWelfareActiveStatusTimeTaskReqBO;
import com.tydic.active.app.ability.bo.ActUpdateWelfareActiveStatusTimeTaskRspBO;
import com.tydic.active.app.busi.WelfareActiveSkuSyncService;
import com.tydic.active.app.busi.bo.WelfareActiveSkuSyncReqBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfareActiveSkuMapper;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActUpdateWelfareActiveStatusTimeTaskService"})
public class ActUpdateWelfareActiveStatusTimeTaskServiceImpl
implements ActUpdateWelfareActiveStatusTimeTaskService {
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfareActiveSkuMapper welfareActiveSkuMapper;
    @Autowired
    private WelfareActiveSkuSyncService welfareActiveSkuSyncService;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;

    @PostMapping(value={"updateWelfareActiveStatus"})
    public ActUpdateWelfareActiveStatusTimeTaskRspBO updateWelfareActiveStatus(@RequestBody ActUpdateWelfareActiveStatusTimeTaskReqBO reqBO) {
        ActUpdateWelfareActiveStatusTimeTaskRspBO rspBO = new ActUpdateWelfareActiveStatusTimeTaskRspBO();
        List<WelfareActivePO> validList = this.welfareActiveMapper.selectValidActivity("4", reqBO.getShardingItem());
        List<WelfareActivePO> invalidLIst = this.welfareActiveMapper.selectInValidActivity("4", reqBO.getShardingItem());
        this.sync(validList, 1, ActCommConstant.WelfareActiveStatus.VALID);
        this.sync(invalidLIst, 0, ActCommConstant.WelfareActiveStatus.INVALID);
        List<Long> invalidIds = this.welfarePointGrantMapper.qryIdsByTime();
        if (!CollectionUtils.isEmpty(invalidIds)) {
            for (Long invalidId : invalidIds) {
                WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                welfarePointGrantPO.setWelfarePointGrantId(invalidId);
                welfarePointGrantPO.setStatus(ActActiveConstant.GrantStatus.INVALID);
                this.welfarePointGrantMapper.updateByPrimaryKeySelective(welfarePointGrantPO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        return rspBO;
    }

    private void sync(List<WelfareActivePO> list, Integer dealType, Byte status) {
        for (WelfareActivePO activePO : list) {
            WelfareActiveSkuSyncReqBO welfareActiveSkuSyncReqBO = new WelfareActiveSkuSyncReqBO();
            welfareActiveSkuSyncReqBO.setActiveId(activePO.getActiveId());
            List<Long> skuIdList = this.welfareActiveSkuMapper.selectSkuIdByActiveId(activePO.getActiveId());
            if (!CollectionUtils.isEmpty(skuIdList)) {
                welfareActiveSkuSyncReqBO.setSkuIds(skuIdList);
                welfareActiveSkuSyncReqBO.setDealType(dealType);
                this.welfareActiveSkuSyncService.syncUcc(welfareActiveSkuSyncReqBO);
            }
            WelfareActivePO updatePO = new WelfareActivePO();
            updatePO.setActiveId(activePO.getActiveId());
            updatePO.setActiveStatus(status);
            this.welfareActiveMapper.updateByPrimaryKeySelective(updatePO);
        }
    }
}

