/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.active.app.ability.WelfareActiveSubmitAbilityService;
import com.tydic.active.app.ability.bo.WelfareActiveSubmitReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveSubmitRspBO;
import com.tydic.active.app.atom.bo.WelfareSendNotificationAtomReqBO;
import com.tydic.active.app.busi.WelfareActiveSubmitBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.WelfareActiveSubmitAbilityService"})
public class WelfareActiveSubmitAbilityServiceImpl
implements WelfareActiveSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(WelfareActiveSubmitAbilityServiceImpl.class);
    @Autowired
    private WelfareActiveSubmitBusiService welfareActiveSubmitBusiService;
    @Value(value="${es.WELFARE_NOTIFICATION_TOPIC:WELFARE_NOTIFICATION_TOPIC}")
    private String welfareNotificationTopic;
    @Value(value="${es.WELFARE_NOTIFICATION_TAG:WELFARE_NOTIFICATION_TAG}")
    private String welfareNotificationTag;
    @Resource(name="welfareNotificationMqServiceProvider")
    private ProxyMessageProducer welfareNotificationMqServiceProvider;

    @PostMapping(value={"submitWelfareActive"})
    public WelfareActiveSubmitRspBO submitWelfareActive(@RequestBody WelfareActiveSubmitReqBO reqBO) {
        if (reqBO.getActiveId() == null) {
            throw new BusinessException("8888", "\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        WelfareActiveSubmitRspBO rspBO = this.welfareActiveSubmitBusiService.submitWelfareActive(reqBO);
        if (rspBO.getRespCode().equals("0000") && reqBO.getSubmitType().equals(ActCommConstant.SubmitType.SUBMIT)) {
            WelfareSendNotificationAtomReqBO sendNotificationAtomReqBO = new WelfareSendNotificationAtomReqBO();
            sendNotificationAtomReqBO.setFinish(false);
            sendNotificationAtomReqBO.setUserId(reqBO.getUserId());
            sendNotificationAtomReqBO.setObjId(reqBO.getActiveId());
            sendNotificationAtomReqBO.setNotificationType(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_ACTIVE_AUDIT);
            this.welfareNotificationMqServiceProvider.send(new ProxyMessage(this.welfareNotificationTopic, this.welfareNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationAtomReqBO))));
        }
        return rspBO;
    }
}

