/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DuplicateCommitLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCommitLimitAspect.class);
    @Autowired
    private CacheClient cacheService;
    @Value(value="${uoc.commit.limit:true}")
    private boolean limit;

    @Pointcut(value="@annotation(com.tydic.active.app.aop.DuplicateCommitLimit)")
    public void duplicateCommitLimit() {
    }

    @Before(value="duplicateCommitLimit()")
    public void deBefore(JoinPoint joinPoint) throws Throwable {
        if (!this.limit) {
            return;
        }
        String reqMd = null;
        Object[] args = joinPoint.getArgs();
        if (null != args && args.length > 0) {
            block11: {
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    reqMd = Hex.encodeHexString((byte[])md.digest(JSON.toJSONString((Object)args[0]).getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    log.error("NoSuchAlgorithmException error:{}", (Throwable)e);
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
                    Long userIdIn = (Long)jsonObject.get((Object)"userId");
                    if (null == userIdIn || 0L == userIdIn) break block11;
                    reqMd = userIdIn + joinPoint.toShortString();
                }
            }
            if (null != reqMd) {
                Object o = null;
                try {
                    o = this.cacheService.get(reqMd);
                }
                catch (Exception e) {
                    log.error("Exception error:{}", (Throwable)e);
                    reqMd = null;
                }
                if (null != o) {
                    throw new ZTBusinessException("30\u79d2\u5185\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5355\u636e");
                }
                if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)"", 30);
                    }
                    catch (Exception e) {
                        log.error("Exception error:{}", (Throwable)e);
                    }
                }
            }
        }
    }
}

