/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActActivityCheckAtomService;
import com.tydic.active.app.atom.ActQryTemplateAtomService;
import com.tydic.active.app.atom.ActQryTemplateGroupAtomService;
import com.tydic.active.app.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.active.app.atom.bo.ActCreateActivityCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActCreateActivityCheckAtomRspBO;
import com.tydic.active.app.atom.bo.ActQryTemplateAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryTemplateAtomRspBO;
import com.tydic.active.app.atom.bo.ActQryTemplateGroupAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryTemplateGroupAtomRspBO;
import com.tydic.active.app.common.bo.ActActiveCommonInfoBO;
import com.tydic.active.app.common.bo.ActActiveShowPozitionBO;
import com.tydic.active.app.common.bo.ActDiscountBO;
import com.tydic.active.app.common.bo.ActMemRangeBO;
import com.tydic.active.app.common.bo.ActMerchantInfoBO;
import com.tydic.active.app.common.bo.ActSkuScopeBO;
import com.tydic.active.app.common.bo.ActTemplateAttrBO;
import com.tydic.active.app.common.bo.ActTemplateBO;
import com.tydic.active.app.common.bo.ActTemplateGroupBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActActiveMerchantMapper;
import com.tydic.active.app.dao.po.ActActiveMerchantPO;
import com.tydic.active.app.facde.ActUgcServiceHolder;
import com.tydic.active.external.api.commodity.bo.ActQryMerchantsBySceneReqBO;
import com.tydic.active.external.api.commodity.bo.ActQryMerchantsBySceneRspBO;
import com.tydic.active.external.api.common.bo.ActExtMerchantsInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityCheckAtomService")
public class ActActivityCheckAtomServiceImpl
implements ActActivityCheckAtomService {
    @Autowired
    private ActQryTemplateGroupAtomService actQryTemplateGroupAtomService;
    @Autowired
    private ActQryTemplateAtomService actQryTemplateAtomService;
    @Autowired
    private ActSelectDictByCodeAndPcodeAtomService actSelectDictByCodeAndPcodeAtomService;
    @Autowired
    private ActUgcServiceHolder actUgcServiceHolder;
    @Autowired
    private ActActiveMerchantMapper actActiveMerchantMapper;

    @Override
    public ActCreateActivityCheckAtomRspBO checkCreateActivityInfo(ActCreateActivityCheckAtomReqBO atomReqBO) {
        ActCreateActivityCheckAtomRspBO atomRspBO = new ActCreateActivityCheckAtomRspBO();
        ArrayList<ActDiscountBO> actDiscountBOs = new ArrayList<ActDiscountBO>();
        ActActiveCommonInfoBO actActiveCommonInfoBO = atomReqBO.getActActiveCommonInfoBO();
        if (null != actActiveCommonInfoBO) {
            this.checkActiveTemplateGroup(actActiveCommonInfoBO, atomReqBO, actDiscountBOs);
            this.checkActiveTemplate(actActiveCommonInfoBO.getActTemplateBOS(), actDiscountBOs);
            this.checkActiveMerchant(actActiveCommonInfoBO, atomReqBO);
            this.checkSkuInfoList(actActiveCommonInfoBO, atomReqBO.getRangeType());
            this.checkShowPozitonList(actActiveCommonInfoBO);
            this.checkMemRangeList(actActiveCommonInfoBO);
        }
        if ("add".equals(atomReqBO.getOperType())) {
            this.setDefaultValue(atomReqBO);
        }
        atomRspBO.setActDiscountBOs(actDiscountBOs);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return atomRspBO;
    }

    private void setDefaultValue(ActCreateActivityCheckAtomReqBO atomReqBO) {
        ActActiveCommonInfoBO actActiveCommonInfoBO = atomReqBO.getActActiveCommonInfoBO() == null ? new ActActiveCommonInfoBO() : atomReqBO.getActActiveCommonInfoBO();
        atomReqBO.setActActiveCommonInfoBO(actActiveCommonInfoBO);
        if (ActCommConstant.SendTarget.SCENE.equals(actActiveCommonInfoBO.getSendTarget())) {
            if (actActiveCommonInfoBO.getSceneId() == null) {
                throw new BusinessException("14001", "\u573a\u666fID\u3010sceneId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actActiveCommonInfoBO.getMerchantInfoBOlist())) {
                this.getMerchant(actActiveCommonInfoBO);
            }
        } else {
            actActiveCommonInfoBO.setSendTarget(ActCommConstant.SendTarget.ENTERPRISE);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actActiveCommonInfoBO.getMerchantInfoBOlist())) {
                ActMerchantInfoBO actMerchantInfoBO = new ActMerchantInfoBO();
                actMerchantInfoBO.setMerchantId(Long.valueOf(Long.parseLong(atomReqBO.getOrgIdIn())));
                ArrayList<ActMerchantInfoBO> merchantInfoBOlist = new ArrayList<ActMerchantInfoBO>();
                merchantInfoBOlist.add(actMerchantInfoBO);
                actActiveCommonInfoBO.setMerchantInfoBOlist(merchantInfoBOlist);
            }
        }
        this.checkActiveMerchant(actActiveCommonInfoBO, atomReqBO);
        if ("10".equals(atomReqBO.getMarketingType())) {
            this.getDefaultTemplateGroup(actActiveCommonInfoBO, atomReqBO.getActiveType());
        }
    }

    private void checkMemRangeList(ActActiveCommonInfoBO actActiveCommonInfoBO) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)actActiveCommonInfoBO.getMemRangeList())) {
            Map<String, String> memParamType = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "MEM_PARAM_TYPE");
            if (CollectionUtils.isEmpty(memParamType)) {
                throw new BusinessException("14001", "\u6682\u4e0d\u652f\u6301\u4f1a\u5458\u8303\u56f4\u914d\u7f6e");
            }
            for (ActMemRangeBO bo : actActiveCommonInfoBO.getMemRangeList()) {
                String memParamTypeCode = memParamType.get(bo.getMemParamType());
                if (memParamTypeCode == null) {
                    throw new BusinessException("14001", "\u4f1a\u5458\u53c2\u6570\u7c7b\u578b\u3010" + bo.getMemParamType() + "\u6682\u4e0d\u652f\u6301\u3011");
                }
                if (StringUtils.isBlank((CharSequence)bo.getParamInsCode())) {
                    throw new BusinessException("14001", "\u4f1a\u5458\u53c2\u6570\u5b9e\u4f8b\u7f16\u7801\u3010paramInsCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getParamInsName())) continue;
                throw new BusinessException("14001", "\u4f1a\u5458\u53c2\u6570\u5b9e\u4f8b\u540d\u79f0\u3010paramInsName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void checkShowPozitonList(ActActiveCommonInfoBO actActiveCommonInfoBO) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)actActiveCommonInfoBO.getShowPozitonList())) {
            Map<String, String> positionCode = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "POSITION_CODE");
            if (CollectionUtils.isEmpty(positionCode)) {
                throw new BusinessException("14002", "\u6682\u4e0d\u652f\u6301\u6309\u5c55\u793a\u4f4d\u7f6e\u914d\u7f6e");
            }
            for (ActActiveShowPozitionBO bo : actActiveCommonInfoBO.getShowPozitonList()) {
                if (StringUtils.isBlank((CharSequence)bo.getPozitionCode())) {
                    throw new BusinessException("14001", "\u4f4d\u7f6e\u7f16\u7801\u3010pozitionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String positionCodeName = positionCode.get(bo.getPozitionCode());
                if (positionCodeName != null) continue;
                throw new BusinessException("14002", "\u4f4d\u7f6e\u7f16\u7801\u3010" + bo.getPozitionCode() + "\u6682\u4e0d\u652f\u6301\u3011");
            }
        }
    }

    private void checkSkuInfoList(ActActiveCommonInfoBO actActiveCommonInfoBO, Integer rangeType) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)actActiveCommonInfoBO.getSkuInfoList())) {
            if (null == rangeType) {
                throw new BusinessException("14001", "\u6821\u9a8c\u6d3b\u52a8\u8303\u56f4\u4fe1\u606f\u3010rangeType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ActCommConstant.DiscountSkuRange.PLATFORM.equals(rangeType)) {
                actActiveCommonInfoBO.setSkuInfoList(null);
                return;
            }
            for (ActSkuScopeBO actSkuScopeBO : actActiveCommonInfoBO.getSkuInfoList()) {
                if (StringUtils.isBlank((CharSequence)actSkuScopeBO.getRangeId())) {
                    throw new BusinessException("14001", "[rangeId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                actSkuScopeBO.setRangeType(rangeType);
            }
        }
    }

    private void checkActiveMerchant(ActActiveCommonInfoBO actActiveCommonInfoBO, ActCreateActivityCheckAtomReqBO atomReqBO) {
        block5: {
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)actActiveCommonInfoBO.getMerchantInfoBOlist())) break block5;
            if (ActCommConstant.SendTarget.SCENE.equals(actActiveCommonInfoBO.getSendTarget())) {
                if ("update".equals(atomReqBO.getOperType())) {
                    ActActiveMerchantPO record = new ActActiveMerchantPO();
                    record.setActiveId(atomReqBO.getActiveId());
                    record.setAdmOrgId(atomReqBO.getOrgIdIn());
                    record.setMarketingType(atomReqBO.getMarketingType());
                    List<ActMerchantInfoBO> actActiveMerchantPOS = this.actActiveMerchantMapper.getListByRecord(record);
                    actActiveCommonInfoBO.setSceneId(actActiveMerchantPOS.get(0).getSceneId());
                    actActiveCommonInfoBO.setSceneName(actActiveMerchantPOS.get(0).getSceneName());
                }
                for (ActMerchantInfoBO actMerchantInfoBO : actActiveCommonInfoBO.getMerchantInfoBOlist()) {
                    actMerchantInfoBO.setSceneId(actActiveCommonInfoBO.getSceneId());
                    actMerchantInfoBO.setSceneName(actActiveCommonInfoBO.getSceneName());
                    if (actMerchantInfoBO.getMerchantId() != null) continue;
                    throw new BusinessException("14001", " \u5546\u6237ID\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else {
                for (ActMerchantInfoBO actMerchantInfoBO : actActiveCommonInfoBO.getMerchantInfoBOlist()) {
                    actMerchantInfoBO.setSceneId(null);
                    actMerchantInfoBO.setSceneName(null);
                    if (actMerchantInfoBO.getMerchantId() != null) continue;
                    throw new BusinessException("14001", " \u5546\u6237ID\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }

    private void getMerchant(ActActiveCommonInfoBO actActiveCommonInfoBO) {
        ActQryMerchantsBySceneReqBO actQryMerchantsBySceneReqBO = new ActQryMerchantsBySceneReqBO();
        ArrayList<Long> sceneIds = new ArrayList<Long>();
        sceneIds.add(actActiveCommonInfoBO.getSceneId());
        actQryMerchantsBySceneReqBO.setSceneIds(sceneIds);
        ActQryMerchantsBySceneRspBO actQryMerchantsBySceneRspBO = this.actUgcServiceHolder.getActQryMerchantsBySceneAbilityService().qryMerchantsByScene(actQryMerchantsBySceneReqBO);
        if (!"0000".equals(actQryMerchantsBySceneRspBO.getRespCode())) {
            throw new BusinessException(actQryMerchantsBySceneRspBO.getRespCode(), actQryMerchantsBySceneRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)actQryMerchantsBySceneRspBO.getMerchantsInfoBOList())) {
            throw new BusinessException("14003", "\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        }
        List actExtMerchantsInfoBOs = actQryMerchantsBySceneRspBO.getMerchantsInfoBOList();
        ArrayList<ActMerchantInfoBO> merchantInfoBOlist = new ArrayList<ActMerchantInfoBO>();
        for (ActExtMerchantsInfoBO bo : actExtMerchantsInfoBOs) {
            ActMerchantInfoBO actMerchantInfoBO = new ActMerchantInfoBO();
            actMerchantInfoBO.setSceneId(bo.getSceneId());
            actMerchantInfoBO.setSceneName(bo.getSceneName());
            actMerchantInfoBO.setMerchantId(bo.getSupplierId());
            actMerchantInfoBO.setMerchantName(bo.getSupplierName());
            merchantInfoBOlist.add(actMerchantInfoBO);
        }
        actActiveCommonInfoBO.setMerchantInfoBOlist(merchantInfoBOlist);
    }

    private void checkActiveTemplate(List<ActTemplateBO> paramActTemplateBOS, List<ActDiscountBO> actDiscountBOs) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(paramActTemplateBOS)) {
            ActQryTemplateAtomReqBO actQryTemplateAtomReqBO = new ActQryTemplateAtomReqBO();
            ActQryTemplateAtomRspBO atomRspBO = this.actQryTemplateAtomService.qryTemplate(actQryTemplateAtomReqBO);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)atomRspBO.getRows())) {
                throw new BusinessException("14031", "\u6a21\u677f\u672a\u914d\u7f6e");
            }
            this.checkTemplate(atomRspBO.getRows(), paramActTemplateBOS, actDiscountBOs);
        }
    }

    private void checkActiveTemplateGroup(ActActiveCommonInfoBO actActiveCommonInfoBO, ActCreateActivityCheckAtomReqBO atomReqBO, List<ActDiscountBO> actDiscountBOs) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actActiveCommonInfoBO.getActTemplateGroupBOList())) {
            ActQryTemplateGroupAtomReqBO atomReqBO1 = new ActQryTemplateGroupAtomReqBO();
            atomReqBO1.setActiveType(atomReqBO.getActiveType());
            ActQryTemplateGroupAtomRspBO atomRspBO = this.actQryTemplateGroupAtomService.qryTemplateGroup(atomReqBO1);
            List confActTemplateGroupBOList = atomRspBO.getRows();
            HashMap<Long, ActTemplateGroupBO> confActTemplateGroupMap = new HashMap<Long, ActTemplateGroupBO>();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)confActTemplateGroupBOList)) {
                for (ActTemplateGroupBO actTemplateGroupBO : confActTemplateGroupBOList) {
                    confActTemplateGroupMap.put(actTemplateGroupBO.getTemplateGroupId(), actTemplateGroupBO);
                }
            } else {
                throw new BusinessException("14030", "\u6d3b\u52a8\u7c7b\u578b\u3010" + atomReqBO.getActiveType() + "\u3011\u5bf9\u5e94\u6a21\u677f\u7ec4\u672a\u914d\u7f6e");
            }
            for (ActTemplateGroupBO actTemplateGroupBO : actActiveCommonInfoBO.getActTemplateGroupBOList()) {
                if (actTemplateGroupBO.getTemplateGroupId() == null) {
                    throw new BusinessException("14001", "\u6a21\u677f\u7ec4ID\u4e3a\u7a7a");
                }
                ActTemplateGroupBO confActTemplateGroupBO = (ActTemplateGroupBO)confActTemplateGroupMap.get(actTemplateGroupBO.getTemplateGroupId());
                if (confActTemplateGroupBO == null) {
                    throw new BusinessException("14030", "\u6a21\u677f\u7ec4\u3010" + actTemplateGroupBO.getTemplateGroupId() + "\u3011\u4e0d\u662f\u6d3b\u52a8\u7c7b\u578b\u4e3a\u3010" + atomReqBO.getActiveType() + "\u3011\u7684\u6a21\u677f\u7ec4");
                }
                this.checkTemplate(confActTemplateGroupBO.getActTemplateBOS(), actTemplateGroupBO.getActTemplateBOS(), actDiscountBOs);
                actTemplateGroupBO.setTemplateGroupOrder(confActTemplateGroupBO.getTemplateGroupOrder());
                actTemplateGroupBO.setTemplateGroupType(confActTemplateGroupBO.getTemplateGroupType());
            }
        }
    }

    private void checkTemplate(List<ActTemplateBO> confActTemplateBOS, List<ActTemplateBO> paramActTemplateBOS, List<ActDiscountBO> actDiscountBOs) {
        HashMap<Long, ActTemplateBO> confTemplateMap = new HashMap<Long, ActTemplateBO>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(confActTemplateBOS)) {
            for (ActTemplateBO actTemplateBO : confActTemplateBOS) {
                confTemplateMap.put(actTemplateBO.getTemplateId(), actTemplateBO);
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(paramActTemplateBOS)) {
            for (ActTemplateBO paramActTemplateBO : paramActTemplateBOS) {
                if (paramActTemplateBO.getTemplateId() == null) {
                    throw new BusinessException("14001", "\u6a21\u677fID\u4e3a\u7a7a");
                }
                ActTemplateBO confActTemplateBO = (ActTemplateBO)confTemplateMap.get(paramActTemplateBO.getTemplateId());
                if (null == confActTemplateBO) {
                    throw new BusinessException("14031", "\u6a21\u677fID\u3010" + paramActTemplateBO.getTemplateId() + "\u3011\u4e0d\u7b26\u5408\u914d\u7f6e");
                }
                this.commonCheckTemplateAttr(confActTemplateBO, paramActTemplateBO);
                Integer validMod = confActTemplateBO.getValidMod();
                switch (validMod) {
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    default: {
                        this.systemCheckActiveTemplateAttr(paramActTemplateBO, actDiscountBOs);
                    }
                }
                paramActTemplateBO.setTemplateType(confActTemplateBO.getTemplateType());
                paramActTemplateBO.setTemplateOrder(confActTemplateBO.getTemplateOrder());
            }
        }
    }

    private void getDefaultTemplateGroup(ActActiveCommonInfoBO actActiveCommonInfoBO, String activeType) {
        ActQryTemplateGroupAtomReqBO actQryTemplateGroupAtomReqBO = new ActQryTemplateGroupAtomReqBO();
        actQryTemplateGroupAtomReqBO.setActiveType(activeType);
        ActQryTemplateGroupAtomRspBO actQryTemplateGroupAtomRspBO = this.actQryTemplateGroupAtomService.qryTemplateGroup(actQryTemplateGroupAtomReqBO);
        if (!"0000".equals(actQryTemplateGroupAtomRspBO.getRespCode())) {
            throw new BusinessException(actQryTemplateGroupAtomRspBO.getRespCode(), actQryTemplateGroupAtomRspBO.getRespDesc());
        }
        List actTemplateGroupBOs = actQryTemplateGroupAtomRspBO.getRows();
        actActiveCommonInfoBO.setActTemplateGroupBOList(actTemplateGroupBOs);
    }

    private void commonCheckTemplateAttr(ActTemplateBO confActTemplateBO, ActTemplateBO paramActTemplateBO) {
        List confActTemplateAttrBOS = confActTemplateBO.getActTemplateAttrBOS();
        List paramActTemplateAttrBOS = paramActTemplateBO.getActTemplateAttrBOS();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u5fc5\u987b\u4e3a\u7a7a");
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)confActTemplateAttrBOS) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)paramActTemplateAttrBOS)) {
            if (confActTemplateAttrBOS.size() != paramActTemplateAttrBOS.size()) {
                throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u6570\u91cf\u4e0d\u5339\u914d");
            }
            HashMap<String, ActTemplateAttrBO> confTemplateAttrMap = new HashMap<String, ActTemplateAttrBO>();
            for (ActTemplateAttrBO actTemplateAttrBO : confActTemplateAttrBOS) {
                confTemplateAttrMap.put(actTemplateAttrBO.getAttrCode(), actTemplateAttrBO);
            }
            for (ActTemplateAttrBO paramActTemplateAttrBO : paramActTemplateAttrBOS) {
                if (StringUtils.isBlank((CharSequence)paramActTemplateAttrBO.getAttrCode())) {
                    throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u7f16\u7801[attrCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ActTemplateAttrBO confActTemplateAttrBO = (ActTemplateAttrBO)confTemplateAttrMap.get(paramActTemplateAttrBO.getAttrCode());
                if (null == confActTemplateAttrBO) {
                    throw new BusinessException("14032", "\u6a21\u677f\u5c5e\u6027\u3010" + paramActTemplateAttrBO.getAttrCode() + "\u3011\u4e0d\u7b26\u5408\u914d\u7f6e");
                }
                if (confActTemplateAttrBO.getAttrNotNull() != null && confActTemplateAttrBO.getAttrNotNull() == 1 && StringUtils.isBlank((CharSequence)paramActTemplateAttrBO.getParaValue())) {
                    throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u503c[paraValue]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotBlank((CharSequence)confActTemplateAttrBO.getAttrValidReg())) {
                    String content = paramActTemplateAttrBO.getParaValue();
                    String pattern = confActTemplateAttrBO.getAttrValidReg();
                    boolean isMatch = Pattern.matches(pattern, content);
                    if (!isMatch) {
                        throw new BusinessException("14001", paramActTemplateAttrBO.getAttrValidDesc());
                    }
                }
                paramActTemplateAttrBO.setAttrName(confActTemplateAttrBO.getAttrName());
            }
        }
    }

    private void systemCheckActiveTemplateAttr(ActTemplateBO paramActTemplateBO, List<ActDiscountBO> actDiscountBOs) {
        List actTemplateAttrBOS = paramActTemplateBO.getActTemplateAttrBOS();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actTemplateAttrBOS)) {
            HashMap<String, ActTemplateAttrBO> codeMap = new HashMap<String, ActTemplateAttrBO>();
            for (ActTemplateAttrBO actTemplateAttrBO : actTemplateAttrBOS) {
                codeMap.put(actTemplateAttrBO.getAttrCode(), actTemplateAttrBO);
            }
            Long templateId = paramActTemplateBO.getTemplateId();
            ActDiscountBO actDiscountBO = new ActDiscountBO();
            if (ActCommConstant.ActivityTempIdDefine.MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkMoneyFullReduction(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.MONEY);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.MONEY);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkCountFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkFeeFullReductionDiscount(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.MONEY);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.DISCOUNT);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkCountFullReductionDiscount(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.ACOUNT);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.DISCOUNT);
                actDiscountBOs.add(actDiscountBO);
            }
            if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_GIVE_ID.equals(templateId)) {
                this.checkFeeFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_GIVE_ID.equals(templateId)) {
                this.checkCountFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderMoneyFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderCountFullReduction(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_MONEY_FULL_REDUCTION_ID.equals(templateId)) {
                this.checkLadderFeeFullReductionDiscount(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_FULL_REDUCTION_DISCOUNT_ID.equals(templateId)) {
                this.checkLadderCountFullReductionDiscount(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_FEE_FULL_GIVE_ID.equals(templateId)) {
                this.checkLadderFeeFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.LADDER_COUNT_FULL_GIVE_ID.equals(templateId)) {
                this.checkLadderCountFullGive(codeMap);
            }
            if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_MONEY_ID.equals(templateId)) {
                this.checkCountFullReductionMoneyId(codeMap, actDiscountBO);
                actDiscountBO.setConditionType(ActCommConstant.ActiveTemplateConditionType.ACOUNT);
                actDiscountBO.setDiscountType(ActCommConstant.ActiveTemplateDiscountType.MONEY);
                actDiscountBOs.add(actDiscountBO);
            }
        }
    }

    private void checkLadderCountFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_end");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo1.getParaValue());
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderFeeFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_end");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo1.getParaValue());
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkLadderCountFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("count_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDisRate = new BigDecimal(bo1.getParaValue());
        if (countReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (countReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderFeeFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("fee_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachDisRate = new BigDecimal(bo1.getParaValue());
        if (feeReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (feeReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkLadderCountFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("count_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDis = new BigDecimal(bo1.getParaValue());
        if (countReachDis.compareTo(countReachStar) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u6761\u4ef6\u6570\u91cf");
        }
        if (countReachStar.compareTo(countReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkLadderMoneyFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach_star");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_star\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachStar = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo2 = codeMap.get("fee_reach_end");
        if (bo2 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_end\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo2.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachEnd = new BigDecimal(bo2.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal feeReachDis = new BigDecimal(bo1.getParaValue());
        if (feeReachDis.compareTo(feeReachStar) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u6761\u4ef6\u91d1\u989d");
        }
        if (feeReachStar.compareTo(feeReachEnd) > 0) {
            throw new BusinessException("14001", "\u8d77\u59cb\u6761\u4ef6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkCountFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkFeeFullGive(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkCountFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal countReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal countReachDisRate = new BigDecimal(bo1.getParaValue());
        if (countReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (countReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
    }

    private void checkFeeFullReductionDiscount(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal feeReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discountRate");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discountRate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal feeReachDisRate = new BigDecimal(bo1.getParaValue());
        if (feeReachDisRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (feeReachDisRate.compareTo(BigDecimal.ONE) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6298\u6263\u4e0d\u80fd\u5927\u4e8e1");
        }
    }

    private void checkCountFullReduction(Map<String, ActTemplateAttrBO> codeMap) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("count_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal countReachDis = new BigDecimal(bo1.getParaValue());
        if (countReachDis.compareTo(countReach) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6761\u4ef6\u6570\u91cf");
        }
    }

    private void checkMoneyFullReduction(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("fee_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        BigDecimal feeReach = new BigDecimal(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
        BigDecimal feeReachDis = new BigDecimal(bo1.getParaValue());
        if (feeReachDis.compareTo(feeReach) > 0) {
            throw new BusinessException("14001", "\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6761\u4ef6\u91d1\u989d");
        }
    }

    private void checkCountFullReductionMoneyId(Map<String, ActTemplateAttrBO> codeMap, ActDiscountBO actDiscountBO) {
        ActTemplateAttrBO bo = codeMap.get("count_reach");
        if (bo == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010count_reach\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setConditionValue(bo.getParaValue());
        ActTemplateAttrBO bo1 = codeMap.get("fee_reach_discount");
        if (bo1 == null) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010fee_reach_discount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo1.getParaValue())) {
            throw new BusinessException("14001", "\u6a21\u677f\u5c5e\u6027\u3010paraValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        actDiscountBO.setDiscountValue(bo1.getParaValue());
    }
}

