/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.active.app.ability.bo.ActActivityDetailQueryAbilityRspBO;
import com.tydic.active.app.ability.bo.ActivityInfoAbilityBO;
import com.tydic.active.app.ability.bo.SkuActiveAbilityBO;
import com.tydic.active.app.atom.ActDeleteRedisCacheAtomService;
import com.tydic.active.app.atom.bo.ActDeleteRedisCacheAtomReqBO;
import com.tydic.active.app.atom.bo.ActDeleteRedisCacheAtomRspBO;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.SkuActiveMapper;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.dao.po.SkuActivePO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actDeleteRedisCacheAtomService")
public class ActDeleteRedisCacheAtomServiceImpl
implements ActDeleteRedisCacheAtomService {
    private CacheClient cacheClient;
    private ActivityMapper activityMapper;
    private SkuActiveMapper skuActiveMapper;

    @Autowired
    public ActDeleteRedisCacheAtomServiceImpl(CacheClient cacheClient, ActivityMapper activityMapper, SkuActiveMapper skuActiveMapper) {
        this.cacheClient = cacheClient;
        this.activityMapper = activityMapper;
        this.skuActiveMapper = skuActiveMapper;
    }

    @Override
    public ActDeleteRedisCacheAtomRspBO deleteRedisCache(ActDeleteRedisCacheAtomReqBO reqBO) {
        ActDeleteRedisCacheAtomRspBO rspBO = new ActDeleteRedisCacheAtomRspBO();
        for (String redisKey : reqBO.getRedisKeys()) {
            if (redisKey.startsWith("MSC_INFO_")) {
                Object obj = this.cacheClient.get(redisKey);
                if (null != obj) {
                    ActivityInfoAbilityBO activityInfoBO = ((ActActivityDetailQueryAbilityRspBO)obj).getActivityInfoBO();
                    this.cacheClient.delete("MSC_INFO_" + activityInfoBO.getActiveCode());
                    for (SkuActiveAbilityBO skuActiveBO : activityInfoBO.getSkuActiveList()) {
                        String redisKeySku = "MSC_SKU_" + skuActiveBO.getSkuId();
                        this.cacheClient.delete(redisKeySku);
                    }
                } else {
                    Long activeId = Long.valueOf(redisKey.split("_")[2]);
                    ActivityPO activityPO = this.activityMapper.getModelById(activeId);
                    if (activityPO != null) {
                        this.cacheClient.delete("MSC_INFO_" + activityPO.getActiveCode());
                        SkuActivePO skuActivePO = new SkuActivePO();
                        skuActivePO.setActiveId(activeId);
                        List<SkuActivePO> skuActivePOList = this.skuActiveMapper.getList(skuActivePO);
                        for (SkuActivePO activePO : skuActivePOList) {
                            if (StringUtils.isNotBlank((CharSequence)activePO.getSkuId())) {
                                String redisKeySku = "MSC_SKU_" + activePO.getSkuId();
                                this.cacheClient.delete(redisKeySku);
                                continue;
                            }
                            String redisKeyShop = "MSC_SHOP_" + activePO.getShopId().toString();
                            this.cacheClient.delete(redisKeyShop);
                        }
                    }
                }
            }
            this.cacheClient.delete(redisKey);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6e05\u9664\u7f13\u5b58\u6210\u529f");
        return rspBO;
    }
}

