/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.tydic.active.app.atom.ActLadderMoneyFullReductionDiscountRateAtomService;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.active.app.common.bo.ActDiscountSkuListBO;
import com.tydic.active.app.common.bo.ActTemplateAttrBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import com.tydic.active.app.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actLadderMoneyFullReductionDiscountRateAtomService")
public class ActLadderMoneyFullReductionDiscountRateAtomServiceImpl
implements ActLadderMoneyFullReductionDiscountRateAtomService {
    @Override
    public ActCalculationUniversalAtomRspBO calculateLadderMoneyFullReductionDiscountRate(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal feeReachStar = new BigDecimal(0);
        BigDecimal feeReachEnd = new BigDecimal(0);
        BigDecimal feeReachDiscountRate = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("fee_reach_star".equals(bo.getAttrCode())) {
                feeReachStar = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("fee_reach_end".equals(bo.getAttrCode())) {
                feeReachEnd = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"fee_reach_discountRate".equals(bo.getAttrCode())) continue;
            feeReachDiscountRate = new BigDecimal(bo.getParaValue());
        }
        if (calculateMoney.compareTo(feeReachStar) >= 0) {
            BigDecimal money;
            if (calculateMoney.compareTo(feeReachEnd) < 0) {
                money = calculateMoney.subtract(feeReachStar);
                discountMoney = money.subtract(money.multiply(feeReachDiscountRate));
            } else {
                money = feeReachEnd.subtract(feeReachStar);
                discountMoney = money.subtract(money.multiply(feeReachDiscountRate));
            }
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        BigDecimal alreadyDiscountPrice = discountMoney;
        for (int i = 0; i < atomReqBO.getSkuInfoList().size(); ++i) {
            if (i + 1 == atomReqBO.getSkuInfoList().size()) {
                skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), alreadyDiscountPrice);
                break;
            }
            BigDecimal moleculeTotalPrice = atomReqBO.getSkuInfoList().get(i).getTotalPrice().multiply(discountMoney).setScale(2, RoundingMode.HALF_UP);
            BigDecimal singelDiscountPrice = moleculeTotalPrice.divide(totalSalePrice, 2, RoundingMode.HALF_UP);
            skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), singelDiscountPrice);
            alreadyDiscountPrice = alreadyDiscountPrice.subtract(singelDiscountPrice);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

