/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActSyncKillPriceAtomService;
import com.tydic.active.app.atom.bo.ActSyncKillPriceAtomReqBO;
import com.tydic.active.app.atom.bo.ActSyncKillPriceAtomRspBO;
import com.tydic.active.app.busi.ActActStartStopBusiService;
import com.tydic.active.app.busi.bo.ActActStartStopBusiReqBO;
import com.tydic.active.app.busi.bo.ActActStartStopBusiRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.common.bo.ChooseActivityBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActActiveMerchantMapper;
import com.tydic.active.app.dao.ActKillSkuMapper;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.ShopActiveMapper;
import com.tydic.active.app.dao.SkuActiveMapper;
import com.tydic.active.app.dao.po.ActKillSkuPO;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.dao.po.SkuActivePO;
import com.tydic.active.app.facde.ActUgcServiceHolder;
import com.tydic.active.external.api.common.bo.ActSpuEsForActivityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActStartStopBusiService")
public class ActActStartStopBusiServiceImpl
implements ActActStartStopBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActStartStopBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActKillSkuMapper actKillSkuMapper;
    @Autowired
    private ActUgcServiceHolder actUgcServiceHolder;
    @Autowired
    private ActActiveMerchantMapper actActiveMerchantMapper;
    @Autowired
    private ActSyncKillPriceAtomService actSyncKillPriceAtomService;

    public ActActStartStopBusiRspBO dealStartStop(ActActStartStopBusiReqBO busiReqBO) {
        ActActStartStopBusiRspBO rsp = new ActActStartStopBusiRspBO();
        for (ChooseActivityBO chooseActivityBO : busiReqBO.getStartStopActivityInfoList()) {
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveCode(chooseActivityBO.getActiveCode());
            activityPO.setActiveId(chooseActivityBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            activityPO.setAdmOrgId(busiReqBO.getOrgIdIn());
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                }
                throw new BusinessException("14003", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)chooseActivityBO.getSkuActIds())) {
                ActivityPO activePO = new ActivityPO();
                activePO.setActiveId(activity.getActiveId());
                activePO.setActiveStatus(this.startOrStop(busiReqBO.getOperType()));
                activePO.setAdmOrgId(busiReqBO.getOrgIdIn());
                int updateActResult = this.activityMapper.updateById(activePO);
                if (updateActResult < 1) {
                    if (IS_DEBUGABLE) {
                        LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
                    }
                    throw new BusinessException("14012", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
                }
            } else {
                SkuActivePO skuActivePO = new SkuActivePO();
                skuActivePO.setActiveId(activity.getActiveId());
                skuActivePO.setSkuActIds(chooseActivityBO.getSkuActIds());
                skuActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
                skuActivePO.setAdmOrgId(busiReqBO.getOrgIdIn());
                this.skuActiveMapper.updateByCondition(skuActivePO);
            }
            if (!"12".equals(activity.getActiveType())) continue;
            if (busiReqBO.getOperType() == 0) {
                this.addKillPriceToUcc(chooseActivityBO);
            }
            if (busiReqBO.getOperType() != 1) continue;
            this.removeKillPriceToUcc(chooseActivityBO, busiReqBO.getOrgIdIn());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private void removeKillPriceToUcc(ChooseActivityBO chooseActivityBO, String amdOrgId) {
        ActKillSkuPO actKillSkuPO = new ActKillSkuPO();
        actKillSkuPO.setActiveId(chooseActivityBO.getActiveId());
        List<ActKillSkuBO> actKillSkuBOs = this.actKillSkuMapper.getList(actKillSkuPO);
        if (!CollectionUtils.isEmpty(actKillSkuBOs)) {
            ArrayList<ActSpuEsForActivityBO> spuEsForActivityBOS = new ArrayList<ActSpuEsForActivityBO>();
            for (ActKillSkuBO bo : actKillSkuBOs) {
                ActSpuEsForActivityBO actSpuEsForActivityBO = new ActSpuEsForActivityBO();
                if (StringUtils.isNotBlank((CharSequence)bo.getCommodityId())) {
                    actSpuEsForActivityBO.setCommodityId(Long.valueOf(bo.getCommodityId()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getSkuId())) {
                    actSpuEsForActivityBO.setSkuId(Long.valueOf(bo.getSkuId()));
                }
                spuEsForActivityBOS.add(actSpuEsForActivityBO);
            }
            ActSyncKillPriceAtomReqBO actSyncKillPriceAtomReqBO = new ActSyncKillPriceAtomReqBO();
            actSyncKillPriceAtomReqBO.setActiveId(chooseActivityBO.getActiveId());
            actSyncKillPriceAtomReqBO.setOperType(1);
            actSyncKillPriceAtomReqBO.setSpuEsForActivityBOS(spuEsForActivityBOS);
            ActSyncKillPriceAtomRspBO actSyncKillPriceAtomRspBO = this.actSyncKillPriceAtomService.syncKillPrice(actSyncKillPriceAtomReqBO);
            if (!"0000".equals(actSyncKillPriceAtomRspBO.getRespCode())) {
                throw new BusinessException(actSyncKillPriceAtomRspBO.getRespCode(), actSyncKillPriceAtomRspBO.getRespDesc());
            }
        }
    }

    private void addKillPriceToUcc(ChooseActivityBO chooseActivityBO) {
        ActSyncKillPriceAtomReqBO actSyncKillPriceAtomReqBO = new ActSyncKillPriceAtomReqBO();
        actSyncKillPriceAtomReqBO.setActiveId(chooseActivityBO.getActiveId());
        actSyncKillPriceAtomReqBO.setOperType(0);
        ActSyncKillPriceAtomRspBO actSyncKillPriceAtomRspBO = this.actSyncKillPriceAtomService.syncKillPrice(actSyncKillPriceAtomReqBO);
        if (!"0000".equals(actSyncKillPriceAtomRspBO.getRespCode())) {
            throw new BusinessException(actSyncKillPriceAtomRspBO.getRespCode(), actSyncKillPriceAtomRspBO.getRespDesc());
        }
    }

    private Integer startOrStop(Integer operType2) {
        Integer status;
        switch (operType2) {
            case 0: {
                status = ActCommConstant.ActivityState.STATE_EFFECTIVE;
                break;
            }
            case 1: {
                status = ActCommConstant.ActivityState.STATE_INVALID;
                break;
            }
            default: {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
                }
                throw new BusinessException("14035", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return status;
    }
}

