/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.WelfarePointsAttachBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeReqBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeRspBO;
import com.tydic.active.app.busi.ActAddWelfarePointsChargeBusiService;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActWelfarePointsConstant;
import com.tydic.active.app.dao.WelfarePointsAttachMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointsAttachPO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.utils.ActDateUtils;
import com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActAddWelfarePointsChargeBusiServiceImpl
implements ActAddWelfarePointsChargeBusiService {
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfarePointsAttachMapper welfarePointsAttachMapper;
    @Autowired
    private FscRecvClaimListQueryAbilityService fscRecvClaimListQueryAbilityService;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;

    public WelfarePointsChargeRspBO dealAddWelfarePointsCharge(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        WelfarePointsChargeRspBO rspBO = new WelfarePointsChargeRspBO();
        this.validateParam(welfarePointsChargeReqBO);
        WelfarePointsChargePO welfarePointsChargePO = new WelfarePointsChargePO();
        BeanUtils.copyProperties((Object)welfarePointsChargeReqBO, (Object)welfarePointsChargePO);
        welfarePointsChargePO.setWelfarePointsChargeId(Sequence.getInstance().nextId());
        welfarePointsChargePO.setOperateTime(new Date());
        welfarePointsChargePO.setRechargeStatus(ActActiveConstant.welfarePointsRechargeStatus.NORMAL);
        welfarePointsChargePO.setStatus(ActWelfarePointsConstant.welfarePointsStatus.WAIT_SUBMIT);
        welfarePointsChargePO.setBankSerialNumber(welfarePointsChargeReqBO.getBankSerialNumberWeb());
        int i = this.welfarePointsChargeMapper.insertSelective(welfarePointsChargePO);
        if (i == 0) {
            throw new BusinessException("14010", "\u798f\u70b9\u5145\u503c\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)welfarePointsChargeReqBO.getWelfareActiveAttachList())) {
            ArrayList<WelfarePointsAttachPO> welfarePointsAttachPOList = new ArrayList<WelfarePointsAttachPO>();
            for (WelfarePointsAttachBO welfarePointsAttachBO : welfarePointsChargeReqBO.getWelfareActiveAttachList()) {
                WelfarePointsAttachPO welfarePointsAttachPO = new WelfarePointsAttachPO();
                BeanUtils.copyProperties((Object)welfarePointsAttachBO, (Object)welfarePointsAttachPO);
                welfarePointsAttachPO.setId(Sequence.getInstance().nextId());
                welfarePointsAttachPO.setBusiType((byte)2);
                welfarePointsAttachPO.setRelateId(welfarePointsChargePO.getWelfarePointsChargeId());
                welfarePointsAttachPOList.add(welfarePointsAttachPO);
            }
            int insertBatch = this.welfarePointsAttachMapper.insertBatch(welfarePointsAttachPOList);
            if (insertBatch == 0) {
                throw new BusinessException("14010", "\u9644\u4ef6\u6dfb\u52a0\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u798f\u70b9\u5145\u503c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return rspBO;
    }

    private void validateParam(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        if (null == welfarePointsChargeReqBO) {
            throw new BusinessException("14000", "\u798f\u5229\u5145\u503c\u5217\u8868\u67e5\u8be2\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public WelfarePointsChargeRspBO dealSubmitWelfarePointsCharge(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        WelfarePointsChargePO po;
        WelfarePointsChargeRspBO rspBO = new WelfarePointsChargeRspBO();
        WelfarePointsChargePO welfarePointsChargePO = new WelfarePointsChargePO();
        BeanUtils.copyProperties((Object)welfarePointsChargeReqBO, (Object)welfarePointsChargePO);
        welfarePointsChargePO.setStatus(ActWelfarePointsConstant.welfarePointsStatus.APPROVING);
        welfarePointsChargePO.setOperateTime(new Date());
        List departmentInfoWeb = welfarePointsChargeReqBO.getDepartmentInfoWeb();
        String jsonString = JSON.toJSONString((Object)departmentInfoWeb);
        welfarePointsChargePO.setDepartmentInfo(jsonString);
        int i = this.welfarePointsChargeMapper.updateStatus(welfarePointsChargePO);
        if (i == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u798f\u70b9\u5145\u503c\u4fe1\u606f\u63d0\u4ea4\u5931\u8d25");
        }
        if ((po = this.welfarePointsChargeMapper.selectByPrimaryKey(welfarePointsChargePO.getWelfarePointsChargeId())) == null) {
            throw new BusinessException("8888", "\u63d0\u4ea4\u5931\u8d25,\u6570\u636e\u5f02\u5e38!");
        }
        this.doChargeAmount(po, welfarePointsChargeReqBO, po.getChargeAmount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u798f\u70b9\u5145\u503c\u4fe1\u606f\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }

    public WelfarePointsChargeRspBO dealUpdateMoneyWelfarePointsCharge(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        WelfarePointsChargeRspBO rspBO = new WelfarePointsChargeRspBO();
        WelfarePointsChargePO query = this.welfarePointsChargeMapper.selectByPrimaryKey(welfarePointsChargeReqBO.getWelfarePointsChargeId());
        if (query == null) {
            throw new BusinessException("14012", "\u67e5\u8be2\u798f\u70b9\u5931\u8d25\uff01");
        }
        WelfarePointsChargePO welfarePointsChargePO = new WelfarePointsChargePO();
        welfarePointsChargePO.setWelfarePointsChargeId(welfarePointsChargeReqBO.getWelfarePointsChargeId());
        welfarePointsChargePO.setChargeAmount(StringUtils.isBlank((CharSequence)query.getExtField4()) ? BigDecimal.ZERO : new BigDecimal(query.getExtField4()));
        int i = this.welfarePointsChargeMapper.updateByPrimaryKeySelective(welfarePointsChargePO);
        if (i == 0) {
            throw new BusinessException("8888", "\u798f\u70b9\u5145\u503c\u4fe1\u606f\u63d0\u4ea4\u5931\u8d25,\u56de\u6eda\u91d1\u989d\u5931\u8d25,\u8bf7\u624b\u52a8\u53bb\u6570\u636e\u5e93\u4fee\u6539");
        }
        return rspBO;
    }

    void doChargeAmount(WelfarePointsChargePO po, WelfarePointsChargeReqBO reqBO, BigDecimal releaseAmout) {
        FscAccountDealWelfareDeductAbilityReqBO fscReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        fscReqBO.setSupId(this.operationOrgId);
        fscReqBO.setCreditOrgId(po.getOrgIdWelfarePoints());
        Integer payType2 = this.translate(po.getExtField1());
        if (payType2 == null) {
            throw new BusinessException("8888", "\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38!");
        }
        fscReqBO.setPayType(payType2);
        fscReqBO.setOperationType(Integer.valueOf(0));
        fscReqBO.setOrderId(po.getWelfarePointsChargeId());
        fscReqBO.setOrderNo(po.getWelfarePointChargeCode());
        fscReqBO.setTotalAmount(releaseAmout);
        fscReqBO.setBusiOrderType(Integer.valueOf(3));
        fscReqBO.setWelfareType(Integer.valueOf(po.getWelfareType().byteValue()));
        fscReqBO.setUserId(reqBO.getUserId());
        fscReqBO.setUserName(reqBO.getUserName());
        fscReqBO.setName(reqBO.getName());
        fscReqBO.setOrgId(reqBO.getOrgId());
        FscAccountDealWelfareDeductAbilityRspBO fscRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(fscReqBO);
        if (!"0000".equals(fscRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u798f\u70b9\u5145\u503c\u7f16\u53f7:" + po.getWelfarePointChargeCode() + ",\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u5145\u503c\u5931\u8d25!,\u539f\u56e0:" + fscRspBO.getRespDesc());
        }
        if ("1".equals(po.getExtField1())) {
            WelfarePointsChargePO updateChargeBO = new WelfarePointsChargePO();
            updateChargeBO.setWelfarePointsChargeId(po.getWelfarePointsChargeId());
            updateChargeBO.setExtField2(fscRspBO.getAdvanceUseAmt() + "");
            updateChargeBO.setExtField3(fscRspBO.getOverdraftUseAmt() + "");
            this.welfarePointsChargeMapper.updateByPrimaryKeySelective(updateChargeBO);
        }
    }

    private Integer translate(String extField1) {
        if ("1".equals(extField1)) {
            return 3;
        }
        if ("2".equals(extField1)) {
            return 2;
        }
        return null;
    }

    private void recClaimConfirm(WelfarePointsChargePO po) {
        FscRecvClaimListQueryAbilityReqBO queryReqBO = new FscRecvClaimListQueryAbilityReqBO();
        queryReqBO.setSerialNumber(po.getBankSerialNumber());
        FscRecvClaimListQueryAbilityRspBO queryAbilityRspBO = this.fscRecvClaimListQueryAbilityService.qryRecvClaimList(queryReqBO);
        FscRecvClaimConfirmAbilityReqBO bo = new FscRecvClaimConfirmAbilityReqBO();
        ArrayList<FscClaimDetailBO> detailBOS = new ArrayList<FscClaimDetailBO>();
        for (FscRecvClaimBO fscRecvClaimBO : queryAbilityRspBO.getRows()) {
            if (!po.getBankSerialNumber().equals(fscRecvClaimBO.getSerialNumber())) continue;
            JSONArray objects = JSON.parseArray((String)po.getDepartmentInfo());
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)objects.get(0)));
            bo.setClaimId(fscRecvClaimBO.getClaimId());
            bo.setRecvAmt(fscRecvClaimBO.getRecvAmt());
            if (ActActiveConstant.fscClaimStatus.UNCLAIMED.toString().equals(fscRecvClaimBO.getClaimStatus())) {
                BigDecimal first = fscRecvClaimBO.getRecvAmt().subtract(po.getChargeAmount());
                bo.setNoClaimAmt(first.setScale(2, 4));
            } else {
                BigDecimal noClaimAmt = fscRecvClaimBO.getNoClaimAmt().subtract(po.getChargeAmount());
                bo.setNoClaimAmt(noClaimAmt.setScale(2, 4));
            }
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            detailBO.setClaimAmt(po.getChargeAmount());
            detailBO.setClaimDate(ActDateUtils.strToDate(ActDateUtils.dateToStr(new Date())));
            detailBO.setOperationType(ActActiveConstant.fscRecvClaimConfirmType.CLAIM);
            detailBO.setObjectId(po.getWelfarePointsChargeId());
            detailBO.setObjectNo(po.getWelfarePointChargeCode());
            detailBO.setClaimType("5");
            detailBO.setHandleDeptId(Long.valueOf(String.valueOf(jsonObject.get((Object)"deptId"))));
            detailBO.setHandleDeptName(String.valueOf(jsonObject.get((Object)"deptName")));
            detailBO.setHandleUserId(Long.valueOf(String.valueOf(jsonObject.get((Object)"userId"))));
            detailBO.setHandleUserName(String.valueOf(jsonObject.get((Object)"personName")));
            detailBOS.add(detailBO);
            bo.setClaimDetailList(detailBOS);
            FscRecvClaimConfirmAbilityRspBO rspBO = this.fscRecvClaimConfirmAbilityService.recvClaimConfirm(bo);
            if ("0000".equals(rspBO.getRespCode())) continue;
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }
}

