/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.ability.bo.WelfarePointsChargeApproveReqBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeApproveRspBO;
import com.tydic.active.app.busi.ActApproveInvokeWelfarePointsChargeBusiService;
import com.tydic.active.app.busi.WelfareActiveAuditOperateService;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditRspBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.utils.ActDateUtils;
import com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActApproveInvokeWelfarePointsChargeBusiServiceImpl
implements ActApproveInvokeWelfarePointsChargeBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActApproveInvokeWelfarePointsChargeBusiServiceImpl.class);
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfareActiveAuditOperateService welfareActiveAuditOperateService;
    @Autowired
    private FscRecvClaimListQueryAbilityService fscRecvClaimListQueryAbilityService;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public WelfarePointsChargeApproveRspBO approveWelfarePointsCharge(WelfarePointsChargeApproveReqBO reqBO) {
        WelfarePointsChargeApproveRspBO rspBO = new WelfarePointsChargeApproveRspBO();
        List<WelfarePointsChargePO> welfarePointsChargePOS = this.welfarePointsChargeMapper.selectListByPrimaryKey(reqBO.getWelfarePointsChargeIds());
        if (welfarePointsChargePOS.size() < reqBO.getWelfarePointsChargeIds().size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u7684\u5145\u503cid");
            return rspBO;
        }
        Map<Long, WelfarePointsChargePO> chargeMap = welfarePointsChargePOS.stream().collect(Collectors.toMap(e -> e.getWelfarePointsChargeId(), e -> e, (k, v) -> k));
        WelfareActiveInvokeAuditReqBO welfareActiveInvokeAuditReqBO = new WelfareActiveInvokeAuditReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)welfareActiveInvokeAuditReqBO);
        welfareActiveInvokeAuditReqBO.setObjIds(new HashSet(reqBO.getWelfarePointsChargeIds()));
        welfareActiveInvokeAuditReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_CHARGE_CHARGE_AUDIT);
        WelfareActiveInvokeAuditRspBO welfareActiveInvokeAuditRspBO = this.welfareActiveAuditOperateService.invokeAuditOrder(welfareActiveInvokeAuditReqBO);
        if (!"0000".equals(welfareActiveInvokeAuditRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(welfareActiveInvokeAuditRspBO.getRespDesc());
            return rspBO;
        }
        for (Long welfarePointsChargeId : reqBO.getWelfarePointsChargeIds()) {
            Boolean finishFlag = (Boolean)welfareActiveInvokeAuditRspBO.getAuditFinishMap().get(welfarePointsChargeId);
            if (!finishFlag.booleanValue()) continue;
            WelfarePointsChargePO updatePO = new WelfarePointsChargePO();
            updatePO.setWelfarePointsChargeId(welfarePointsChargeId);
            Date date = new Date();
            updatePO.setOperateTime(date);
            String objectId = DateUtils.dateToStr((Date)date, (String)"yyyyMMddHHmmss");
            if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
                updatePO.setStatus(ActActiveConstant.welfarePointsStatus.APPROVE_PASS);
            } else if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.NOT_PASS)) {
                updatePO.setStatus(ActActiveConstant.welfarePointsStatus.APPROVE_FAIL);
                if (chargeMap.get(welfarePointsChargeId) == null) {
                    throw new BusinessException("8888", "\u5145\u503c\u5355id\u6709\u8bef,\u67e5\u8be2\u5145\u503c\u4fe1\u606f\u5931\u8d25");
                }
                WelfarePointsChargePO welfarePointsChargePO = chargeMap.get(welfarePointsChargeId);
            }
            this.welfarePointsChargeMapper.updateStatus(updatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAuditFinishMap(welfareActiveInvokeAuditRspBO.getAuditFinishMap());
        return rspBO;
    }

    private void backRecClaim(WelfarePointsChargePO po) {
        FscRecvClaimListQueryAbilityReqBO queryReqBO = new FscRecvClaimListQueryAbilityReqBO();
        queryReqBO.setSerialNumber(po.getBankSerialNumber());
        FscRecvClaimListQueryAbilityRspBO queryAbilityRspBO = this.fscRecvClaimListQueryAbilityService.qryRecvClaimList(queryReqBO);
        FscRecvClaimConfirmAbilityReqBO bo = new FscRecvClaimConfirmAbilityReqBO();
        ArrayList<FscClaimDetailBO> detailBOS = new ArrayList<FscClaimDetailBO>();
        for (FscRecvClaimBO fscRecvClaimBO : queryAbilityRspBO.getRows()) {
            if (!po.getBankSerialNumber().equals(fscRecvClaimBO.getSerialNumber())) continue;
            bo.setClaimId(fscRecvClaimBO.getClaimId());
            bo.setRecvAmt(fscRecvClaimBO.getRecvAmt());
            BigDecimal noClaimAmt = fscRecvClaimBO.getNoClaimAmt().add(po.getChargeAmount());
            bo.setNoClaimAmt(noClaimAmt.setScale(2, 4));
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            detailBO.setClaimAmt(po.getChargeAmount());
            detailBO.setClaimDate(ActDateUtils.strToDate(ActDateUtils.dateToStr(new Date())));
            detailBO.setOperationType(ActActiveConstant.fscRecvClaimConfirmType.CANCEL);
            detailBO.setObjectId(po.getWelfarePointsChargeId());
            detailBO.setObjectNo(po.getWelfarePointChargeCode());
            detailBO.setClaimType("5");
            detailBOS.add(detailBO);
            bo.setClaimDetailList(detailBOS);
            FscRecvClaimConfirmAbilityRspBO rspBO = this.fscRecvClaimConfirmAbilityService.recvClaimConfirm(bo);
            if ("0000".equals(rspBO.getRespCode())) continue;
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }

    void backChargeAmount(WelfarePointsChargePO po, WelfarePointsChargeApproveReqBO reqBO, BigDecimal releaseAmout, String objectId) {
        FscAccountDealWelfareDeductAbilityReqBO fscReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        fscReqBO.setSupId(this.operationOrgId);
        fscReqBO.setCreditOrgId(po.getOrgIdWelfarePoints());
        Integer payType2 = this.translate(po.getExtField1());
        if (payType2 == null) {
            throw new BusinessException("8888", "\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38!");
        }
        fscReqBO.setPayType(payType2);
        fscReqBO.setOperationType(Integer.valueOf(1));
        fscReqBO.setOrderId(po.getWelfarePointsChargeId());
        fscReqBO.setOrderNo(po.getWelfarePointChargeCode());
        try {
            fscReqBO.setObjId(Long.valueOf(Long.parseLong(objectId)));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "objectId\u8f6c\u6362\u5f02\u5e38!");
        }
        fscReqBO.setTotalAmount(releaseAmout.negate());
        fscReqBO.setBusiOrderType(Integer.valueOf(3));
        fscReqBO.setWelfareType(Integer.valueOf(po.getWelfareType().byteValue()));
        fscReqBO.setUserId(reqBO.getUserId());
        fscReqBO.setUserName(reqBO.getUserName());
        fscReqBO.setName(reqBO.getName());
        fscReqBO.setOrgId(reqBO.getOrgId());
        FscAccountDealWelfareDeductAbilityRspBO fscRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(fscReqBO);
        if (!"0000".equals(fscRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u798f\u70b9\u5145\u503c\u7f16\u53f7:" + po.getWelfarePointChargeCode() + ",\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u9000\u6b3e\u5931\u8d25!,\u539f\u56e0:" + fscRspBO.getRespDesc());
        }
    }

    private Integer translate(String extField1) {
        if ("1".equals(extField1)) {
            return 3;
        }
        if ("2".equals(extField1)) {
            return 2;
        }
        return null;
    }
}

