/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.active.app.atom.ActAddKillDayAndTimeAtomService;
import com.tydic.active.app.atom.ActDeleteKillSkuAtomService;
import com.tydic.active.app.atom.bo.ActAddKillDayAndTimeAtomReqBO;
import com.tydic.active.app.atom.bo.ActAddKillDayAndTimeAtomRspBO;
import com.tydic.active.app.atom.bo.ActDeleteKillSkuAtomReqBO;
import com.tydic.active.app.busi.ActImoprtKillSkuByFileBusiService;
import com.tydic.active.app.busi.bo.ActImoprtKillSkuByFileBusiReqBO;
import com.tydic.active.app.busi.bo.ActImoprtKillSkuByFileBusiRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillActiveExtMapper;
import com.tydic.active.app.dao.ActKillSkuMapper;
import com.tydic.active.app.dao.po.ActKillActiveExtPO;
import com.tydic.active.app.dao.po.ActKillSkuPO;
import com.tydic.active.app.utils.ExcelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="actImoprtKillSkuByFileBusiService")
public class ActImoprtKillSkuByFileBusiServiceImpl
implements ActImoprtKillSkuByFileBusiService {
    @Autowired
    private FileClient fileClient;
    @Autowired
    private ActKillSkuMapper actKillSkuMapper;
    @Autowired
    private ActAddKillDayAndTimeAtomService actAddKillDayAndTimeAtomService;
    @Autowired
    private ActKillActiveExtMapper actKillActiveExtMapper;
    @Autowired
    private ActDeleteKillSkuAtomService actDeleteKillSkuAtomService;

    public ActImoprtKillSkuByFileBusiRspBO imoprtKillSkuByFile(ActImoprtKillSkuByFileBusiReqBO busiReqBO) {
        ActImoprtKillSkuByFileBusiRspBO rsp = new ActImoprtKillSkuByFileBusiRspBO();
        ActKillActiveExtPO record = new ActKillActiveExtPO();
        record.setActiveId(busiReqBO.getActiveId());
        record.setAdmOrgId(busiReqBO.getOrgIdIn());
        ActKillActiveExtPO actKillActiveExtPO = this.actKillActiveExtMapper.selectByRecord(record);
        if (actKillActiveExtPO == null) {
            throw new BusinessException("14003", "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List<ActKillSkuBO> actKillSkuBOS = this.getExcelData(busiReqBO, actKillActiveExtPO);
        this.insertKillSku(actKillSkuBOS, busiReqBO);
        if (!ActCommConstant.ActivityState.DRAFT.equals(actKillActiveExtPO.getActiveStatus())) {
            ActAddKillDayAndTimeAtomReqBO atomReqBO = new ActAddKillDayAndTimeAtomReqBO();
            atomReqBO.setActKillActiveExtPO(actKillActiveExtPO);
            atomReqBO.setActKillSkuBOS(actKillSkuBOS);
            ActAddKillDayAndTimeAtomRspBO atomRspBO = this.actAddKillDayAndTimeAtomService.crateKillDayAndTime(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6587\u4ef6\u65b9\u5f0f\u5bfc\u5165\u79d2\u6740\u5546\u54c1\u6210\u529f\uff01");
        return rsp;
    }

    private void insertKillSku(List<ActKillSkuBO> actKillSkuBOS, ActImoprtKillSkuByFileBusiReqBO busiReqBO) {
        int isInsert;
        HashSet<String> deleteSkuIds = new HashSet<String>();
        if ("1".equals(busiReqBO.getBatchAddType()) || "2".equals(busiReqBO.getBatchAddType())) {
            HashSet<Long> skuIds = new HashSet<Long>();
            for (ActKillSkuBO actKillSkuBO : actKillSkuBOS) {
                skuIds.add(Long.parseLong(actKillSkuBO.getSkuId()));
            }
            ActKillSkuPO actKillSkuPO = new ActKillSkuPO();
            actKillSkuPO.setActiveId(busiReqBO.getActiveId());
            actKillSkuPO.setAdmOrgId(busiReqBO.getOrgIdIn());
            actKillSkuPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
            actKillSkuPO.setKillSkuIds(skuIds);
            List<ActKillSkuBO> actKillSkuBOS1 = this.actKillSkuMapper.getList(actKillSkuPO);
            if (!CollectionUtils.isEmpty(actKillSkuBOS1)) {
                if ("1".equals(busiReqBO.getBatchAddType())) {
                    for (ActKillSkuBO actKillSkuBO : actKillSkuBOS1) {
                        deleteSkuIds.add(actKillSkuBO.getSkuId());
                    }
                } else {
                    ArrayList<ActKillSkuBO> temp = new ArrayList<ActKillSkuBO>();
                    for (ActKillSkuBO actKillSkuBO : actKillSkuBOS1) {
                        for (ActKillSkuBO bo : actKillSkuBOS) {
                            if (!bo.getSkuId().equals(actKillSkuBO.getSkuId())) continue;
                            temp.add(bo);
                        }
                    }
                    actKillSkuBOS.removeAll(temp);
                }
            }
        }
        if ("1".equals(busiReqBO.getBatchAddType()) || "3".equals(busiReqBO.getBatchAddType())) {
            ActDeleteKillSkuAtomReqBO actDeleteKillSkuAtomReqBO = new ActDeleteKillSkuAtomReqBO();
            actDeleteKillSkuAtomReqBO.setActiveId(busiReqBO.getActiveId());
            actDeleteKillSkuAtomReqBO.setSkuIds(deleteSkuIds);
            actDeleteKillSkuAtomReqBO.setOrgIdIn(busiReqBO.getOrgIdIn());
            actDeleteKillSkuAtomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
            actDeleteKillSkuAtomReqBO.setDeleteType(ActCommConstant.DeleteType.DELETE_FALSE);
            this.actDeleteKillSkuAtomService.deleteKillSku(actDeleteKillSkuAtomReqBO);
        }
        if ((isInsert = this.actKillSkuMapper.insertBatch(actKillSkuBOS)) != actKillSkuBOS.size()) {
            throw new BusinessException("14010", "\u79d2\u6740\u5355\u54c1\u8868\u63d2\u5165\u5931\u8d25\uff01");
        }
    }

    private List<ActKillSkuBO> getExcelData(ActImoprtKillSkuByFileBusiReqBO busiReqBO, ActKillActiveExtPO actKillActiveExtPO) {
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        File file = this.fileClient.downloadToFile(busiReqBO.getFilePath());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Object object = null;
            try {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
                ExcelUtils.getExcelDate((MultipartFile)mockMultipartFile, data, title, 0);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("14040", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("14040", "\u6587\u4ef6\u4e3a\u7a7a");
        }
        ArrayList<ActKillSkuBO> actKillSkuBOs = new ArrayList<ActKillSkuBO>();
        for (List list : data) {
            ActKillSkuBO actKillSkuBO = new ActKillSkuBO();
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(0)))) {
                throw new BusinessException("14001", "\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            actKillSkuBO.setCommodityId((String)list.get(0));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(1)))) {
                throw new BusinessException("14001", "SkuId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            actKillSkuBO.setSkuId((String)list.get(1));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(2)))) {
                list.set(2, "-1");
            }
            actKillSkuBO.setActualNum(Integer.valueOf(Integer.parseInt((String)list.get(2))));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(3)))) {
                list.set(3, "-1");
            }
            actKillSkuBO.setDayStockNum(Integer.valueOf(Integer.parseInt((String)list.get(3))));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(4)))) {
                throw new BusinessException("14001", "\u6700\u7ec8\u4f18\u60e0\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            actKillSkuBO.setKillPrice(Long.valueOf(Long.parseLong((String)list.get(4))));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(5)))) {
                list.set(5, "0");
            }
            actKillSkuBO.setSkuOrder(Integer.valueOf(Integer.parseInt((String)list.get(5))));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(6)))) {
                list.set(6, "00:00:00-23:59:59");
            }
            actKillSkuBO.setKillSkuField1((String)list.get(6));
            if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(7)))) {
                list.set(7, "-1");
            }
            actKillSkuBO.setTimeStockNum(Integer.valueOf(Integer.parseInt((String)list.get(7))));
            actKillSkuBO.setAdmOrgId(busiReqBO.getOrgIdIn());
            actKillSkuBO.setAdmOrgId(actKillActiveExtPO.getAdmOrgId());
            actKillSkuBO.setActiveId(actKillActiveExtPO.getActiveId());
            actKillSkuBO.setCreateLoginId(busiReqBO.getMemIdIn());
            actKillSkuBO.setCreateTime(new Date());
            actKillSkuBOs.add(actKillSkuBO);
        }
        return actKillSkuBOs;
    }
}

