/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.cache.ActRedisManager;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.active.app.busi.ActQryGroupActiveInstByPageBusiService;
import com.tydic.active.app.busi.bo.ActQryGroupActiveInstByPageBusiReqBO;
import com.tydic.active.app.busi.bo.ActQryGroupActiveInstByPageBusiRspBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstDetailBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActGroupActiveInstDetailMapper;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveInstDetailPO;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActQryGroupActiveInstByPageBusiServiceImpl
implements ActQryGroupActiveInstByPageBusiService {
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Autowired
    private ActGroupActiveInstDetailMapper actGroupActiveInstDetailMapper;
    @Autowired
    private ActSelectDictByCodeAndPcodeAtomService actSelectDictByCodeAndPcodeAtomService;
    @Autowired
    private ActRedisManager cacheManager;
    @Value(value="${STOCK_HANDLE_MODE}")
    private Byte stockHandleMode;

    public ActQryGroupActiveInstByPageBusiRspBO queryGroupActiveInst(ActQryGroupActiveInstByPageBusiReqBO busiReqBO) {
        List<ActGroupActiveInstPO> actGroupActiveInstPOs;
        ActQryGroupActiveInstByPageBusiRspBO rsp = new ActQryGroupActiveInstByPageBusiRspBO();
        ArrayList<ActGroupActiveInstBO> rows = new ArrayList<ActGroupActiveInstBO>();
        ActGroupActiveInstPO actGroupActiveInstPO = new ActGroupActiveInstPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)actGroupActiveInstPO);
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            actGroupActiveInstPOs = this.actGroupActiveInstMapper.getListPage(actGroupActiveInstPO, (Page<ActGroupActiveInstPO>)page);
            rsp.setTotal(Integer.valueOf(page.getTotalPages()));
            rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        } else {
            actGroupActiveInstPOs = this.actGroupActiveInstMapper.getList(actGroupActiveInstPO);
        }
        if (CollectionUtils.isEmpty(actGroupActiveInstPOs)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        Map<String, String> groupActiveInstStateStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "GROUP_ACTIVE_INST_PCODE");
        for (ActGroupActiveInstPO po : actGroupActiveInstPOs) {
            ActGroupActiveInstBO actGroupActiveInstBO = new ActGroupActiveInstBO();
            BeanUtils.copyProperties((Object)po, (Object)actGroupActiveInstBO);
            if (!ActCommConstant.StockHandleMode.NO_STOCK_LIMIT.equals(this.stockHandleMode)) {
                Integer groupMemNum = this.getGroupMemNum(actGroupActiveInstBO.getActiveId(), actGroupActiveInstBO.getGroupInstId());
                Integer lockMemNum = this.getLockMemNum(actGroupActiveInstBO.getActiveId(), actGroupActiveInstBO.getGroupInstId());
                actGroupActiveInstBO.setGroupMenNum(groupMemNum);
                actGroupActiveInstBO.setLockMemNum(lockMemNum);
            }
            if (actGroupActiveInstBO.getGroupMenNum() + actGroupActiveInstBO.getLockMemNum() >= actGroupActiveInstBO.getFinalMemNum()) continue;
            if (null != actGroupActiveInstBO.getState()) {
                actGroupActiveInstBO.setStateStr(groupActiveInstStateStrMap.get(actGroupActiveInstBO.getState().toString()));
            }
            List<ActGroupActiveInstDetailBO> actGroupActiveInstDetailBOs = this.getActGroupActiveInstDetailBOs(po, busiReqBO);
            actGroupActiveInstBO.setActGroupActiveInstDetailBOs(actGroupActiveInstDetailBOs);
            rows.add(actGroupActiveInstBO);
        }
        ActGroupActiveInstPO totalGroupMenNumPO = new ActGroupActiveInstPO();
        totalGroupMenNumPO.setActiveId(busiReqBO.getActiveId());
        Integer totalGroupMenNum = this.actGroupActiveInstMapper.getTotalGroupMenNum(totalGroupMenNumPO);
        rsp.setRows(rows);
        rsp.setTotalGroupMenNum(totalGroupMenNum);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62fc\u56e2\u5b9e\u4f8b\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private Integer getLockMemNum(Long activeId, Long groupInstId) {
        String lockMemNumRedisKey = "LOCK_TOTAL_" + activeId + "_" + groupInstId;
        Long lockMemNum = this.cacheManager.incrByCount(lockMemNumRedisKey, 0L);
        return lockMemNum.intValue();
    }

    private Integer getGroupMemNum(Long activeId, Long groupInstId) {
        String groupMemNumRedisKey = "SALES_TOTAL_" + activeId + "_" + groupInstId;
        Long groupMemNum = this.cacheManager.incrByCount(groupMemNumRedisKey, 0L);
        return groupMemNum.intValue();
    }

    private List<ActGroupActiveInstDetailBO> getActGroupActiveInstDetailBOs(ActGroupActiveInstPO actGroupActiveInstPO, ActQryGroupActiveInstByPageBusiReqBO busiReqBO) {
        ArrayList<ActGroupActiveInstDetailBO> result = new ArrayList<ActGroupActiveInstDetailBO>();
        ActGroupActiveInstDetailPO actGroupActiveInstDetailPO = new ActGroupActiveInstDetailPO();
        actGroupActiveInstDetailPO.setActiveId(busiReqBO.getActiveId());
        actGroupActiveInstDetailPO.setGroupInstId(actGroupActiveInstPO.getGroupInstId());
        actGroupActiveInstDetailPO.setOrderStatus("1");
        List<ActGroupActiveInstDetailPO> list = this.actGroupActiveInstDetailMapper.getList(actGroupActiveInstDetailPO);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, String> isHeadFlagStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "IS_HEAD_FLAG_PCODE");
            for (ActGroupActiveInstDetailPO po : list) {
                ActGroupActiveInstDetailBO actGroupActiveInstDetailBO = new ActGroupActiveInstDetailBO();
                BeanUtils.copyProperties((Object)po, (Object)actGroupActiveInstDetailBO);
                if (null != actGroupActiveInstDetailBO.getIsHeadFlag()) {
                    actGroupActiveInstDetailBO.setIsHeadFlagStr(isHeadFlagStrMap.get(actGroupActiveInstDetailBO.getIsHeadFlag().toString()));
                }
                result.add(actGroupActiveInstDetailBO);
            }
        }
        return result;
    }
}

