/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.tydic.active.app.ability.bo.WelfarePointsAttachBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeBO;
import com.tydic.active.app.busi.ActQueryWelfarePointsChangeInfoBusiService;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChangeDetailBusiReqBO;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChangeDetailBusiRspBO;
import com.tydic.active.app.common.bo.ActWelfarePointsChangeBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.dao.WelfarePointsAttachMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointsAttachPO;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActQueryWelfarePointsChangeInfoBusiServiceImpl
implements ActQueryWelfarePointsChangeInfoBusiService {
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfarePointsAttachMapper welfarePointsAttachMapper;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;

    public ActQueryWelfarePointsChangeDetailBusiRspBO queryWelfarePointsChangeInfoBusi(ActQueryWelfarePointsChangeDetailBusiReqBO reqBO) {
        ActQueryWelfarePointsChangeDetailBusiRspBO rspBO = new ActQueryWelfarePointsChangeDetailBusiRspBO();
        ActWelfarePointsChangeBO pointsChangeBO = new ActWelfarePointsChangeBO();
        WelfarePointsChangePO pointsChangePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getChangeId());
        if (pointsChangePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(reqBO.getChangeId() + "\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)pointsChangePO, (Object)pointsChangeBO);
        List<WelfarePointsAttachPO> attachPOS = this.welfarePointsAttachMapper.selectListByRelatedId(pointsChangePO.getChangeId());
        List collect = attachPOS.stream().map(item -> {
            WelfarePointsAttachBO attachBO = new WelfarePointsAttachBO();
            BeanUtils.copyProperties((Object)item, (Object)attachBO);
            return attachBO;
        }).collect(Collectors.toList());
        pointsChangeBO.setAttachList(collect);
        rspBO.setWelfarePointsChangeBO(pointsChangeBO);
        this.buildChargeInfo(rspBO, reqBO.getWelfarePointsChargeId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildChargeInfo(ActQueryWelfarePointsChangeDetailBusiRspBO rspBO, Long welfarePointsChargeId) {
        WelfarePointsChargeBO chargeBO = new WelfarePointsChargeBO();
        WelfarePointsChargePO pointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(welfarePointsChargeId);
        List<WelfarePointsAttachPO> welfareActiveAttachPOList = this.welfarePointsAttachMapper.selectListByRelatedId(welfarePointsChargeId);
        ArrayList<WelfarePointsAttachBO> welfareActiveAttachBOS = new ArrayList<WelfarePointsAttachBO>();
        for (WelfarePointsAttachPO welfarePointsAttachPO : welfareActiveAttachPOList) {
            WelfarePointsAttachBO welfarePointsAttachBO = new WelfarePointsAttachBO();
            BeanUtils.copyProperties((Object)welfarePointsAttachPO, (Object)welfarePointsAttachBO);
            welfareActiveAttachBOS.add(welfarePointsAttachBO);
            chargeBO.setWelfareActiveAttachList(welfareActiveAttachBOS);
        }
        BeanUtils.copyProperties((Object)pointsChargePO, (Object)chargeBO);
        chargeBO.setWelfarePointCount(pointsChargePO.getChargeAmount());
        chargeBO.setWelfarePointTypeStr(this.welfarePointTypeStr(pointsChargePO.getWelfarePointType()));
        chargeBO.setWelfareCompanyStr(this.welfareCompanyStr(pointsChargePO.getWelfareCompany()));
        chargeBO.setWelfareTypeStr(this.welfareTypeStr(pointsChargePO.getWelfareType()));
        chargeBO.setStatusStr(this.statusStr(pointsChargePO.getStatus()));
        chargeBO.setPayTypeStr(this.payTypeStr(pointsChargePO.getExtField1()));
        if (Objects.nonNull(pointsChargePO.getTradeMode())) {
            chargeBO.setTradeModeStr(ActActiveConstant.tradeModeType.SELF.equals(chargeBO.getTradeMode()) ? "\u662f" : "\u5426");
        }
        rspBO.setWelfarePointsChargeBO(chargeBO);
    }

    private String welfarePointTypeStr(Byte welfarePointType) {
        String welfarePointTypeStr = null;
        if (welfarePointType != null) {
            if (welfarePointType == 1) {
                welfarePointTypeStr = "\u901a\u7528";
            }
            if (2 == welfarePointType) {
                welfarePointTypeStr = "\u6d3b\u52a8\u4e13\u5c5e";
            }
        }
        return welfarePointTypeStr;
    }

    private String welfareCompanyStr(Byte welfareCompany) {
        String welfareCompanyStr = null;
        if (welfareCompany != null) {
            if (1 == welfareCompany) {
                welfareCompanyStr = "\u8fd0\u8425\u5355\u4f4d";
            }
            if (2 == welfareCompany) {
                welfareCompanyStr = "\u91c7\u8d2d\u5355\u4f4d";
            }
        }
        return welfareCompanyStr;
    }

    private String welfareTypeStr(Byte welfareType) {
        String welfareTypeStr = null;
        if (welfareType != null) {
            if (1 == welfareType) {
                welfareTypeStr = "\u516c\u53f8";
            }
            if (2 == welfareType) {
                welfareTypeStr = "\u5de5\u4f1a";
            }
        }
        return welfareTypeStr;
    }

    private String payTypeStr(String payType2) {
        String payTypeStr = null;
        if (StringUtils.isNotBlank((String)payType2)) {
            if ("1".equals(payType2)) {
                payTypeStr = "\u9884\u5b58\u652f\u4ed8";
            } else if ("2".equals(payType2)) {
                payTypeStr = "\u8d26\u671f\u652f\u4ed8";
            }
        }
        return payTypeStr;
    }

    private String statusStr(Byte status) {
        String statusStr = null;
        if (status != null) {
            if (1 == status) {
                statusStr = "\u5f85\u63d0\u4ea4";
            }
            if (2 == status) {
                statusStr = "\u5ba1\u6838\u4e2d";
            }
            if (3 == status) {
                statusStr = "\u5ba1\u6279\u901a\u8fc7";
            }
            if (4 == status) {
                statusStr = "\u5ba1\u6279\u9a73\u56de";
            }
            if (5 == status) {
                statusStr = "\u5df2\u64a4\u56de";
            }
            if (6 == status) {
                statusStr = "\u51bb\u7ed3";
            }
            if (7 == status) {
                statusStr = "\u5e9f\u6b62";
            }
        }
        return statusStr;
    }
}

