/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.WelfarePointsAttachBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeReqBO;
import com.tydic.active.app.ability.bo.WelfarePointsChargeRspBO;
import com.tydic.active.app.busi.ActUpdateWelfarePointsChargeBusiService;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.dao.WelfarePointsAttachMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.UocApprovalLogPO;
import com.tydic.active.app.dao.po.WelfarePointsAttachPO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.task.TaskTodoWaitService;
import com.tydic.active.app.task.bo.TodoActiveWaitAbilityReqBO;
import com.tydic.active.app.utils.ActDateUtils;
import com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActUpdateWelfarePointsChargeBusiServiceImpl
implements ActUpdateWelfarePointsChargeBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActUpdateWelfarePointsChargeBusiServiceImpl.class);
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfarePointsAttachMapper welfarePointsAttachMapper;
    @Autowired
    private FscRecvClaimListQueryAbilityService fscRecvClaimListQueryAbilityService;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    public WelfarePointsChargeRspBO dealUpdateWelfarePointsCharge(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        List welfareActiveAttachList;
        this.validateParam(welfarePointsChargeReqBO);
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(welfarePointsChargeReqBO.getWelfarePointsChargeId());
        }
        catch (Exception e) {
            log.error("\u798f\u70b9\u5145\u503c\u83b7\u53d6\u5f53\u524d\u5ba1\u6279\u8282\u70b9\u5c97\u4f4did error:{}", (Throwable)e);
        }
        WelfarePointsChargeRspBO rspBO = new WelfarePointsChargeRspBO();
        WelfarePointsChargePO welfarePointsChargePO = new WelfarePointsChargePO();
        BeanUtils.copyProperties((Object)welfarePointsChargeReqBO, (Object)welfarePointsChargePO);
        WelfarePointsChargePO query = this.welfarePointsChargeMapper.selectByPrimaryKey(welfarePointsChargeReqBO.getWelfarePointsChargeId());
        if (query == null) {
            throw new BusinessException("14012", "\u798f\u70b9\u5145\u503c\u4fee\u6539\u5931\u8d25\uff01");
        }
        Date date = new Date();
        String objectId = DateUtils.dateToStr((Date)date, (String)"yyyyMMddHHmmss");
        welfarePointsChargePO.setOperateTime(date);
        welfarePointsChargePO.setBankSerialNumber(welfarePointsChargeReqBO.getBankSerialNumberWeb());
        welfarePointsChargePO.setExtField4(String.valueOf(query.getChargeAmount()));
        int i = this.welfarePointsChargeMapper.updateByPrimaryKeySelective(welfarePointsChargePO);
        if (i != 1) {
            throw new BusinessException("14012", "\u798f\u70b9\u5145\u503c\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u798f\u70b9\u4fee\u6539\u6210\u529f");
        if (!ActActiveConstant.welfarePointsStatus.RECALL.equals(welfarePointsChargeReqBO.getStatus()) || !ActActiveConstant.welfarePointsStatus.RECALL.equals(query.getStatus())) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty((Collection)(welfareActiveAttachList = welfarePointsChargeReqBO.getWelfareActiveAttachList()))) {
            this.welfarePointsAttachMapper.deleteByRelateId(welfarePointsChargeReqBO.getWelfarePointsChargeId());
            ArrayList<WelfarePointsAttachPO> welfarePointsAttachPOList = new ArrayList<WelfarePointsAttachPO>();
            for (WelfarePointsAttachBO welfarePointsAttachBO : welfareActiveAttachList) {
                WelfarePointsAttachPO welfarePointsAttachPO = new WelfarePointsAttachPO();
                BeanUtils.copyProperties((Object)welfarePointsAttachBO, (Object)welfarePointsAttachPO);
                welfarePointsAttachPO.setId(Sequence.getInstance().nextId());
                welfarePointsAttachPO.setRelateId(welfarePointsChargeReqBO.getWelfarePointsChargeId());
                welfarePointsAttachPO.setBusiType((byte)1);
                welfarePointsAttachPOList.add(welfarePointsAttachPO);
            }
            int n = this.welfarePointsAttachMapper.insertBatch(welfarePointsAttachPOList);
            if (n == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u9644\u4ef6\u4fee\u6539\u5931\u8d25");
            }
        }
        if (welfarePointsChargeReqBO.getStatus() == 5) {
            try {
                TodoActiveWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoActiveWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setCenterCode("active");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setBusiCode("1001");
                todoUccWaitAbilityReqBO.setBusiName("\u798f\u70b9\u5145\u503c\u5ba1\u6279");
                todoUccWaitAbilityReqBO.setObjId(welfarePointsChargePO.getWelfarePointsChargeId());
                if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                    todoUccWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId().toString());
                }
                this.taskTodoWaitService.handler(todoUccWaitAbilityReqBO);
            }
            catch (Exception e) {
                log.error("\u798f\u70b9\u5145\u503c\u64a4\u56de - \u5f85\u529e\u901a\u77e5 error:{}", (Throwable)e);
            }
        }
        return rspBO;
    }

    private void validateParam(WelfarePointsChargeReqBO welfarePointsChargeReqBO) {
        if (null == welfarePointsChargeReqBO) {
            throw new BusinessException("14000", "\u798f\u5229\u5145\u503c\u5217\u8868\u67e5\u8be2\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void backRecClaim(WelfarePointsChargePO po) {
        FscRecvClaimListQueryAbilityReqBO queryReqBO = new FscRecvClaimListQueryAbilityReqBO();
        queryReqBO.setSerialNumber(po.getBankSerialNumber());
        FscRecvClaimListQueryAbilityRspBO queryAbilityRspBO = this.fscRecvClaimListQueryAbilityService.qryRecvClaimList(queryReqBO);
        log.info("\u67e5\u8be2\u7ed3\u7b97\u6536\u6b3e\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)queryAbilityRspBO));
        ArrayList<FscClaimDetailBO> detailBOS = new ArrayList<FscClaimDetailBO>();
        for (FscRecvClaimBO fscRecvClaimBO : queryAbilityRspBO.getRows()) {
            if (!po.getBankSerialNumber().equals(fscRecvClaimBO.getSerialNumber())) continue;
            FscRecvClaimConfirmAbilityReqBO bo = new FscRecvClaimConfirmAbilityReqBO();
            bo.setClaimId(fscRecvClaimBO.getClaimId());
            bo.setRecvAmt(fscRecvClaimBO.getRecvAmt());
            BigDecimal noClaimAmt = fscRecvClaimBO.getNoClaimAmt().add(po.getChargeAmount());
            bo.setNoClaimAmt(noClaimAmt.setScale(2, 4));
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            detailBO.setClaimAmt(po.getChargeAmount());
            detailBO.setClaimDate(ActDateUtils.strToDate(ActDateUtils.dateToStr(new Date())));
            detailBO.setOperationType(ActActiveConstant.fscRecvClaimConfirmType.CANCEL);
            detailBO.setObjectId(po.getWelfarePointsChargeId());
            detailBO.setObjectNo(po.getWelfarePointChargeCode());
            detailBO.setClaimType("5");
            detailBOS.add(detailBO);
            bo.setClaimDetailList(detailBOS);
            log.info("\u7ed3\u7b97\u64a4\u56de\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)bo));
            FscRecvClaimConfirmAbilityRspBO rspBO = this.fscRecvClaimConfirmAbilityService.recvClaimConfirm(bo);
            if ("0000".equals(rspBO.getRespCode())) continue;
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }

    void backChargeAmount(WelfarePointsChargePO po, WelfarePointsChargeReqBO reqBO, BigDecimal releaseAmout, String objectId) {
        FscAccountDealWelfareDeductAbilityReqBO fscReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        fscReqBO.setSupId(this.operationOrgId);
        fscReqBO.setCreditOrgId(po.getOrgIdWelfarePoints());
        Integer payType2 = this.translate(po.getExtField1());
        if (payType2 == null) {
            throw new BusinessException("8888", "\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38!");
        }
        try {
            fscReqBO.setObjId(Long.valueOf(Long.parseLong(objectId)));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "objectId\u8f6c\u6362\u5f02\u5e38!");
        }
        fscReqBO.setPayType(payType2);
        fscReqBO.setOperationType(Integer.valueOf(1));
        fscReqBO.setOrderId(po.getWelfarePointsChargeId());
        fscReqBO.setOrderNo(po.getWelfarePointChargeCode());
        fscReqBO.setTotalAmount(releaseAmout.negate());
        fscReqBO.setBusiOrderType(Integer.valueOf(3));
        fscReqBO.setWelfareType(Integer.valueOf(po.getWelfareType().byteValue()));
        fscReqBO.setUserId(reqBO.getUserId());
        fscReqBO.setUserName(reqBO.getUserName());
        fscReqBO.setName(reqBO.getName());
        fscReqBO.setOrgId(reqBO.getOrgId());
        FscAccountDealWelfareDeductAbilityRspBO fscRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(fscReqBO);
        if (!"0000".equals(fscRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u798f\u70b9\u5145\u503c\u7f16\u53f7:" + po.getWelfarePointChargeCode() + ",\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u9000\u6b3e\u5931\u8d25!,\u539f\u56e0:" + fscRspBO.getRespDesc());
        }
    }

    private Integer translate(String extField1) {
        if ("1".equals(extField1)) {
            return 3;
        }
        if ("2".equals(extField1)) {
            return 2;
        }
        return null;
    }
}

