/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.ActWelfarePointConsumeReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointConsumeRspBO;
import com.tydic.active.app.busi.ActWelfarePointConsumeBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChangeLogMapper;
import com.tydic.active.app.dao.WelfarePointsMemWalletMapper;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsMemWalletLogPO;
import com.tydic.active.app.dao.po.WelfarePointsMemWalletPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActWelfarePointConsumeBusiServiceImpl
implements ActWelfarePointConsumeBusiService {
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfarePointsMemWalletMapper welfarePointsMemWalletMapper;
    @Autowired
    private WelfarePointsChangeLogMapper welfarePointsChangeLogMapper;

    public ActWelfarePointConsumeRspBO consumeWelfarePoint(ActWelfarePointConsumeReqBO reqBO) {
        ActWelfarePointConsumeRspBO rspBO = new ActWelfarePointConsumeRspBO();
        this.validActive(reqBO, rspBO);
        WelfarePointsMemWalletPO welfarePointsMemWalletPO = this.welfarePointsMemWalletMapper.selectByMemId(reqBO.getMemId(), reqBO.getWelfarePointGrantId());
        if (welfarePointsMemWalletPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u4e0d\u5728\u798f\u5229\u4e2d\uff01");
            return rspBO;
        }
        if (reqBO.getOrderAmount().compareTo(BigDecimal.ZERO) < 0) {
            WelfarePointsMemWalletLogPO logPO = this.welfarePointsChangeLogMapper.selectByOrderId(reqBO.getOrderId());
            if (logPO == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6ca1\u6709\u6d88\u8d39\u8bb0\u5f55\uff01");
                return rspBO;
            }
            if (logPO.getUsedPoints() == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6ca1\u6709\u6d88\u8d39\u8bb0\u5f55\uff01");
                return rspBO;
            }
            if (logPO.getUsedPoints().compareTo(BigDecimal.ZERO) == 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5df2\u7ecf\u9000\u6b3e\u5b8c\u4e86\uff01");
                return rspBO;
            }
        }
        BigDecimal changeAmount = new BigDecimal("0");
        if (welfarePointsMemWalletPO.getBalancePoints().compareTo(reqBO.getOrderAmount()) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u798f\u70b9\u4f59\u989d\u4e0d\u8db3\uff01");
            return rspBO;
        }
        changeAmount = reqBO.getOrderAmount();
        BigDecimal BalancePoints = welfarePointsMemWalletPO.getBalancePoints();
        if (changeAmount.compareTo(new BigDecimal("0")) < 0 && BalancePoints.subtract(changeAmount).compareTo(welfarePointsMemWalletPO.getWelfarePoints()) > 0) {
            throw new BusinessException("8888", "\u9000\u6b3e\u5931\u8d25!\u672a\u67e5\u8be2\u5230\u6d88\u8d39\u8bb0\u5f55!");
        }
        int update = this.welfarePointsMemWalletMapper.updateWalletBalance(welfarePointsMemWalletPO.getId(), welfarePointsMemWalletPO.getMemId(), changeAmount);
        if (update == 0) {
            throw new BusinessException("8888", "\u798f\u70b9\u4f59\u989d\u66f4\u65b0\u5931\u8d25");
        }
        WelfarePointsMemWalletPO welfarePointsMemWalletPOConsumCheck = this.welfarePointsMemWalletMapper.selectByMemId(reqBO.getMemId(), reqBO.getWelfarePointGrantId());
        if (welfarePointsMemWalletPOConsumCheck.getBalancePoints().compareTo(new BigDecimal("0")) < 0) {
            throw new BusinessException("8888", "\u6d88\u8d39\u5931\u8d25!\u4f59\u989d\u4e0d\u8db3!");
        }
        if (welfarePointsMemWalletPOConsumCheck.getWelfarePoints().compareTo(welfarePointsMemWalletPOConsumCheck.getUsedPoints()) < 0) {
            throw new BusinessException("8888", "\u6d88\u8d39\u5931\u8d25!\u4f59\u989d\u4e0d\u8db3!");
        }
        WelfarePointsMemWalletLogPO welfarePointsMemWalletLogPO = new WelfarePointsMemWalletLogPO();
        welfarePointsMemWalletLogPO.setId(Sequence.getInstance().nextId());
        welfarePointsMemWalletLogPO.setRelateId(welfarePointsMemWalletPO.getId());
        welfarePointsMemWalletLogPO.setOrderAmount(changeAmount);
        welfarePointsMemWalletLogPO.setOrderId(reqBO.getOrderId());
        welfarePointsMemWalletLogPO.setOrderNo(reqBO.getOrderNo());
        welfarePointsMemWalletLogPO.setUsedPoints(changeAmount);
        welfarePointsMemWalletLogPO.setUpdateTime(new Date());
        int insert = this.welfarePointsChangeLogMapper.insert(welfarePointsMemWalletLogPO);
        if (insert == 0) {
            throw new BusinessException("8888", "\u798f\u70b9\u6d88\u8d39\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
        }
        WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
        welfarePointGrantPO.setWelfarePointGrantId(reqBO.getWelfarePointGrantId());
        welfarePointGrantPO.setUsedPoints(changeAmount);
        this.welfarePointGrantMapper.updateUsed(welfarePointGrantPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public ActWelfarePointConsumeRspBO consumeWelfarePointCheck(ActWelfarePointConsumeReqBO reqBO) {
        ActWelfarePointConsumeRspBO rspBO = new ActWelfarePointConsumeRspBO();
        this.validActive(reqBO, rspBO);
        WelfarePointsMemWalletPO welfarePointsMemWalletPO = this.welfarePointsMemWalletMapper.selectByMemId(reqBO.getMemId(), reqBO.getWelfarePointGrantId());
        if (welfarePointsMemWalletPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u4e0d\u5728\u798f\u5229\u4e2d\uff01");
            return rspBO;
        }
        BigDecimal changeAmount = new BigDecimal("0");
        if (welfarePointsMemWalletPO.getBalancePoints().compareTo(reqBO.getOrderAmount()) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u798f\u70b9\u4f59\u989d\u4e0d\u8db3\uff01");
            return rspBO;
        }
        changeAmount = reqBO.getOrderAmount();
        if (welfarePointsMemWalletPO.getWelfarePoints().subtract(welfarePointsMemWalletPO.getUsedPoints()).compareTo(reqBO.getOrderAmount()) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u798f\u70b9\u4f59\u989d\u4e0d\u8db3\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private ActWelfarePointConsumeRspBO validActive(ActWelfarePointConsumeReqBO reqBO, ActWelfarePointConsumeRspBO rspBO) {
        Date now;
        WelfarePointGrantPO welfarePointGrantPO = this.welfarePointGrantMapper.selectByPrimaryKey(reqBO.getWelfarePointGrantId());
        if (welfarePointGrantPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u798f\u70b9\u53d1\u653e\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        if (Objects.nonNull(reqBO.getActiveId())) {
            WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(reqBO.getActiveId());
            if (welfareActivePO == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6d3b\u52a8\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (!welfareActivePO.getActiveStatus().equals(ActCommConstant.WelfareActiveStatus.VALID)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u751f\u6548\u72b6\u6001\uff01");
            }
        }
        if ((now = new Date()).before(welfarePointGrantPO.getEffectiveStart()) || now.after(welfarePointGrantPO.getEffectiveEnd())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6d3b\u52a8\u4e0d\u5728\u6709\u6548\u65f6\u95f4\u5185\uff01");
        }
        return rspBO;
    }
}

