/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.ActiveScopeBO;
import com.tydic.active.app.ability.bo.WelfareActiveAttachBO;
import com.tydic.active.app.ability.bo.WelfareActiveCreateReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveCreateRspBO;
import com.tydic.active.app.busi.WelfareActiveCreateBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActiveOperLogMapper;
import com.tydic.active.app.dao.ActiveScopeMapper;
import com.tydic.active.app.dao.WelfareActiveAttachMapper;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfareActiveMemMapper;
import com.tydic.active.app.dao.WelfarePointsGrantMemMapper;
import com.tydic.active.app.dao.po.ActiveOperLogPO;
import com.tydic.active.app.dao.po.ActiveScopePO;
import com.tydic.active.app.dao.po.WelfareActiveAttachPO;
import com.tydic.active.app.dao.po.WelfareActivePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WelfareActiveCreateBusiServiceImpl
implements WelfareActiveCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(WelfareActiveCreateBusiServiceImpl.class);
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfareActiveAttachMapper welfareActiveAttachMapper;
    @Autowired
    private WelfarePointsGrantMemMapper welfarePointsGrantMemMapper;
    @Autowired
    private WelfareActiveMemMapper welfareActiveMemMapper;
    @Autowired
    private ActiveScopeMapper activeScopeMapper;
    @Autowired
    private ActiveOperLogMapper activeOperLogMapper;

    public WelfareActiveCreateRspBO saveActive(WelfareActiveCreateReqBO reqBO) {
        WelfareActiveCreateRspBO rspBO = new WelfareActiveCreateRspBO();
        Long activeId = null;
        WelfareActivePO welfareActivePO = new WelfareActivePO();
        BeanUtils.copyProperties((Object)reqBO.getWelfareActiveBO(), (Object)welfareActivePO);
        if (reqBO.getWelfareActiveBO().getActiveId() == null) {
            activeId = Sequence.getInstance().nextId();
            welfareActivePO.setCreateName(reqBO.getName());
            welfareActivePO.setCreateId(reqBO.getUserId());
            welfareActivePO.setCreateCode(reqBO.getOccupation());
            welfareActivePO.setCreateOrgId(reqBO.getOrgId());
            welfareActivePO.setCreateOrgName(reqBO.getOrgName());
            welfareActivePO.setCreateOrgCode(reqBO.getOrgCodeIn());
            welfareActivePO.setCreateTime(new Date());
            welfareActivePO.setActiveId(activeId);
            welfareActivePO.setActiveStatus(ActCommConstant.WelfareActiveStatus.NOT_COMPLETE);
            welfareActivePO.setAuditStatus(ActCommConstant.WelfareActiveAuditStatus.TO_COMMIT);
            int insert = this.welfareActiveMapper.insert(welfareActivePO);
            if (insert < 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6d3b\u52a8\u4e3b\u4f53\u65b0\u589e\u5931\u8d25\uff01");
                return rspBO;
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getWelfareActiveBO().getScopes())) {
                ArrayList<ActiveScopePO> list = new ArrayList<ActiveScopePO>();
                for (ActiveScopeBO bo : reqBO.getWelfareActiveBO().getScopes()) {
                    ActiveScopePO scopePO = new ActiveScopePO();
                    BeanUtils.copyProperties((Object)bo, (Object)scopePO);
                    scopePO.setActiveId(activeId);
                    scopePO.setCreateLoginId(reqBO.getUserId());
                    scopePO.setCreateName(reqBO.getName());
                    scopePO.setCreateTime(new Date());
                    scopePO.setId(Sequence.getInstance().nextId());
                    scopePO.setIsDelete(0);
                    list.add(scopePO);
                }
                this.activeScopeMapper.insertBatch(list);
            }
        } else {
            activeId = reqBO.getWelfareActiveBO().getActiveId();
            WelfareActivePO updateCheckPO = this.welfareActiveMapper.selectByPrimaryKey(activeId);
            if (updateCheckPO == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6d3b\u52a8\u4e0d\u5b58\u5728,\u4fee\u6539\u5931\u8d25\uff01");
                return rspBO;
            }
            welfareActivePO.setUpdateTime(new Date());
            welfareActivePO.setActiveId(activeId);
            int insert = this.welfareActiveMapper.updateByPrimaryKey(welfareActivePO);
            if (insert < 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6d3b\u52a8\u4e3b\u4f53\u65b0\u589e\u5931\u8d25\uff01");
                return rspBO;
            }
            if (activeId != null) {
                ActiveScopePO activeScopePO = new ActiveScopePO();
                activeScopePO.setActiveId(activeId);
                this.activeScopeMapper.delete(activeScopePO);
            }
            if (!StringUtils.isEmpty((Object)reqBO.getWelfareActiveBO().getScopes())) {
                ArrayList<ActiveScopePO> list = new ArrayList<ActiveScopePO>();
                for (ActiveScopeBO bo : reqBO.getWelfareActiveBO().getScopes()) {
                    ActiveScopePO scopePO = new ActiveScopePO();
                    BeanUtils.copyProperties((Object)bo, (Object)scopePO);
                    scopePO.setCreateLoginId(reqBO.getUserId());
                    scopePO.setActiveId(activeId);
                    scopePO.setCreateName(reqBO.getName());
                    scopePO.setCreateTime(new Date());
                    scopePO.setId(Sequence.getInstance().nextId());
                    scopePO.setIsDelete(0);
                    list.add(scopePO);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    this.activeScopeMapper.insertBatch(list);
                }
            }
            if (updateCheckPO.getAuditStatus() != null && updateCheckPO.getAuditStatus() == 2) {
                ActiveOperLogPO activeOperLogPO = new ActiveOperLogPO();
                activeOperLogPO.setActiveId(activeId);
                activeOperLogPO.setId(Sequence.getInstance().nextId());
                activeOperLogPO.setType(1);
                activeOperLogPO.setCreateLoginId(reqBO.getUserId());
                activeOperLogPO.setCreateName(reqBO.getName());
                activeOperLogPO.setCreateTime(new Date());
                activeOperLogPO.setUpdateLoginId(reqBO.getUserId());
                activeOperLogPO.setUpdateName(reqBO.getName());
                activeOperLogPO.setUpdateTime(new Date());
                this.activeOperLogMapper.insert(activeOperLogPO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWelfareActiveAttachList()) && activeId != null) {
            this.welfareActiveAttachMapper.deleteByActiveId(activeId);
            ArrayList<WelfareActiveAttachPO> welfareActiveAttachPOS = new ArrayList<WelfareActiveAttachPO>();
            for (WelfareActiveAttachBO welfareActiveAttachBO : reqBO.getWelfareActiveAttachList()) {
                WelfareActiveAttachPO welfareActiveAttachPO = new WelfareActiveAttachPO();
                welfareActiveAttachPO.setActiveId(activeId);
                welfareActiveAttachPO.setId(Sequence.getInstance().nextId());
                welfareActiveAttachPO.setName(welfareActiveAttachBO.getName());
                welfareActiveAttachPO.setUrl(welfareActiveAttachBO.getUrl());
                welfareActiveAttachPO.setBusiType(welfareActiveAttachBO.getBusiType());
                welfareActiveAttachPOS.add(welfareActiveAttachPO);
            }
            int result = this.welfareActiveAttachMapper.insertBatch(welfareActiveAttachPOS);
            if (result != welfareActiveAttachPOS.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u9644\u4ef6\u63d2\u5165\u5931\u8d25\uff01");
                return rspBO;
            }
        }
        rspBO.setActiveId(activeId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

