/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.active.app.atom.WelfareSendNotificationAtomService;
import com.tydic.active.app.atom.bo.WelfareSendNotificationAtomReqBO;
import com.tydic.active.app.atom.bo.WelfareSendNotificationAtomRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.AuditMapper;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.AuditPO;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class WelfareSendNotificationServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(WelfareSendNotificationServiceConsumer.class);
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private WelfareSendNotificationAtomService welfareSendNotificationAtomService;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private AuditMapper auditMapper;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            WelfareSendNotificationAtomReqBO reqBO;
            if (log.isDebugEnabled()) {
                log.debug("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)message.getContent()));
            }
            if ((reqBO = (WelfareSendNotificationAtomReqBO)((Object)JSONObject.parseObject((String)message.getContent(), WelfareSendNotificationAtomReqBO.class))).getNotificationType().equals(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_CHARGE_AUDIT)) {
                if (reqBO.getFinish().booleanValue()) {
                    this.dealWelfareChargeAuditResult(reqBO);
                } else {
                    this.dealWelfareChargeAudit(reqBO);
                }
            } else if (reqBO.getNotificationType().equals(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_ABNORMAL_AUDIT)) {
                if (reqBO.getFinish().booleanValue()) {
                    this.dealWelfareAbnormalAuditResult(reqBO);
                } else {
                    this.dealWelfareAbnormalAudit(reqBO);
                }
            } else if (reqBO.getNotificationType().equals(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_GRANT_AUDIT)) {
                if (reqBO.getFinish().booleanValue()) {
                    this.dealWelfareGrantAuditResult(reqBO);
                } else {
                    this.dealWelfareGrantAudit(reqBO);
                }
            } else if (reqBO.getNotificationType().equals(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_GRANT_CHANGE_AUDIT)) {
                if (reqBO.getFinish().booleanValue()) {
                    this.dealWelfareGrantChangeAuditResult(reqBO);
                } else {
                    this.dealWelfareGrantChangeAudit(reqBO);
                }
            } else if (reqBO.getNotificationType().equals(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_ACTIVE_AUDIT)) {
                if (reqBO.getFinish().booleanValue()) {
                    this.dealWelfareActiveAuditResult(reqBO);
                } else {
                    this.dealWelfareActiveAudit(reqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u6d88\u8d39\u5931\u8d25\uff01" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareActiveAuditResult(WelfareSendNotificationAtomReqBO reqBO) {
        WelfareActivePO activePO = this.welfareActiveMapper.selectByPrimaryKey(reqBO.getObjId());
        if (!reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
            reqBO.setTitel(activePO.getActiveCode() + "_" + activePO.getActiveName() + "\u5ba1\u6279\u9a73\u56de");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u6d3b\u52a8" + activePO.getActiveCode() + "\u5ba1\u6279\u9a73\u56de\u3002");
            reqBO.setReceiveIds(Collections.singletonList(activePO.getCreateId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareActiveAudit(WelfareSendNotificationAtomReqBO reqBO) {
        WelfareActivePO activePO = this.welfareActiveMapper.selectByPrimaryKey(reqBO.getObjId());
        List<Long> receiveIds = this.qryTaskUserIds(reqBO.getObjId());
        if (!CollectionUtils.isEmpty(receiveIds)) {
            reqBO.setTitel(activePO.getActiveCode() + "_" + activePO.getActiveName() + "\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u6d3b\u52a8" + activePO.getActiveCode() + "\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareGrantChangeAudit(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getObjId());
        WelfarePointGrantPO grantPO = this.welfarePointGrantMapper.selectByPrimaryKey(changePO.getWelfarePointGrantId());
        String welfareTypeStr = this.transform(grantPO.getWelfareType().toString(), "welfare_type");
        List<Long> receiveIds = this.qryTaskUserIds(reqBO.getObjId());
        if (!CollectionUtils.isEmpty(receiveIds)) {
            reqBO.setTitel(grantPO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u53d1\u653e\u53d8\u66f4\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u53d1\u653e\u53d8\u66f4" + changePO.getChangeCode() + "\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(Collections.singletonList(grantPO.getOperateId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareGrantChangeAuditResult(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getObjId());
        WelfarePointGrantPO grantPO = this.welfarePointGrantMapper.selectByPrimaryKey(changePO.getWelfarePointGrantId());
        String welfareTypeStr = this.transform(grantPO.getWelfareType().toString(), "welfare_type");
        if (!reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
            reqBO.setTitel(grantPO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u53d1\u653e\u53d8\u66f4\u5ba1\u6279\u9a73\u56de");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u53d1\u653e\u53d8\u66f4" + changePO.getChangeCode() + "\u5ba1\u6279\u9a73\u56de\u3002");
            reqBO.setReceiveIds(Collections.singletonList(changePO.getChangeMemId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareGrantAuditResult(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointGrantPO grantPO = this.welfarePointGrantMapper.selectByPrimaryKey(reqBO.getObjId());
        String welfareTypeStr = this.transform(grantPO.getWelfareType().toString(), "welfare_type");
        if (!reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
            reqBO.setTitel(grantPO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u53d1\u653e\u5ba1\u6279\u9a73\u56de");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u53d1\u653e" + grantPO.getWelfarePointCode() + "\u5ba1\u6279\u9a73\u56de\u3002");
            reqBO.setReceiveIds(Collections.singletonList(grantPO.getOperateId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareGrantAudit(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointGrantPO grantPO = this.welfarePointGrantMapper.selectByPrimaryKey(reqBO.getObjId());
        String welfareTypeStr = this.transform(grantPO.getWelfareType().toString(), "welfare_type");
        List<Long> receiveIds = this.qryTaskUserIds(reqBO.getObjId());
        if (!CollectionUtils.isEmpty(receiveIds)) {
            reqBO.setTitel(grantPO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u53d1\u653e\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u53d1\u653e" + grantPO.getWelfarePointCode() + "\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareAbnormalAuditResult(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getObjId());
        WelfarePointsChargePO chargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(changePO.getWelfarePointsChargeId());
        String welfareTypeStr = this.transform(chargePO.getWelfareType().toString(), "welfare_type");
        if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
            reqBO.setTitel(chargePO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u5145\u503c\u5f02\u5e38\u5f85\u786e\u8ba4");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u5145\u503c\u5f02\u5e38" + changePO.getChangeCode() + "\u5f85\u786e\u8ba4\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(Collections.singletonList(changePO.getChangeMemId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareChargeAuditResult(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChargePO chargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(reqBO.getObjId());
        String welfareTypeStr = this.transform(chargePO.getWelfareType().toString(), "welfare_type");
        if (!reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
            reqBO.setTitel(chargePO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u5145\u503c\u5ba1\u6279\u9a73\u56de");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u5145\u503c" + chargePO.getWelfarePointChargeCode() + "\u5ba1\u6279\u9a73\u56de\u3002");
            reqBO.setReceiveIds(Collections.singletonList(chargePO.getOperateId()));
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareAbnormalAudit(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getObjId());
        WelfarePointsChargePO chargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(changePO.getWelfarePointsChargeId());
        String welfareTypeStr = this.transform(chargePO.getWelfareType().toString(), "welfare_type");
        List<Long> receiveIds = this.qryTaskUserIds(reqBO.getObjId());
        if (!CollectionUtils.isEmpty(receiveIds)) {
            reqBO.setTitel(chargePO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u5145\u503c\u5f02\u5e38\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u5145\u503c\u5f02\u5e38" + changePO.getChangeCode() + "\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        log.error(JSONObject.toJSONString((Object)((Object)reqBO)) + "\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5ba1\u6279\u4eba\u5458\u4fe1\u606f\uff1a");
        return null;
    }

    private WelfareSendNotificationAtomRspBO dealWelfareChargeAudit(WelfareSendNotificationAtomReqBO reqBO) {
        WelfarePointsChargePO chargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(reqBO.getObjId());
        List<Long> receiveIds = this.qryTaskUserIds(reqBO.getObjId());
        String welfareTypeStr = this.transform(chargePO.getWelfareType().toString(), "welfare_type");
        if (!CollectionUtils.isEmpty(receiveIds)) {
            reqBO.setTitel(chargePO.getWelfarePointChargeCode() + "_" + welfareTypeStr + "\u5145\u503c\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u798f\u70b9\u5145\u503c" + chargePO.getWelfarePointChargeCode() + "\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            return this.welfareSendNotificationAtomService.sendNotification(reqBO);
        }
        log.error(JSONObject.toJSONString((Object)((Object)reqBO)) + "\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5ba1\u6279\u4eba\u5458\u4fe1\u606f\uff1a");
        return null;
    }

    private List<Long> qryTaskUserIds(Long objId) {
        AuditPO auditPO = new AuditPO();
        auditPO.setOrderId(objId);
        List<AuditPO> taskOperIdList = this.auditMapper.getTaskOperIdList(auditPO);
        if (!CollectionUtils.isEmpty(taskOperIdList)) {
            DycStationOrgSelectUserNameReqBO selectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            selectUserNameReqBO.setStationId(taskOperIdList.get(0).getObjId());
            DycStationOrgSelectUserNameRspBO selectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(selectUserNameReqBO);
            if (selectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)selectUserNameRspBO.getUserList())) {
                return selectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList());
            }
        }
        return null;
    }

    private String transform(String code, String pCode) {
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setCode(code);
        dicDictionaryPO.setPCode(pCode);
        dicDictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (dicDictionaryPO != null) {
            return dicDictionaryPO.getDescrip();
        }
        return null;
    }
}

