/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.task.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.active.app.dao.UocApprovalLogMapper;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.UocApprovalLogPO;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.task.TaskTodoWaitService;
import com.tydic.active.app.task.bo.TodoActiveWaitAbilityReqBO;
import com.tydic.active.app.task.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoWaitAbilityReqBO;
import com.tydic.active.app.task.util.DycActiveTodoWaitDoneProvider;
import com.tydic.active.app.task.util.TaskWaitDoneEnum;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TaskTodoWaitServiceImpl
implements TaskTodoWaitService {
    private static final Logger log = LoggerFactory.getLogger(TaskTodoWaitServiceImpl.class);
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private DycActiveTodoWaitDoneProvider dycActiveTodoWaitDoneProviderService;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;

    @Override
    public void handler(TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoActiveWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoActiveWaitAbilityReqBO));
        this.assertParam(todoActiveWaitAbilityReqBO);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        try {
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoActiveWaitAbilityReqBO.getObjId());
            log.info("TaskTodoWaitService uocApprovalLogPO:{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
            String ext2 = this.getExt2(todoActiveWaitAbilityReqBO);
            switch (todoActiveWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmit(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    if (Objects.nonNull(todoSubmitWaitAbilityReqBO)) {
                        todoSubmitWaitAbilityReqBO.setExt2(ext2);
                        this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    }
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO;
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO;
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    if (Objects.nonNull(todoDonePassWaitAbilityReqBO)) {
                        todoDonePassWaitAbilityReqBO.setExt2(ext2);
                        this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    }
                    if (Objects.nonNull(todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO))) {
                        this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    }
                    if (uocApprovalLogPO.getFinish() == 0 && Objects.nonNull(todoAddPassWaitAbilityReqBO = this.operatorAddApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO))) {
                        todoAddPassWaitAbilityReqBO.setExt2(ext2);
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoReturnWaitAbilityReqBO = this.operatorReturn(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    if (Objects.nonNull(todoReturnWaitAbilityReqBO)) {
                        this.cancelTodoWait(todoReturnWaitAbilityReqBO);
                    }
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService handler error:{}", (Throwable)e);
        }
    }

    private String getExt2(TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        String ext2 = null;
        switch (todoActiveWaitAbilityReqBO.getBusiCode()) {
            case "1002": 
            case "1004": {
                WelfarePointsChangePO record1 = new WelfarePointsChangePO();
                record1.setChangeId(todoActiveWaitAbilityReqBO.getObjId());
                WelfarePointsChangePO welfarePointsChangePO1 = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(record1);
                if (!Objects.nonNull(welfarePointsChangePO1) || !Objects.nonNull(welfarePointsChangePO1.getChangeId())) break;
                Long changeId = welfarePointsChangePO1.getChangeId();
                Long welfarePointsChargeId = welfarePointsChangePO1.getWelfarePointsChargeId();
                todoActiveWaitAbilityReqBO.setObjId(welfarePointsChargeId);
                ext2 = changeId.toString();
                break;
            }
            case "1006": {
                WelfarePointsChangePO record = new WelfarePointsChangePO();
                record.setWelfarePointsChargeId(todoActiveWaitAbilityReqBO.getObjId());
                WelfarePointsChangePO welfarePointsChangePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(record);
                if (!Objects.nonNull(welfarePointsChangePO) || !Objects.nonNull(welfarePointsChangePO.getChangeId())) break;
                Long changeId = welfarePointsChangePO.getChangeId();
                ext2 = changeId.toString();
            }
        }
        return ext2;
    }

    private TodoWaitAbilityReqBO operatorReturn(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        String nextStationId = todoActiveWaitAbilityReqBO.getStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        Assert.notNull((Object)nextStationId, (String)"\u5c97\u4f4did\u4e3a\u7a7a");
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId);
        if (dycStationOrgSelectUserNameRspBO1 != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorReturn return userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            todoPassWaitAbilityReqBO.setCancelList(userList.stream().map(user -> {
                TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
                todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
                return todoCancelWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoActiveWaitAbilityReqBO.getObjId());
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        }
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        Long nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        String objNo = null;
        String createCode = null;
        String createName = null;
        if (Objects.nonNull(nextStationId)) {
            switch (todoActiveWaitAbilityReqBO.getBusiCode()) {
                case "1005": {
                    WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfareActivePO)) break;
                    objNo = welfareActivePO.getActiveCode();
                    createCode = welfareActivePO.getCreateCode();
                    createName = welfareActivePO.getCreateName();
                    break;
                }
                case "1001": 
                case "1002": {
                    WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfarePointsChargePO)) break;
                    objNo = welfarePointsChargePO.getWelfarePointChargeCode();
                    createCode = welfarePointsChargePO.getOperateCode();
                    createName = welfarePointsChargePO.getOperateName();
                    break;
                }
                case "1004": 
                case "1003": {
                    WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                    welfarePointGrantPO.setWelfarePointGrantId(objId);
                    WelfarePointGrantPO modelBy = this.welfarePointGrantMapper.getModelBy(welfarePointGrantPO);
                    if (!Objects.nonNull(modelBy)) break;
                    objNo = modelBy.getWelfarePointCode();
                    createCode = modelBy.getOperateCode();
                    createName = modelBy.getOperateName();
                }
            }
        }
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                todoPassWaitAbilityReqBO.setExt1(objNo);
                String finalObjNo = objNo;
                todoPassWaitAbilityReqBO.setCreateId(createCode);
                todoPassWaitAbilityReqBO.setCreateName(createName);
                todoPassWaitAbilityReqBO.setExt7(uocApprovalLogPO.getAuditOrderId() + "");
                todoPassWaitAbilityReqBO.setExt8(uocApprovalLogPO.getId() + "");
                todoPassWaitAbilityReqBO.setRemark(uocApprovalLogPO.getNextStepName());
                todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalObjNo);
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        log.info("operatorCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)objId);
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            String stationId = todoActiveWaitAbilityReqBO.getStationId();
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(stationId);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                List collect = userList.stream().filter($ -> !$.getLoginName().equals(regAccount)).collect(Collectors.toList());
                log.info("operatorCancelApproval cancel userCode:{},ObjId:{}", (Object)JSON.toJSONString(collect), (Object)objId);
                todoPassWaitAbilityReqBO.setCancelList(collect.stream().map(user -> {
                    TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
                    todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
                    return todoCancelWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoActiveWaitAbilityReqBO.getObjId());
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
            todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
            todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
            TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
            todoAddAlreadyDoneAbilityReqBO.setObjId(todoActiveWaitAbilityReqBO.getObjId().toString());
            todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
            todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
            todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
            todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoActiveWaitAbilityReqBO.getObjId());
            return null;
        }
        Long nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        String busiCode = todoActiveWaitAbilityReqBO.getBusiCode();
        String createCode = null;
        String createName = null;
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        String objNo = null;
        if (Objects.nonNull(nextStationId)) {
            switch (busiCode) {
                case "1005": {
                    WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfareActivePO)) break;
                    objNo = welfareActivePO.getActiveCode();
                    createCode = welfareActivePO.getCreateCode();
                    createName = welfareActivePO.getCreateName();
                    break;
                }
                case "1001": 
                case "1002": {
                    WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfarePointsChargePO)) break;
                    objNo = welfarePointsChargePO.getWelfarePointChargeCode();
                    createCode = welfarePointsChargePO.getOperateCode();
                    createName = welfarePointsChargePO.getOperateName();
                    break;
                }
                case "1004": 
                case "1003": {
                    WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                    welfarePointGrantPO.setWelfarePointGrantId(objId);
                    WelfarePointGrantPO modelBy = this.welfarePointGrantMapper.getModelBy(welfarePointGrantPO);
                    if (!Objects.nonNull(modelBy)) break;
                    objNo = modelBy.getWelfarePointCode();
                    createCode = modelBy.getOperateCode();
                    createName = modelBy.getOperateName();
                }
            }
        }
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO.getUserList();
            log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
            todoWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
            todoWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
            todoWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
            todoWaitAbilityReqBO.setExt1(objNo);
            todoWaitAbilityReqBO.setCreateId(createCode);
            todoWaitAbilityReqBO.setCreateName(createName);
            todoWaitAbilityReqBO.setExt7(uocApprovalLogPO.getAuditOrderId() + "");
            todoWaitAbilityReqBO.setExt8(uocApprovalLogPO.getId() + "");
            todoWaitAbilityReqBO.setRemark(uocApprovalLogPO.getNextStepName());
            if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                List<MemberAbilityBO> userCode = this.getUserCode(strings);
                if (!CollectionUtils.isEmpty(userCode)) {
                    todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                }
                todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
            }
            todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
            String finalObjNo = objNo;
            todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(finalObjNo);
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoWaitAbilityReqBO;
    }

    public void addTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
            log.info("addTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycActiveTodoWaitDoneProviderService.dycActiveAddTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    public void cancelTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
            log.info("cancelTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycActiveTodoWaitDoneProviderService.dycActiveCancelTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    public void doneTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
            log.info("doneTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycActiveTodoWaitDoneProviderService.dycActiveDoneTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    private DycStationOrgSelectUserNameRspBO listUser(String nextStationId) {
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
        return this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
    }

    @Override
    public UocApprovalLogPO listApproval(Long objId) {
        UocApprovalLogPO uocApprovalLogPO = new UocApprovalLogPO();
        uocApprovalLogPO.setOrderId(objId);
        return this.uocApprovalLogMapper.listByParam(uocApprovalLogPO).stream().filter($ -> Objects.nonNull($)).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private void assertParam(TodoActiveWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        Assert.notNull((Object)todoUccWaitAbilityReqBO, (String)"PARAM_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getObjId(), (String)"OBJID_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getOperatorType(), (String)"OPERATOR_IS_NULL");
    }
}

