/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.extend.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.bo.ActAddActiveMemRangeAbilityReqBO;
import com.tydic.active.app.busi.ActAddActiveMemRangeBusiService;
import com.tydic.active.app.busi.bo.ActAddActiveMemRangeBusiReqBO;
import com.tydic.active.app.busi.bo.ActAddActiveMemRangeBusiRspBO;
import com.tydic.active.app.common.bo.ActMemRangeBO;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.extend.busi.ActImportActiveMemRangeBusiService;
import com.tydic.active.extend.busi.bo.ActImportActiveMemRangeBusiReqBO;
import com.tydic.active.extend.busi.bo.ActImportActiveMemRangeBusiRspBO;
import com.tydic.active.extend.holder.UmcInterfaceServiceHolder;
import com.tydic.active.extend.utils.ExcelUtils;
import com.tydic.active.extend.utils.HttpUtil;
import com.tydic.active.external.api.umc.bo.ActUmcMemRegistBatchAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcMemRegistBatchAbilityRspBO;
import com.tydic.umc.common.UmcMemberBO;
import com.tydic.umcext.common.UmcMemRegistBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ActImportActiveMemRangeBusiServiceImpl
implements ActImportActiveMemRangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActImportActiveMemRangeBusiServiceImpl.class);
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private UmcInterfaceServiceHolder umcInterfaceServiceHolder;
    @Autowired
    private ActAddActiveMemRangeBusiService actAddActiveMemRangeBusiService;
    private static final String REGEX_MOBILE = "(134[0-8]\\d{7})|(((13([0-3]|[5-9]))|149|15([0-3]|[5-9])|166|17(3|[5-8])|18[0-9]|19[8-9])\\d{8})";

    public ActImportActiveMemRangeBusiRspBO dealImportActiveMemRange(ActImportActiveMemRangeBusiReqBO reqBO) {
        ActImportActiveMemRangeBusiRspBO rsp = new ActImportActiveMemRangeBusiRspBO();
        ActivityPO activityPO = this.activityMapper.getModelById(reqBO.getActiveId());
        if (null == activityPO) {
            throw new BusinessException("14003", "\u6d3b\u52a8\u7528\u6237\u8303\u56f4\u6279\u91cf\u5bfc\u5165\u670d\u52a1\uff0c\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        Integer activeStatus2 = activityPO.getActiveStatus();
        if (activeStatus2 != 1 && activeStatus2 != 0) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u7528\u6237\u8303\u56f4\u6279\u91cf\u5bfc\u5165\u670d\u52a1\uff0c\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u4e0b\u7684\u6d3b\u52a8\u624d\u80fd\u6279\u91cf\u5bfc\u5165\uff01");
        }
        List<UmcMemberBO> umcMemberBOS = this.analysisFile(reqBO);
        ActUmcMemRegistBatchAbilityReqBO abilityReqBO = new ActUmcMemRegistBatchAbilityReqBO();
        abilityReqBO.setActivityOrgId(Long.valueOf(activityPO.getAdmOrgId()));
        abilityReqBO.setActivityName(activityPO.getActiveName());
        abilityReqBO.setActivityCode(activityPO.getActiveId().toString());
        abilityReqBO.setWelfareType(Integer.valueOf(activityPO.getActiveType()));
        abilityReqBO.setWalletChnnLogTitle("\u56fd\u5e86\u4e2d\u79cb\u6b22\u5ea6\u53cc\u4f73\u8282 \u79ef\u5206\u8d60\u9001");
        abilityReqBO.setWalletChnnLogDetail("\u5185\u90e8\u798f\u5229");
        abilityReqBO.setMemberBOS(umcMemberBOS);
        ActUmcMemRegistBatchAbilityRspBO actUmcMemRegistBatchAbilityRspBO = this.umcInterfaceServiceHolder.getActExternalUmcMemRegistBatchAbilityService().memRegistBatch(abilityReqBO);
        if (!"0000".equals(actUmcMemRegistBatchAbilityRspBO.getRespCode())) {
            throw new BusinessException(actUmcMemRegistBatchAbilityRspBO.getRespCode(), actUmcMemRegistBatchAbilityRspBO.getRespDesc());
        }
        List umcMemRegistBOS = actUmcMemRegistBatchAbilityRspBO.getUmcMemRegistBOS();
        if (!CollectionUtils.isEmpty((Collection)umcMemRegistBOS)) {
            HashMap<String, UmcMemRegistBO> regMobileMemIds = new HashMap<String, UmcMemRegistBO>();
            for (UmcMemRegistBO bo : umcMemRegistBOS) {
                regMobileMemIds.put(bo.getRegMobile(), bo);
            }
            ActAddActiveMemRangeAbilityReqBO addActiveMemRangeAbilityReqBO = new ActAddActiveMemRangeAbilityReqBO();
            addActiveMemRangeAbilityReqBO.setActiveId(activityPO.getActiveId());
            addActiveMemRangeAbilityReqBO.setOrgIdIn(activityPO.getAdmOrgId());
            addActiveMemRangeAbilityReqBO.setMarketingType(reqBO.getMarketingType());
            ArrayList<ActMemRangeBO> actMemRangeBOS = new ArrayList<ActMemRangeBO>();
            for (UmcMemberBO umcMemberBO : umcMemberBOS) {
                UmcMemRegistBO umcMemRegistBO = (UmcMemRegistBO)regMobileMemIds.get(umcMemberBO.getRegMobile());
                if (null == umcMemRegistBO) continue;
                ActMemRangeBO actMemRangeBO = new ActMemRangeBO();
                actMemRangeBO.setIntegral(new BigDecimal(umcMemberBO.getActivityIntegral()));
                actMemRangeBO.setMemParamType("15");
                actMemRangeBO.setParamInsCode(umcMemRegistBO.getMemId().toString());
                actMemRangeBO.setParamInsName(umcMemberBO.getMemName2());
                actMemRangeBO.setMemRangeExtField1(umcMemberBO.getRegMobile());
                actMemRangeBO.setMemRangeExtField3(umcMemberBO.getRegEmail());
                actMemRangeBO.setMemRangeExtField4(reqBO.getUserName());
                Long orgId = umcMemRegistBO.getOrgId();
                if (activityPO.getAdmOrgId().equals(orgId.toString())) {
                    actMemRangeBO.setMemRangeExtField2(umcMemRegistBO.getOrgName());
                } else {
                    actMemRangeBO.setMemRangeExtField2(reqBO.getCompanyName() + "/" + umcMemRegistBO.getOrgName());
                }
                actMemRangeBOS.add(actMemRangeBO);
            }
            if (actMemRangeBOS.size() > 0) {
                addActiveMemRangeAbilityReqBO.setActMemRangeBOList(actMemRangeBOS);
                ActAddActiveMemRangeBusiReqBO actAddActiveMemRangeBusiReqBO = new ActAddActiveMemRangeBusiReqBO();
                BeanUtils.copyProperties((Object)addActiveMemRangeAbilityReqBO, (Object)actAddActiveMemRangeBusiReqBO);
                ActAddActiveMemRangeBusiRspBO actAddActiveMemRangeBusiRspBO = this.actAddActiveMemRangeBusiService.addActiveMemRange(actAddActiveMemRangeBusiReqBO);
                if (!"0000".equals(actAddActiveMemRangeBusiRspBO.getRespCode())) {
                    throw new BusinessException(actAddActiveMemRangeBusiRspBO.getRespCode(), actAddActiveMemRangeBusiRspBO.getRespDesc());
                }
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u7528\u6237\u8303\u56f4\u6279\u91cf\u5bfc\u5165\u6210\u529f");
        return rsp;
    }

    private List<UmcMemberBO> analysisFile(ActImportActiveMemRangeBusiReqBO reqBO) {
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        if (StringUtils.isBlank((CharSequence)reqBO.getUrl())) {
            throw new BusinessException("14001", "\u5165\u53c2\u3010URL\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            ExcelUtils.getExcelDate((MultipartFile)multipartFile, data, title, 4);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("14040", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        ArrayList<UmcMemberBO> memberBOS = new ArrayList<UmcMemberBO>();
        if (data.size() == 0) {
            throw new BusinessException("14001", "\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < data.size(); ++i) {
            List line = (List)data.get(i);
            UmcMemberBO umcMemberBO = new UmcMemberBO();
            if (StringUtils.isBlank((CharSequence)((CharSequence)line.get(0)))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30101\u3011\u5217\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ActImportActiveMemRangeBusiServiceImpl.isMobile((String)line.get(0))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30101\u3011\u5217\u624b\u673a\u53f7\u3010" + (String)line.get(0) + "\u3011\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            umcMemberBO.setRegMobile((String)line.get(0));
            if (StringUtils.isBlank((CharSequence)((CharSequence)line.get(1)))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30102\u3011\u5217\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            umcMemberBO.setMemName2((String)line.get(1));
            if (StringUtils.isBlank((CharSequence)((CharSequence)line.get(2)))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30103\u3011\u5217\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ActImportActiveMemRangeBusiServiceImpl.isEmail((String)line.get(2))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30103\u3011\u5217\u90ae\u7bb1\u3010" + (String)line.get(2) + "\u3011\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            umcMemberBO.setRegEmail((String)line.get(2));
            if (StringUtils.isBlank((CharSequence)((CharSequence)line.get(3)))) {
                throw new BusinessException("14001", "\u7b2c\u3010" + (i + 2) + "\u3011\u884c\u7b2c\u30104\u3011\u5217\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            umcMemberBO.setActivityIntegral((String)line.get(3));
            memberBOS.add(umcMemberBO);
        }
        return memberBOS;
    }

    public static boolean isMobile(String tel) {
        return Pattern.matches(REGEX_MOBILE, tel);
    }

    public static boolean isEmail(String email) {
        try {
            String pattern1 = "[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+@[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+\\.[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+";
            Pattern pattern = Pattern.compile("[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+@[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+\\.[\\w.\\\\+\\-\\*\\/\\=\\`\\~\\!\\#\\$\\%\\^\\&\\*\\{\\}\\|\\'\\_\\?]+");
            Matcher mat = pattern.matcher(email);
            return mat.matches();
        }
        catch (Exception e) {
            log.error("Exception error:{}", (Throwable)e);
            return false;
        }
    }
}

