/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.ActActivityCountAbilityService;
import com.tydic.active.app.ability.bo.ActActivityCountAbilityReqBO;
import com.tydic.active.app.ability.bo.ActActivityCountAbilityRspBO;
import com.tydic.active.app.busi.ActActivityCountBusiService;
import com.tydic.active.app.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.active.app.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.active.app.common.bo.ActivityChoiceBO;
import com.tydic.active.app.common.bo.SkuDetailReqBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActActivityCountAbilityService"})
public class ActActivityCountAbilityServiceImpl
implements ActActivityCountAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActivityCountAbilityServiceImpl.class);
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    @Autowired
    ActActivityCountBusiService actActivityCountBusiService;

    @PostMapping(value={"countActivity"})
    public ActActivityCountAbilityRspBO countActivity(@RequestBody ActActivityCountAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActActivityCountAbilityRspBO rspBO = new ActActivityCountAbilityRspBO();
        ActActivityCountBusiReqBO busiReqBO = this.generateReqBO(reqBO);
        ActActivityCountBusiRspBO busiRspBO = this.actActivityCountBusiService.countActivity(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + busiRspBO.getRespDesc());
            rspBO.setRespCode(busiRspBO.getRespCode());
            rspBO.setRespDesc(busiRspBO.getRespDesc());
            return rspBO;
        }
        BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
        return rspBO;
    }

    private ActActivityCountBusiReqBO generateReqBO(ActActivityCountAbilityReqBO reqBO) {
        ActActivityCountBusiReqBO busiReqBO = new ActActivityCountBusiReqBO();
        busiReqBO.setSkuDetailList(reqBO.getSkuDetailList());
        busiReqBO.setOrderActivityList(reqBO.getOrderActivityList());
        busiReqBO.setFreightAmount(reqBO.getFreightAmount());
        busiReqBO.setMemId(reqBO.getMemId());
        return busiReqBO;
    }

    private void validateArg(ActActivityCountAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuDetailList())) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SkuDetailReqBO skuDetailReqAbilityBO : reqBO.getSkuDetailList()) {
            if (StringUtils.isBlank((CharSequence)skuDetailReqAbilityBO.getSkuId())) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getShopId()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getSkuNum()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1\u6570\u91cf[skuNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getSkuPrice()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5546\u54c1\u5355\u4ef7[skuPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getSeckillFlag()) {
                skuDetailReqAbilityBO.setSeckillFlag("0");
            }
            if (CollectionUtils.isEmpty((Collection)skuDetailReqAbilityBO.getSkuActivityList())) continue;
            for (ActivityChoiceBO activityChoiceAbilityBO : skuDetailReqAbilityBO.getSkuActivityList()) {
                if (null != activityChoiceAbilityBO.getActiveId()) continue;
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1\u5df2\u9009\u6d3b\u52a8\u5217\u8868[skuActivityList]\u4e2d\u7684\u6d3b\u52a8ID[activeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList())) {
            for (ActivityChoiceBO activityChoiceAbilityBO : reqBO.getOrderActivityList()) {
                if (null == activityChoiceAbilityBO.getActiveId()) {
                    throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5df2\u9009\u6d3b\u52a8\u5217\u8868[orderActivityList]\u4e2d\u7684\u6d3b\u52a8ID[activeId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != activityChoiceAbilityBO.getShopId()) continue;
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5df2\u9009\u6d3b\u52a8\u5217\u8868[orderActivityList]\u4e2d\u7684\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

