/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.ActCreateCouponFormAbilityService;
import com.tydic.active.app.ability.bo.ActCreateCouponFormAbilityReqBO;
import com.tydic.active.app.ability.bo.ActCreateCouponFormAbilityRspBO;
import com.tydic.active.app.busi.ActCreateCouponFormBusiService;
import com.tydic.active.app.busi.bo.ActCreateCouponFormBusiReqBO;
import com.tydic.active.app.busi.bo.ActCreateCouponFormBusiRspBO;
import com.tydic.active.app.common.bo.CouponRangeAndAmoumtInfoBO;
import com.tydic.active.app.common.bo.CreateCouponFormInfoBO;
import com.tydic.active.app.constant.ActCommConstant;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActCreateCouponFormAbilityService"})
public class ActCreateCouponFormAbilityServiceImpl
implements ActCreateCouponFormAbilityService {
    private static final String PARAM_MSG = "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActCreateCouponFormBusiService actCreateCouponFormBusiService;

    @Autowired
    public ActCreateCouponFormAbilityServiceImpl(ActCreateCouponFormBusiService actCreateCouponFormBusiService) {
        this.actCreateCouponFormBusiService = actCreateCouponFormBusiService;
    }

    @PostMapping(value={"createCouponForm"})
    public ActCreateCouponFormAbilityRspBO createCouponForm(@RequestBody ActCreateCouponFormAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActCreateCouponFormAbilityRspBO rspBO = new ActCreateCouponFormAbilityRspBO();
        ActCreateCouponFormBusiReqBO busiReqBO = new ActCreateCouponFormBusiReqBO();
        busiReqBO.setCouponFormInfoList(reqBO.getCouponFormInfoList());
        ActCreateCouponFormBusiRspBO busiRspBO = this.actCreateCouponFormBusiService.createCouponForm(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validateArg(ActCreateCouponFormAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponFormInfoList())) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CreateCouponFormInfoBO couponFormInfoBO : reqBO.getCouponFormInfoList()) {
            if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getFmName())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u89c4\u683c\u540d\u79f0[fmName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponFormInfoBO.getValidityLen()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u5238\u9ed8\u8ba4\u6709\u6548\u671f[validityLen]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponFormInfoBO.getCouponType()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u5238\u7c7b\u578b[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.FULL_DISCOUNT.equals(couponFormInfoBO.getCouponType())) && StringUtils.isBlank((CharSequence)couponFormInfoBO.getTotalFeeReach())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u8fbe\u6807\u91d1\u989d[totalFeeReach]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.FREIGHT_SPECIFIED_AMOUNT.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.DEDUCTION.equals(couponFormInfoBO.getCouponType())) {
                if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getFeeDiscount())) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u91d1\u989d[feeDiscount]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (ActCommConstant.CouponTypeCode.FULL_DISCOUNT.equals(couponFormInfoBO.getCouponType()) && StringUtils.isBlank((CharSequence)couponFormInfoBO.getDiscountRate())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6298\u6263\u7387[discountRate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType())) {
                BigDecimal totalFeeReach = new BigDecimal(couponFormInfoBO.getTotalFeeReach());
                BigDecimal feeDiscount = new BigDecimal(couponFormInfoBO.getFeeDiscount());
                if (feeDiscount.compareTo(totalFeeReach) > 0) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u6ee1\u8db3\u6761\u4ef6\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4f18\u60e0\u91d1\u989d");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)couponFormInfoBO.getCouponRangeAndAmoumtInfoBOList())) {
                for (CouponRangeAndAmoumtInfoBO couponRangeAndAmoumtInfoBO : couponFormInfoBO.getCouponRangeAndAmoumtInfoBOList()) {
                    if (!StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory4Id()) && StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory3Id())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u4e09\u7ea7\u7c7b\u76ee[category3Id]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory3Id()) && StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory2Id())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u4e8c\u7ea7\u7c7b\u76ee[category2Id]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory2Id()) && StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCategory1Id())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u4e00\u7ea7\u7c7b\u76ee[category1Id]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getOperCode())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u4e1a\u52a1\u7f16\u7801[operCode]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null == couponRangeAndAmoumtInfoBO.getTotalCount()) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u603b\u6570\u91cf[totalCount]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getAreaNo()) && StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCityNo())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u5730\u5e02[cityNo]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getCityNo()) || !StringUtils.isBlank((CharSequence)couponRangeAndAmoumtInfoBO.getProvinceNo())) continue;
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f[CouponRangeAndAmountInfoBO]\u4e2d\u7684\u7701\u4efd[provinceNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                continue;
            }
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u6570\u91cf\u8303\u56f4\u63a7\u5236\u4fe1\u606f\u5217\u8868[CouponRangeAndAmountInfoBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

