/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.active.app.ability.ActWelfarePointGrantApproveAbilityService;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityRspBO;
import com.tydic.active.app.atom.bo.WelfareSendNotificationAtomReqBO;
import com.tydic.active.app.busi.ActWelfarePointGrantApproveBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActWelfarePointGrantApproveAbilityService"})
public class ActWelfarePointGrantApproveAbilityServiceImpl
implements ActWelfarePointGrantApproveAbilityService {
    @Autowired
    private ActWelfarePointGrantApproveBusiService actWelfarePointGrantApproveBusiService;
    @Value(value="${es.WELFARE_NOTIFICATION_TOPIC:WELFARE_NOTIFICATION_TOPIC}")
    private String welfareNotificationTopic;
    @Value(value="${es.WELFARE_NOTIFICATION_TAG:WELFARE_NOTIFICATION_TAG}")
    private String welfareNotificationTag;
    @Resource(name="welfareNotificationMqServiceProvider")
    private ProxyMessageProducer welfareNotificationMqServiceProvider;

    @PostMapping(value={"dealApprove"})
    public ActWelfarePointGrantApproveAbilityRspBO dealApprove(@RequestBody ActWelfarePointGrantApproveAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getWelfarePointGrantIds())) {
            throw new BusinessException("14001", "\u53d1\u653eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActWelfarePointGrantApproveAbilityRspBO rspBO = this.actWelfarePointGrantApproveBusiService.dealAuditOrder(reqBO);
        if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getAuditFinishMap())) {
            for (Long grantId : rspBO.getAuditFinishMap().keySet()) {
                Boolean finish = (Boolean)rspBO.getAuditFinishMap().get(grantId);
                WelfareSendNotificationAtomReqBO sendNotificationAtomReqBO = new WelfareSendNotificationAtomReqBO();
                sendNotificationAtomReqBO.setFinish(finish);
                sendNotificationAtomReqBO.setAuditResult(reqBO.getAuditResult());
                sendNotificationAtomReqBO.setUserId(reqBO.getUserId());
                sendNotificationAtomReqBO.setObjId(grantId);
                sendNotificationAtomReqBO.setNotificationType(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_GRANT_AUDIT);
                this.welfareNotificationMqServiceProvider.send(new ProxyMessage(this.welfareNotificationTopic, this.welfareNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationAtomReqBO))));
            }
        }
        return rspBO;
    }
}

