/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActWelfarePointGrantMemListAbilityService;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantMemListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantMemListAbilityRspBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantMemListRspBO;
import com.tydic.active.app.dao.WelfarePointsGrantMemMapper;
import com.tydic.active.app.utils.DateUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActWelfarePointGrantMemListAbilityService"})
public class ActWelfarePointGrantMemListAbilityServiceImpl
implements ActWelfarePointGrantMemListAbilityService {
    @Autowired
    private WelfarePointsGrantMemMapper welfarePointsGrantMemMapper;

    @PostMapping(value={"qryGrantMemList"})
    public ActWelfarePointGrantMemListAbilityRspBO qryGrantMemList(@RequestBody ActWelfarePointGrantMemListAbilityReqBO reqBO) {
        this.validate(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ActWelfarePointGrantMemListRspBO> rows = this.welfarePointsGrantMemMapper.qryGrantMemListByMemIdByPage(reqBO, (Page<ActWelfarePointGrantMemListRspBO>)page);
        if (!CollectionUtils.isEmpty(rows)) {
            Long index = 1L;
            for (ActWelfarePointGrantMemListRspBO row : rows) {
                if ("4".equals(row.getStatus())) {
                    BigDecimal usedPoints = row.getUsedPoints() == null ? BigDecimal.ZERO : row.getUsedPoints();
                    BigDecimal wfPoints = row.getWelfarePoints() == null ? BigDecimal.ZERO : row.getWelfarePoints();
                    row.setDisabledPoints(wfPoints.subtract(usedPoints));
                } else {
                    row.setDisabledPoints(BigDecimal.ZERO);
                }
                row.setWelfarePointTypeStr(this.Translate("welfarePointType", row.getWelfarePointType()));
                row.setWelfareTypeStr(this.Translate("welfareType", row.getWelfareType()));
                row.setIndex(index);
                String dateStr = DateUtils.dateToStrAsFormat(row.getEffectiveStart(), "yyyy-MM-dd HH:mm:ss") + "-" + DateUtils.dateToStrAsFormat(row.getEffectiveEnd(), "yyyy-MM-dd HH:mm:ss");
                row.setDateExport(dateStr);
                row.setIssuerNameExport("(" + row.getIssuerCode() + ")" + row.getIssuerName());
                Long l = index;
                Long l2 = index = Long.valueOf(index + 1L);
            }
        }
        ActWelfarePointGrantMemListAbilityRspBO rspBO = new ActWelfarePointGrantMemListAbilityRspBO();
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6267\u884c\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }

    String Translate(String flag, Byte type) {
        if (type == null) {
            return "";
        }
        if ("welfarePointType".equals(flag)) {
            if (type == 1) {
                return "\u901a\u7528";
            }
            return "\u6d3b\u52a8\u4e13\u5c5e";
        }
        if ("welfareType".equals(flag)) {
            if (type == 1) {
                return "\u516c\u53f8";
            }
            return "\u5de5\u4f1a";
        }
        return "";
    }

    private void validate(ActWelfarePointGrantMemListAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("14001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getMemIds())) {
            throw new BusinessException("14001", "\u5165\u53c2memIds\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

