/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.active.app.ability.WelfareActiveApproveAbilityService;
import com.tydic.active.app.ability.bo.WelfareActiveApproveReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveApproveRspBO;
import com.tydic.active.app.atom.bo.WelfareSendNotificationAtomReqBO;
import com.tydic.active.app.busi.WelfareActiveApproveBusiService;
import com.tydic.active.app.constant.ActCommConstant;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.WelfareActiveApproveAbilityService"})
public class WelfareActiveApproveAbilityServiceImpl
implements WelfareActiveApproveAbilityService {
    @Autowired
    private WelfareActiveApproveBusiService welfareActiveApproveBusiService;
    @Value(value="${es.WELFARE_NOTIFICATION_TOPIC:WELFARE_NOTIFICATION_TOPIC}")
    private String welfareNotificationTopic;
    @Value(value="${es.WELFARE_NOTIFICATION_TAG:WELFARE_NOTIFICATION_TAG}")
    private String welfareNotificationTag;
    @Resource(name="welfareNotificationMqServiceProvider")
    private ProxyMessageProducer welfareNotificationMqServiceProvider;

    @PostMapping(value={"activeApprove"})
    public WelfareActiveApproveRspBO activeApprove(@RequestBody WelfareActiveApproveReqBO reqBO) {
        if (reqBO.getAuditResult() == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u53c2\u6570 auditResult \u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveIds())) {
            throw new BusinessException("8888", "\u5ba1\u6279\u53c2\u6570 activeIds \u4e3a\u7a7a\uff01");
        }
        WelfareActiveApproveRspBO rspBO = this.welfareActiveApproveBusiService.activeApprove(reqBO);
        if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getAuditFinishMap())) {
            for (Long activeId : rspBO.getAuditFinishMap().keySet()) {
                Boolean finish = (Boolean)rspBO.getAuditFinishMap().get(activeId);
                WelfareSendNotificationAtomReqBO sendNotificationAtomReqBO = new WelfareSendNotificationAtomReqBO();
                sendNotificationAtomReqBO.setFinish(finish);
                sendNotificationAtomReqBO.setAuditResult(reqBO.getAuditResult());
                sendNotificationAtomReqBO.setUserId(reqBO.getUserId());
                sendNotificationAtomReqBO.setObjId(activeId);
                sendNotificationAtomReqBO.setNotificationType(ActCommConstant.ACT_NOTIFICATION_TYPE.WELFARE_ACTIVE_AUDIT);
                this.welfareNotificationMqServiceProvider.send(new ProxyMessage(this.welfareNotificationTopic, this.welfareNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationAtomReqBO))));
            }
        }
        return rspBO;
    }
}

