/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.atom.ActAddKillDayAndTimeAtomService;
import com.tydic.active.app.atom.bo.ActAddKillDayAndTimeAtomReqBO;
import com.tydic.active.app.atom.bo.ActAddKillDayAndTimeAtomRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillDayMapper;
import com.tydic.active.app.dao.ActKillTimeMapper;
import com.tydic.active.app.dao.po.ActKillActiveExtPO;
import com.tydic.active.app.dao.po.ActKillDayPO;
import com.tydic.active.app.dao.po.ActKillTimePO;
import com.tydic.active.app.utils.ActDateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActAddKillDayAndTimeAtomServiceImpl
implements ActAddKillDayAndTimeAtomService {
    @Autowired
    private ActKillDayMapper actKillDayMapper;
    @Autowired
    private ActKillTimeMapper actKillTimeMapper;

    @Override
    public ActAddKillDayAndTimeAtomRspBO crateKillDayAndTime(ActAddKillDayAndTimeAtomReqBO atomReqBO) {
        ActAddKillDayAndTimeAtomRspBO atomRspBO = new ActAddKillDayAndTimeAtomRspBO();
        List<String> dayList = this.getActKillDayList(atomReqBO.getActKillActiveExtPO());
        if (!CollectionUtils.isEmpty(dayList)) {
            this.insertKillDay(atomReqBO.getActKillSkuBOS(), dayList, atomReqBO.getActKillActiveExtPO());
            this.insertKillTime(atomReqBO.getActKillSkuBOS(), dayList, atomReqBO.getActKillActiveExtPO());
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return atomRspBO;
    }

    private void insertKillTime(List<ActKillSkuBO> actKillSkuBOS, List<String> dayList, ActKillActiveExtPO actKillActiveExtPO) {
        int count;
        ArrayList<ActKillTimePO> actKillTimePOList = new ArrayList<ActKillTimePO>();
        for (ActKillSkuBO bo : actKillSkuBOS) {
            if (bo.getKillSkuField1() == null) continue;
            String[] killSkuField1 = bo.getKillSkuField1().split(",");
            for (int i = 0; i < killSkuField1.length; ++i) {
                String killTime = killSkuField1[i];
                String[] startEndTime = killTime.split("-");
                String startTime = startEndTime[0];
                String endTime = startEndTime[1];
                for (String day : dayList) {
                    ActKillTimePO actKillTimePO = new ActKillTimePO();
                    actKillTimePO.setActiveId(actKillActiveExtPO.getActiveId());
                    actKillTimePO.setAdmOrgId(bo.getAdmOrgId());
                    actKillTimePO.setCommodityId(bo.getCommodityId());
                    actKillTimePO.setSkuId(bo.getSkuId());
                    actKillTimePO.setStartTime(DateUtils.strToDateLong((String)(day + " " + startTime)));
                    actKillTimePO.setEndTime(DateUtils.strToDateLong((String)(day + " " + endTime)));
                    actKillTimePO.setActualNum(bo.getTimeStockNum() == null ? -1 : bo.getTimeStockNum());
                    actKillTimePO.setCreateLoginId(actKillActiveExtPO.getCreateLoginId());
                    actKillTimePO.setCreateTime(actKillActiveExtPO.getCreateTime());
                    actKillTimePO.setKillTimeId(Sequence.getInstance().nextId());
                    actKillTimePO.setMemLimitNum(bo.getTimeMemLimitNum() == null ? -1 : bo.getTimeMemLimitNum());
                    actKillTimePOList.add(actKillTimePO);
                }
            }
        }
        if (!CollectionUtils.isEmpty(actKillTimePOList) && (count = this.actKillTimeMapper.insertBatch(actKillTimePOList)) != actKillTimePOList.size()) {
            throw new BusinessException("14010", "\u65b0\u589e\u79d2\u6740\u65f6\u6bb5\u8868\u5931\u8d25");
        }
    }

    private void insertKillDay(List<ActKillSkuBO> actKillSkuBOS, List<String> dayList, ActKillActiveExtPO actKillActiveExtPO) {
        int count;
        ArrayList<ActKillDayPO> actKillDayPOList = new ArrayList<ActKillDayPO>();
        for (ActKillSkuBO bo : actKillSkuBOS) {
            for (String day : dayList) {
                ActKillDayPO actKillDayPO = new ActKillDayPO();
                actKillDayPO.setActiveId(actKillActiveExtPO.getActiveId());
                actKillDayPO.setSkuId(bo.getSkuId());
                actKillDayPO.setCommodityId(bo.getCommodityId());
                actKillDayPO.setStartDay(day);
                actKillDayPO.setEndDay(day);
                actKillDayPO.setAdmOrgId(bo.getAdmOrgId());
                actKillDayPO.setKillDayId(Sequence.getInstance().nextId());
                actKillDayPO.setActualNum(bo.getDayStockNum() == null ? -1 : bo.getDayStockNum());
                actKillDayPO.setOprateLoginId(actKillActiveExtPO.getCreateLoginId());
                actKillDayPO.setOprateTime(actKillActiveExtPO.getCreateTime());
                actKillDayPO.setMemLimitNum(bo.getDayMemLimitNum() == null ? -1 : bo.getDayMemLimitNum());
                actKillDayPOList.add(actKillDayPO);
            }
        }
        if (!CollectionUtils.isEmpty(actKillDayPOList) && (count = this.actKillDayMapper.insertBatch(actKillDayPOList)) != actKillDayPOList.size()) {
            throw new BusinessException("14010", "\u65b0\u589e\u79d2\u6740\u65e5\u671f\u8868\u5931\u8d25");
        }
    }

    private List<String> getActKillDayList(ActKillActiveExtPO actKillActiveExtPO) {
        ArrayList<String> dayList = new ArrayList<String>();
        Date activeStartTime = DateUtils.strToDate((String)DateUtils.dateToStr((Date)actKillActiveExtPO.getStartTime()));
        Date activeEndTime = DateUtils.strToDate((String)DateUtils.dateToStr((Date)actKillActiveExtPO.getEndTime()));
        dayList.add(DateUtils.dateToStr((Date)activeStartTime));
        if (ActCommConstant.KillDayConfigType.DAY_SPELID.equals(actKillActiveExtPO.getKillDayConfType())) {
            Date tempDate;
            if (actKillActiveExtPO.getKillIntervalDay() == null) {
                throw new BusinessException("14002", "\u95f4\u9694\u5929\u6570\u914d\u7f6e\u4e3a\u7a7a");
            }
            while ((tempDate = ActDateUtils.dateAdd(activeStartTime, actKillActiveExtPO.getKillIntervalDay(), 5)).compareTo(activeEndTime) <= 0) {
                dayList.add(DateUtils.dateToStr((Date)tempDate));
                activeStartTime = tempDate;
            }
            return dayList;
        }
        if (ActCommConstant.KillDayConfigType.ARRAY_SPELID.equals(actKillActiveExtPO.getKillDayConfType())) {
            if (null == actKillActiveExtPO.getKillIntervalArray()) {
                throw new BusinessException("14002", "\u95f4\u9694\u5929\u6570\u6570\u7ec4\u914d\u7f6e\u4e3a\u7a7a");
            }
            String[] killIntervalArray = actKillActiveExtPO.getKillIntervalArray().split(",");
            for (int i = 0; i < killIntervalArray.length; ++i) {
                Integer intervalDay = Integer.parseInt(killIntervalArray[i]);
                Date tempDate1 = ActDateUtils.dateAdd(activeStartTime, intervalDay, 5);
                if (tempDate1.compareTo(activeEndTime) > 0) continue;
                dayList.add(DateUtils.dateToStr((Date)tempDate1));
            }
            return dayList;
        }
        return dayList;
    }
}

