/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActCouponDiscountAtomService;
import com.tydic.active.app.atom.ActCouponRangeCheckAtomService;
import com.tydic.active.app.atom.ActCouponValidCheckAtomService;
import com.tydic.active.app.atom.ActOrderDiscountAtomService;
import com.tydic.active.app.atom.ActOrderJudgeAtomService;
import com.tydic.active.app.atom.bo.ActCouponDiscountAtomReqBO;
import com.tydic.active.app.atom.bo.ActCouponDiscountAtomRspBO;
import com.tydic.active.app.atom.bo.ActCouponRangeCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActCouponRangeCheckAtomRspBO;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.active.app.atom.bo.ActOrderDiscountAtomReqBO;
import com.tydic.active.app.atom.bo.ActOrderDiscountAtomRspBO;
import com.tydic.active.app.atom.bo.ActOrderJudgeAtomReqBO;
import com.tydic.active.app.atom.bo.ActOrderJudgeAtomRspBO;
import com.tydic.active.app.common.bo.CouponCountDetailRspBO;
import com.tydic.active.app.common.bo.SkuDetailBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.CouponModMapper;
import com.tydic.active.app.dao.po.CouponModPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponDiscountAtomService")
public class ActCouponDiscountAtomServiceImpl
implements ActCouponDiscountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponDiscountAtomServiceImpl.class);
    private CouponModMapper couponModMapper;
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private ActCouponRangeCheckAtomService actCouponRangeCheckAtomService;
    private ActOrderJudgeAtomService actOrderJudgeAtomService;
    private ActOrderDiscountAtomService actOrderDiscountAtomService;

    @Autowired
    public ActCouponDiscountAtomServiceImpl(CouponModMapper couponModMapper, ActCouponValidCheckAtomService actCouponValidCheckAtomService, ActCouponRangeCheckAtomService actCouponRangeCheckAtomService, ActOrderJudgeAtomService actOrderJudgeAtomService, ActOrderDiscountAtomService actOrderDiscountAtomService) {
        this.couponModMapper = couponModMapper;
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.actCouponRangeCheckAtomService = actCouponRangeCheckAtomService;
        this.actOrderJudgeAtomService = actOrderJudgeAtomService;
        this.actOrderDiscountAtomService = actOrderDiscountAtomService;
    }

    @Override
    public ActCouponDiscountAtomRspBO couponDiscount(ActCouponDiscountAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCouponCodes())) {
            return this.returnOriginalPrice(reqBO);
        }
        return this.couponCheckAndCalculate(reqBO);
    }

    private BigDecimal calculateTotalAmount(List<SkuDetailBO> skuDetailList) {
        return skuDetailList.stream().map(skuDetail -> skuDetail.getSkuPrice().multiply(skuDetail.getSkuNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private ActCouponDiscountAtomRspBO returnOriginalPrice(ActCouponDiscountAtomReqBO reqBO) {
        ActCouponDiscountAtomRspBO rspBO = new ActCouponDiscountAtomRspBO();
        BigDecimal totalAmount = this.calculateTotalAmount(reqBO.getSkuDetailList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u672a\u4f20\u5165\u4f18\u60e0\u5238\uff0c\u65e0\u62b5\u6263\u91d1\u989d");
        rspBO.setDisTotalAmo(BigDecimal.ZERO);
        rspBO.setTotalAmount(totalAmount);
        rspBO.setDisFreightAmo(BigDecimal.ZERO);
        rspBO.setFreightAmount(reqBO.getFreightAmount());
        rspBO.setSkuDetailList(this.returnOriginalDetailList(reqBO.getSkuDetailList()));
        return rspBO;
    }

    private ActCouponDiscountAtomRspBO couponCheckAndCalculate(ActCouponDiscountAtomReqBO reqBO) {
        if (reqBO.getFreightAmount() == null) {
            reqBO.setFreightAmount(BigDecimal.ZERO);
        }
        ActCouponDiscountAtomRspBO rspBO = new ActCouponDiscountAtomRspBO();
        rspBO.setFreightAmount(reqBO.getFreightAmount());
        rspBO.setDisTotalAmo(BigDecimal.ZERO);
        rspBO.setDisFreightAmo(BigDecimal.ZERO);
        List<CouponCountDetailRspBO> skuDetailList = this.returnOriginalDetailList(reqBO.getSkuDetailList());
        rspBO.setSkuDetailList(skuDetailList);
        BigDecimal totalAmount = this.calculateTotalAmount(reqBO.getSkuDetailList());
        boolean isAvailable = false;
        for (String couponNo : reqBO.getCouponCodes()) {
            ActCouponValidCheckAtomReqBO validCheckReqBO = new ActCouponValidCheckAtomReqBO();
            validCheckReqBO.setCouponNo(couponNo);
            ActCouponValidCheckAtomRspBO validCheckRspBO = this.actCouponValidCheckAtomService.checkCouponValid(validCheckReqBO);
            if (ActCommConstant.CouponValidMark.INEFFECTIVE.equals(validCheckRspBO.getCouponValidMark())) {
                LOGGER.error(validCheckRspBO.getRespDesc() + "[couponNo=" + couponNo + "]");
                continue;
            }
            Long fmID = validCheckRspBO.getFmId();
            ActCouponRangeCheckAtomReqBO rangeCheckAtomReqBO = new ActCouponRangeCheckAtomReqBO();
            rangeCheckAtomReqBO.setFmId(fmID);
            rangeCheckAtomReqBO.setSkuCheckList(reqBO.getSkuDetailList());
            ActCouponRangeCheckAtomRspBO rangeCheckRspBO = this.actCouponRangeCheckAtomService.checkCouponRange(rangeCheckAtomReqBO);
            if (CollectionUtils.isEmpty(rangeCheckRspBO.getAvailableSkuList())) {
                LOGGER.error("\u4f20\u5165\u660e\u7ec6\u4e0d\u80fd\u4f7f\u7528\u8be5\u89c4\u683c\u4f18\u60e0\u5238[fmID=" + fmID + "]");
                continue;
            }
            List<CouponModPO> templates = this.checkTemplateValid(fmID);
            rspBO.setTotalAmount(this.calculateTotalAmount(rangeCheckRspBO.getAvailableSkuList()));
            BigDecimal disTotalAmo = this.calculateCouponDis(rspBO, templates);
            this.shareDisToDetail(rspBO, totalAmount, disTotalAmo, rangeCheckRspBO.getAvailableSkuList());
            isAvailable = true;
        }
        totalAmount = totalAmount.subtract(rspBO.getDisTotalAmo()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalAmount.subtract(rspBO.getDisTotalAmo());
        rspBO.setTotalAmount(totalAmount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(isAvailable ? "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u6210\u529f" : "\u4f20\u5165\u660e\u7ec6\u4e0d\u80fd\u4f7f\u7528\u4f18\u60e0\u5238");
        return rspBO;
    }

    private List<CouponModPO> checkTemplateValid(Long fmID) {
        CouponModPO modParam = new CouponModPO();
        modParam.setFmId(fmID);
        modParam.setOrderBy("templateType");
        List<CouponModPO> templates = this.couponModMapper.getList(modParam);
        if (CollectionUtils.isEmpty(templates)) {
            throw new BusinessException("5001", "\u672a\u914d\u7f6e\u4f18\u60e0\u5238\u6a21\u677f[fmID=" + fmID + "]");
        }
        int templateNum = 2;
        if (templates.size() > templateNum) {
            throw new BusinessException("5001", "\u4f18\u60e0\u5238\u6a21\u677f\u6570\u91cf\u5927\u4e8e2[fmID=" + fmID + "]");
        }
        if (templates.size() == templateNum && templates.get(0).getTemplateType().equals(templates.get(1).getTemplateType())) {
            throw new BusinessException("5001", "\u4f18\u60e0\u5238\u4e24\u4e2a\u6a21\u7248\u7c7b\u578b\u76f8\u540c[fmID=" + fmID + "]");
        }
        return templates;
    }

    private BigDecimal calculateCouponDis(ActCouponDiscountAtomRspBO rspBO, List<CouponModPO> templates) {
        BigDecimal disTotalAmo = BigDecimal.ZERO;
        BigDecimal disFreightAmo = rspBO.getDisFreightAmo();
        Integer mulCount = 0;
        for (CouponModPO template : templates) {
            if ("0".equals(template.getTemplateType().toString())) {
                ActOrderJudgeAtomReqBO orderJudgeAtomReqBO = new ActOrderJudgeAtomReqBO();
                orderJudgeAtomReqBO.setActiveId(template.getFmId());
                orderJudgeAtomReqBO.setAttrType("coupon");
                orderJudgeAtomReqBO.setTemplateId(template.getTemplateId());
                orderJudgeAtomReqBO.setTotalAmount(rspBO.getTotalAmount());
                ActOrderJudgeAtomRspBO orderJudgeAtomRspBO = this.actOrderJudgeAtomService.judgeOrder(orderJudgeAtomReqBO);
                if (!"0000".equals(orderJudgeAtomRspBO.getRespCode()) && !"1011".equals(orderJudgeAtomRspBO.getRespCode())) {
                    throw new BusinessException(orderJudgeAtomRspBO.getRespCode(), "\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + orderJudgeAtomRspBO.getRespDesc());
                }
                mulCount = orderJudgeAtomRspBO.getMulCount();
            }
            if (!"1".equals(template.getTemplateType().toString())) continue;
            ActOrderDiscountAtomReqBO discountAtomReqBO = new ActOrderDiscountAtomReqBO();
            discountAtomReqBO.setTotalAmount(rspBO.getTotalAmount());
            discountAtomReqBO.setFreightAmount(rspBO.getFreightAmount());
            discountAtomReqBO.setActiveId(template.getFmId());
            discountAtomReqBO.setAttrType("coupon");
            discountAtomReqBO.setTemplateId(template.getTemplateId());
            discountAtomReqBO.setMulCount(mulCount);
            ActOrderDiscountAtomRspBO discountAtomRspBO = this.actOrderDiscountAtomService.orderDiscount(discountAtomReqBO);
            if (!"0000".equals(discountAtomRspBO.getRespCode())) {
                throw new BusinessException(discountAtomRspBO.getRespCode(), "\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u4f18\u60e0\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25!" + discountAtomRspBO.getRespDesc());
            }
            disTotalAmo = disTotalAmo.add(discountAtomRspBO.getDisTotalAmo());
            disFreightAmo = disFreightAmo.add(discountAtomRspBO.getDisFreightAmo());
            rspBO.setTotalAmount(discountAtomRspBO.getTotalAmount());
            rspBO.setFreightAmount(discountAtomRspBO.getFreightAmount());
            rspBO.setDisTotalAmo(rspBO.getDisTotalAmo().add(disTotalAmo));
            rspBO.setDisFreightAmo(disFreightAmo);
        }
        return disTotalAmo;
    }

    private void shareDisToDetail(ActCouponDiscountAtomRspBO rspBO, BigDecimal totalAmount, BigDecimal disTotalAmo, List<SkuDetailBO> availableSkuList) {
        if (disTotalAmo.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal shareDiscount = BigDecimal.ZERO;
            int skuLength = availableSkuList.size();
            block0: for (int index = 0; index < skuLength; ++index) {
                BigDecimal shareOrderDiscount;
                SkuDetailBO skuDetailBO = availableSkuList.get(index);
                CouponCountDetailRspBO countDetailRspBO = new CouponCountDetailRspBO();
                BeanUtils.copyProperties((Object)skuDetailBO, (Object)countDetailRspBO);
                BigDecimal skuNum = countDetailRspBO.getSkuNum();
                BigDecimal skuRate = countDetailRspBO.getSkuPrice().multiply(skuNum).divide(totalAmount, 2, 5);
                if (index == skuLength - 1) {
                    shareOrderDiscount = disTotalAmo.subtract(shareDiscount);
                } else {
                    shareOrderDiscount = disTotalAmo.multiply(skuRate).setScale(0, 5);
                    shareDiscount = shareDiscount.add(shareOrderDiscount);
                }
                countDetailRspBO.setSkuTotalAmount(shareOrderDiscount.setScale(2, 5));
                BigDecimal skuDisPrice = countDetailRspBO.getSkuPrice().multiply(skuNum).subtract(shareOrderDiscount);
                if (skuDisPrice.compareTo(BigDecimal.ZERO) < 0) {
                    countDetailRspBO.setSkuTotalPrice(BigDecimal.ZERO);
                } else {
                    countDetailRspBO.setSkuTotalPrice(skuDisPrice.setScale(2, 5));
                }
                int size = rspBO.getSkuDetailList().size();
                for (int i = 0; i < size; ++i) {
                    CouponCountDetailRspBO detailRsp = rspBO.getSkuDetailList().get(i);
                    if (!detailRsp.getSkuId().equals(countDetailRspBO.getSkuId()) || !detailRsp.getShopId().equals(countDetailRspBO.getShopId()) || !StringUtils.isBlank((CharSequence)detailRsp.getExtFlag())) continue;
                    countDetailRspBO.setExtFlag("\u5df2\u5206\u644a\u4f18\u60e0");
                    rspBO.getSkuDetailList().set(i, countDetailRspBO);
                    continue block0;
                }
            }
        }
    }

    private List<CouponCountDetailRspBO> returnOriginalDetailList(List<SkuDetailBO> skuList) {
        ArrayList<CouponCountDetailRspBO> skuDetailList = new ArrayList<CouponCountDetailRspBO>();
        for (SkuDetailBO skuDetailBO : skuList) {
            CouponCountDetailRspBO countDetailRspBO = new CouponCountDetailRspBO();
            BeanUtils.copyProperties((Object)skuDetailBO, (Object)countDetailRspBO);
            countDetailRspBO.setSkuTotalPrice(countDetailRspBO.getSkuPrice().multiply(countDetailRspBO.getSkuNum()).setScale(2, 5));
            countDetailRspBO.setSkuTotalAmount(BigDecimal.ZERO);
            skuDetailList.add(countDetailRspBO);
        }
        return skuDetailList;
    }
}

