/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.atom.ActCheckActivityAddInfoAtomService;
import com.tydic.active.app.atom.ActCreateActivityNewAtomService;
import com.tydic.active.app.atom.ActCreateCodeAtomService;
import com.tydic.active.app.atom.ActUpdateActiveCouponCommAtomService;
import com.tydic.active.app.atom.bo.ActCheckActivityAddInfoAtomReqBO;
import com.tydic.active.app.atom.bo.ActCheckActivityAddInfoAtomRspBO;
import com.tydic.active.app.atom.bo.ActCreateActivityNewAtomReqBO;
import com.tydic.active.app.atom.bo.ActCreateActivityNewAtomRspBO;
import com.tydic.active.app.atom.bo.ActCreateCodeAtomReqBO;
import com.tydic.active.app.atom.bo.ActCreateCodeAtomRspBO;
import com.tydic.active.app.atom.bo.ActUpdateActiveCouponCommAtomReqBO;
import com.tydic.active.app.atom.bo.ActUpdateActiveCouponCommAtomRspBO;
import com.tydic.active.app.common.bo.ActActiveCommonInfoBO;
import com.tydic.active.app.common.bo.ActDiscountBO;
import com.tydic.active.app.common.bo.ActUpdateActiveCommonBO;
import com.tydic.active.app.common.bo.CreateActivityNewInfoBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActiveExtMapper;
import com.tydic.active.app.dao.ActiveStockMapper;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.CouponFormMapper;
import com.tydic.active.app.dao.CouponNumMapper;
import com.tydic.active.app.dao.po.ActiveExtPo;
import com.tydic.active.app.dao.po.ActiveStockPO;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.dao.po.CouponFormPO;
import com.tydic.active.app.dao.po.CouponNumPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateActivityNewAtomService")
public class ActCreateActivityNewAtomServiceImpl
implements ActCreateActivityNewAtomService {
    @Autowired
    private ActCheckActivityAddInfoAtomService actCheckActivityAddInfoAtomService;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActiveStockMapper activeStockMapper;
    @Autowired
    private ActUpdateActiveCouponCommAtomService actUpdateActiveCouponCommAtomService;
    @Value(value="${couponDetailUrl}")
    private String couponDetailUrl;
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActiveExtMapper activeExtMapper;
    @Autowired
    private ActCreateCodeAtomService actCreateCodeAtomService;

    @Override
    public ActCreateActivityNewAtomRspBO createActivityNew(ActCreateActivityNewAtomReqBO atomReqBO) {
        ActCreateActivityNewAtomRspBO rsp = new ActCreateActivityNewAtomRspBO();
        ActCheckActivityAddInfoAtomReqBO checkAtomReqBO = new ActCheckActivityAddInfoAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)atomReqBO), (Object)((Object)checkAtomReqBO));
        ActCheckActivityAddInfoAtomRspBO checkAtomRspBO = this.actCheckActivityAddInfoAtomService.checkActivityAddInfo(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            throw new BusinessException(checkAtomRspBO.getRespCode(), checkAtomRspBO.getRespDesc());
        }
        atomReqBO.setActActiveCommonInfoBO(checkAtomReqBO.getActActiveCommonInfoBO());
        if ("10".equals(atomReqBO.getMarketingType())) {
            if ("add".equals(atomReqBO.getOperType())) {
                this.addActiveBaseInfo(atomReqBO);
            }
        } else if ("11".equals(atomReqBO.getMarketingType())) {
            if ("add".equals(atomReqBO.getOperType())) {
                this.addCouponFormInfo(atomReqBO, checkAtomRspBO);
            }
        } else {
            throw new BusinessException("14002", "\u8425\u9500\u7c7b\u578b\u3010" + atomReqBO.getMarketingType() + "\u3011\u4e0d\u652f\u6301");
        }
        this.addCommonInfo(atomReqBO);
        rsp.setActiveId(atomReqBO.getActiveId());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u65b0\u589e\u6210\u529f");
        return rsp;
    }

    private void addCouponFormInfo(ActCreateActivityNewAtomReqBO atomReqBO, ActCheckActivityAddInfoAtomRspBO checkAtomRspBO) {
        Long fmId = Sequence.getInstance().nextId();
        CouponFormPO couponFormPO = this.buildCouponFormPO(atomReqBO, checkAtomRspBO);
        couponFormPO.setFmId(fmId);
        couponFormPO.setDetailUrl(this.couponDetailUrl + "fmId=" + fmId + "&orgIdIn=" + couponFormPO.getAdmOrgId());
        int isInsert = this.couponFormMapper.insert(couponFormPO);
        if (isInsert < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        CouponNumPO couponNumPO = new CouponNumPO();
        couponNumPO.setAmountTotalId(Sequence.getInstance().nextId());
        couponNumPO.setFmId(fmId);
        couponNumPO.setTotalNum(atomReqBO.getActCreateCouponFormInfoBO().getTotalAmount());
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        couponNumPO.setMemLimitNum(atomReqBO.getActCreateCouponFormInfoBO().getMemLimitAmount());
        if (null == couponNumPO.getMemLimitNum()) {
            couponNumPO.setMemLimitNum(0);
        }
        couponNumPO.setSendNum(0L);
        couponNumPO.setUsedNum(0L);
        if (null == couponNumPO.getTotalNum()) {
            couponNumPO.setTotalNum(0L);
        }
        couponNumPO.setAdmOrgId(atomReqBO.getOrgIdIn());
        int isInsert4 = this.couponNumMapper.insert(couponNumPO);
        if (isInsert4 < 1) {
            throw new BusinessException("0101", "\u4f18\u60e0\u5377\u6570\u91cf\u63a7\u5236\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        atomReqBO.setActiveId(fmId);
    }

    private void addCommonInfo(ActCreateActivityNewAtomReqBO atomReqBO) {
        ActActiveCommonInfoBO actActiveCommonInfoBO = atomReqBO.getActActiveCommonInfoBO();
        if (null != actActiveCommonInfoBO) {
            ActUpdateActiveCommonBO actUpdateActiveCommonBO = new ActUpdateActiveCommonBO();
            actUpdateActiveCommonBO.setActTemplateGroupBOList(actActiveCommonInfoBO.getActTemplateGroupBOList());
            actUpdateActiveCommonBO.setAddMemRangeList(actActiveCommonInfoBO.getMemRangeList());
            actUpdateActiveCommonBO.setAddMerchantInfoBOlist(actActiveCommonInfoBO.getMerchantInfoBOlist());
            actUpdateActiveCommonBO.setAddPosiztionBOList(actActiveCommonInfoBO.getShowPozitonList());
            actUpdateActiveCommonBO.setAddSkuActiveBOList(actActiveCommonInfoBO.getSkuInfoList());
            actUpdateActiveCommonBO.setActTemplateBOS(actActiveCommonInfoBO.getActTemplateBOS());
            ActUpdateActiveCouponCommAtomReqBO actUpdateActiveCouponCommAtomReqBO = new ActUpdateActiveCouponCommAtomReqBO();
            actUpdateActiveCouponCommAtomReqBO.setActiveId(atomReqBO.getActiveId());
            actUpdateActiveCouponCommAtomReqBO.setMemIdIn(atomReqBO.getMemIdIn());
            actUpdateActiveCouponCommAtomReqBO.setOrgIdIn(atomReqBO.getOrgIdIn());
            actUpdateActiveCouponCommAtomReqBO.setMarketingType(atomReqBO.getMarketingType());
            if (null != atomReqBO.getActivityInfoBO()) {
                actUpdateActiveCouponCommAtomReqBO.setActiveGiftList(atomReqBO.getActivityInfoBO().getActiveGiftList());
                actUpdateActiveCouponCommAtomReqBO.setActiveGiftPkgList(atomReqBO.getActivityInfoBO().getActiveGiftPkgList());
            }
            actUpdateActiveCouponCommAtomReqBO.setActUpdateActiveCommonBO(actUpdateActiveCommonBO);
            ActUpdateActiveCouponCommAtomRspBO atomRspBO = this.actUpdateActiveCouponCommAtomService.updateActiveCouponCommInfo(actUpdateActiveCouponCommAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
    }

    private void addActiveBaseInfo(ActCreateActivityNewAtomReqBO atomReqBO) {
        ActActiveCommonInfoBO actActiveCommonInfoBO = atomReqBO.getActActiveCommonInfoBO();
        CreateActivityNewInfoBO createActivityNewInfoBO = atomReqBO.getActivityInfoBO();
        ActivityPO activityPO = new ActivityPO();
        BeanUtils.copyProperties((Object)createActivityNewInfoBO, (Object)activityPO);
        activityPO.setActiveId(Sequence.getInstance().nextId());
        if (StringUtils.isBlank((CharSequence)createActivityNewInfoBO.getActiveCode())) {
            ActCreateCodeAtomReqBO codeAtomReqBO = new ActCreateCodeAtomReqBO();
            ActCreateCodeAtomRspBO codeAtomRspBO = this.actCreateCodeAtomService.createCode(codeAtomReqBO);
            activityPO.setActiveCode(codeAtomRspBO.getCode());
        }
        Date now = new Date();
        activityPO.setCreateTime(now);
        activityPO.setUpdateTime(now);
        activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        activityPO.setAdmOrgId(atomReqBO.getOrgIdIn());
        activityPO.setSendTarget(actActiveCommonInfoBO.getSendTarget());
        activityPO.setCreateLoginId(atomReqBO.getMemIdIn());
        activityPO.setActiveField5(atomReqBO.getUserName());
        int activityInsertResult = this.activityMapper.insert(activityPO);
        if (activityInsertResult <= 0) {
            throw new BusinessException("14045", "\u6d3b\u52a8\u521b\u5efa\u8bb0\u5f55\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
        ActiveExtPo activeExtPo = new ActiveExtPo();
        activeExtPo.setActiveId(activityPO.getActiveId());
        activeExtPo.setValue1(atomReqBO.getActivityInfoBO().getAccountName());
        this.addActiveExtMap(activeExtPo);
        atomReqBO.setActiveId(activityPO.getActiveId());
        this.addActiveStock(createActivityNewInfoBO, atomReqBO);
    }

    private void addActiveStock(CreateActivityNewInfoBO createActivityNewInfoBO, ActCreateActivityNewAtomReqBO atomReqBO) {
        if (null != createActivityNewInfoBO.getActCount()) {
            if (0 > createActivityNewInfoBO.getActCount()) {
                throw new BusinessException("2014", "\u6d3b\u52a8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
            }
            ActiveStockPO activeStockPO = new ActiveStockPO();
            activeStockPO.setActCount(createActivityNewInfoBO.getActCount());
            activeStockPO.setSaleCount(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
            activeStockPO.setActiveId(atomReqBO.getActiveId());
            activeStockPO.setId(Sequence.getInstance().nextId());
            activeStockPO.setAdmOrgId(atomReqBO.getOrgIdIn());
            int activityStockInsertResult = this.activeStockMapper.insert(activeStockPO);
            if (activityStockInsertResult <= 0) {
                throw new BusinessException("14046", "\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u5e93\u5b58\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private CouponFormPO buildCouponFormPO(ActCreateActivityNewAtomReqBO atomReqBO, ActCheckActivityAddInfoAtomRspBO checkAtomRspBO) {
        CouponFormPO couponFormPO = new CouponFormPO();
        BeanUtils.copyProperties((Object)atomReqBO.getActCreateCouponFormInfoBO(), (Object)couponFormPO);
        couponFormPO.setSendTarget(atomReqBO.getActActiveCommonInfoBO().getSendTarget());
        couponFormPO.setAdmOrgId(atomReqBO.getOrgIdIn());
        couponFormPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
        couponFormPO.setState(ActCommConstant.CouponFormState.AUDIT_PASS);
        couponFormPO.setCreateLoginId(atomReqBO.getMemIdIn() == null ? null : atomReqBO.getMemIdIn().toString());
        couponFormPO.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty(checkAtomRspBO.getActDiscountBOs())) {
            String fmDesc = "\u6ee1";
            ActDiscountBO actDiscountBO = checkAtomRspBO.getActDiscountBOs().get(0);
            couponFormPO.setConditionType(actDiscountBO.getConditionType());
            if (StringUtils.isNotBlank((CharSequence)actDiscountBO.getConditionValue())) {
                couponFormPO.setConditionValue(actDiscountBO.getConditionValue());
                fmDesc = fmDesc + actDiscountBO.getConditionValue();
            }
            if (ActCommConstant.ActiveTemplateConditionType.MONEY.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u5143\u53ef\u7528";
            } else if (ActCommConstant.ActiveTemplateConditionType.ACOUNT.equals(actDiscountBO.getConditionType())) {
                fmDesc = fmDesc + "\u4ef6\u53ef\u7528";
            }
            couponFormPO.setDiscountType(actDiscountBO.getDiscountType());
            couponFormPO.setDiscountValue(actDiscountBO.getDiscountValue());
            couponFormPO.setFmDesc(fmDesc);
        }
        return couponFormPO;
    }

    private void addActiveExtMap(ActiveExtPo activeExtPo) {
        activeExtPo.setKey1("accountName");
        activeExtPo.setName1("\u8d26\u5957\u540d\u79f0");
        this.activeExtMapper.insert(activeExtPo);
    }
}

