/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.tydic.active.app.atom.ActMoneyFullReductionPriceAtomService;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.active.app.common.bo.ActDiscountSkuListBO;
import com.tydic.active.app.common.bo.ActTemplateAttrBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import com.tydic.active.app.constant.ActCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="actMoneyFullReductionPriceAtomService")
public class ActMoneyFullReductionPriceAtomServiceImpl
implements ActMoneyFullReductionPriceAtomService {
    private static final Integer IS_OVER_NO = 0;

    @Override
    public ActCalculationUniversalAtomRspBO calculateMoneyFullReductionPrice(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalSalePrice = new BigDecimal(0);
        BigDecimal oldDiscountMoney = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            totalSalePrice = totalSalePrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            oldDiscountMoney = oldDiscountMoney.add(bo.getDiscountPrice());
        }
        if (!ActCommConstant.isRelationDiscount.YES.equals(atomReqBO.getIsRelationDiscount())) {
            oldDiscountMoney = new BigDecimal(0);
        }
        BigDecimal calculateMoney = totalSalePrice.subtract(oldDiscountMoney);
        BigDecimal discountMoney = new BigDecimal(0);
        if (calculateMoney.compareTo(BigDecimal.ZERO) <= 0) {
            actDiscountSkuListBO.setDiscountMoney(new BigDecimal(0));
            HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
            for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
                skuDiscountMap.put(bo.getSkuId(), new BigDecimal(0));
            }
            actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
            rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
            return rsp;
        }
        BigDecimal feeReach = new BigDecimal(0);
        BigDecimal feeReachDiscount = new BigDecimal(0);
        Integer isLoopAdd2 = ActCommConstant.isLoopAdd.NO;
        for (ActTemplateAttrBO bo : atomReqBO.getActTemplateBO().getActTemplateAttrBOS()) {
            if ("fee_reach".equals(bo.getAttrCode())) {
                feeReach = new BigDecimal(bo.getParaValue());
                continue;
            }
            if ("fee_reach_discount".equals(bo.getAttrCode())) {
                feeReachDiscount = new BigDecimal(bo.getParaValue());
                continue;
            }
            if (!"is_loop_add".equals(bo.getAttrCode())) continue;
            isLoopAdd2 = Integer.valueOf(bo.getParaValue());
        }
        if (calculateMoney.compareTo(feeReach) >= 0) {
            if (ActCommConstant.isLoopAdd.YES.equals(isLoopAdd2)) {
                BigDecimal multply = calculateMoney.divide(feeReach, 0, RoundingMode.DOWN);
                discountMoney = feeReachDiscount.multiply(multply);
            } else {
                discountMoney = feeReachDiscount;
            }
        }
        actDiscountSkuListBO.setDiscountMoney(discountMoney);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        BigDecimal alreadyDiscountPrice = discountMoney;
        for (int i = 0; i < atomReqBO.getSkuInfoList().size(); ++i) {
            if (i + 1 == atomReqBO.getSkuInfoList().size()) {
                skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), alreadyDiscountPrice);
                break;
            }
            BigDecimal moleculeTotalPrice = atomReqBO.getSkuInfoList().get(i).getTotalPrice().multiply(discountMoney).setScale(2, RoundingMode.HALF_UP);
            BigDecimal singelDiscountPrice = moleculeTotalPrice.divide(totalSalePrice, 2, RoundingMode.HALF_UP);
            skuDiscountMap.put(atomReqBO.getSkuInfoList().get(i).getSkuId(), singelDiscountPrice);
            alreadyDiscountPrice = alreadyDiscountPrice.subtract(singelDiscountPrice);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

