/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.atom.ActShopActiveValidCheckAtomService;
import com.tydic.active.app.atom.bo.ActShopActiveValidCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActShopActiveValidCheckAtomRspBO;
import com.tydic.active.app.common.bo.ActSkuScopeBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.CouponFormMapper;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.dao.po.CouponFormPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actShopActiveValidCheckAtomService")
public class ActShopActiveValidCheckAtomServiceImpl
implements ActShopActiveValidCheckAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActShopActiveValidCheckAtomServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8303\u56f4\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1";
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Value(value="${CATEGORY_LEVEL}")
    private Integer categoryLevel;

    @Override
    public ActShopActiveValidCheckAtomRspBO checkShopActiveValid(ActShopActiveValidCheckAtomReqBO atomReqBO) {
        Integer discountSkuRange;
        ActShopActiveValidCheckAtomRspBO rsp = new ActShopActiveValidCheckAtomRspBO();
        if ("10".equals(atomReqBO.getMarketingType())) {
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveId(atomReqBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            activityPO.setAdmOrgId(atomReqBO.getOrgIdIn());
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                throw new BusinessException("14035", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            discountSkuRange = activity.getDiscountSkuRange();
        } else {
            CouponFormPO reqPO = new CouponFormPO();
            reqPO.setFmId(atomReqBO.getActiveId());
            reqPO.setAdmOrgId(atomReqBO.getOrgIdIn());
            reqPO.setIsDelete(ActCommConstant.IsDelete.NORMAL);
            CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(reqPO);
            if (null == couponFormPO) {
                throw new BusinessException("14035", "\u4f18\u60e0\u5377\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
            discountSkuRange = Integer.parseInt(couponFormPO.getCouponField1());
        }
        if (ActCommConstant.DiscountSkuRange.PLATFORM.equals(discountSkuRange)) {
            throw new BusinessException("14002", "\u5546\u54c1\u8303\u56f4\u4e3a\u5e73\u53f0\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u5546\u54c1\u8303\u56f4");
        }
        if (!CollectionUtils.isEmpty(atomReqBO.getSkuInfoList())) {
            for (ActSkuScopeBO bo : atomReqBO.getSkuInfoList()) {
                bo.setRangeType(discountSkuRange);
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

