/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.tydic.active.app.busi.ActApproveWelfarePointsChangeBusiService;
import com.tydic.active.app.busi.WelfareActiveAuditOperateService;
import com.tydic.active.app.busi.bo.ActApproveWelfarePointsChangeBusiReqBO;
import com.tydic.active.app.busi.bo.ActApproveWelfarePointsChangeBusiRspBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditRspBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActApproveWelfarePointsChangeBusiServiceImpl
implements ActApproveWelfarePointsChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActApproveWelfarePointsChangeBusiServiceImpl.class);
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfareActiveAuditOperateService welfareActiveAuditOperateService;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;

    public ActApproveWelfarePointsChangeBusiRspBO actApproveWelfarePointsChange(ActApproveWelfarePointsChangeBusiReqBO reqBO) {
        ActApproveWelfarePointsChangeBusiRspBO rspBO = new ActApproveWelfarePointsChangeBusiRspBO();
        WelfareActiveInvokeAuditReqBO invokeAuditReqBO = new WelfareActiveInvokeAuditReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)invokeAuditReqBO);
        invokeAuditReqBO.setObjIds(new HashSet(reqBO.getChangeIds()));
        invokeAuditReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_CHARGE_CHANGE_AUDIT);
        WelfareActiveInvokeAuditRspBO auditRspBO = this.welfareActiveAuditOperateService.invokeAuditOrder(invokeAuditReqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(auditRspBO.getRespDesc());
            return rspBO;
        }
        for (Long changeId : reqBO.getChangeIds()) {
            Boolean finishFlag = (Boolean)auditRspBO.getAuditFinishMap().get(changeId);
            if (!finishFlag.booleanValue()) continue;
            WelfarePointsChangePO pointsChangePO = new WelfarePointsChangePO();
            pointsChangePO.setChangeId(changeId);
            if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
                pointsChangePO.setChangeStatus(ActCommConstant.WelfarePointsChangeApproveStatus.PASS);
                pointsChangePO.setStatus(ActCommConstant.WelfarePointsChangeStatus.CONFIRMING);
            } else if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.NOT_PASS)) {
                pointsChangePO.setChangeStatus(ActCommConstant.WelfarePointsChangeApproveStatus.REJECT);
                WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(changeId);
                WelfarePointsChargePO record = new WelfarePointsChargePO();
                record.setWelfarePointsChargeId(changePO.getWelfarePointsChargeId());
                record.setStatus(ActActiveConstant.welfarePointsStatus.APPROVE_PASS);
                this.welfarePointsChargeMapper.updateByPrimaryKeySelective(record);
            }
            this.welfarePointsChangeMapper.updateByPrimaryKeySelective(pointsChangePO);
        }
        log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5f00\u59cb");
        ArrayList<Long> changeIds = new ArrayList<Long>();
        for (Long changeId : reqBO.getChangeIds()) {
            WelfarePointsChangePO welfarePointsChangePO = this.welfarePointsChangeMapper.selectByPrimaryKey(changeId);
            if (!ActCommConstant.WelfarePointsChangeApproveStatus.PASS.equals(welfarePointsChangePO.getChangeStatus()) || !ActCommConstant.WelfarePointsChangeStatus.CONFIRMING.equals(welfarePointsChangePO.getStatus())) continue;
            changeIds.add(changeId);
        }
        rspBO.setChangeIds(changeIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAuditFinishMap(auditRspBO.getAuditFinishMap());
        return rspBO;
    }
}

