/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.busi.ActConfirmWelfarePointsChangeBusiService;
import com.tydic.active.app.busi.bo.ActConfirmWelfarePointsChangeBusiReqBO;
import com.tydic.active.app.busi.bo.ActConfirmWelfarePointsChangeBusiRspBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.utils.ActDateUtils;
import com.tydic.fsc.bill.ability.api.FscRecvClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimListQueryAbilityRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimConfirmAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActConfirmWelfarePointsChangeBusiServiceImpl
implements ActConfirmWelfarePointsChangeBusiService {
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private FscRecvClaimListQueryAbilityService fscRecvClaimListQueryAbilityService;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    public ActConfirmWelfarePointsChangeBusiRspBO dealActConfirmWelfarePointsChange(ActConfirmWelfarePointsChangeBusiReqBO reqBO) {
        ActConfirmWelfarePointsChangeBusiRspBO rspBO = new ActConfirmWelfarePointsChangeBusiRspBO();
        WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectByPrimaryKey(reqBO.getChangeId());
        if (null == changePO) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u6761\u8bb0\u5f55!");
            return rspBO;
        }
        changePO.setStatus(ActCommConstant.WelfarePointsChangeStatus.CONFIRMED);
        this.welfarePointsChangeMapper.updateByPrimaryKey(changePO);
        WelfarePointsChargePO record = new WelfarePointsChargePO();
        record.setWelfarePointsChargeId(changePO.getWelfarePointsChargeId());
        record.setStatus(ActActiveConstant.welfarePointsStatus.REPEALED);
        Date date = new Date();
        record.setOperateTime(date);
        String objectId = DateUtils.dateToStr((Date)date, (String)"yyyyMMddHHmmss");
        this.welfarePointsChargeMapper.updateByPrimaryKeySelective(record);
        WelfarePointsChargePO po = this.welfarePointsChargeMapper.selectByPrimaryKey(changePO.getWelfarePointsChargeId());
        this.backChargeAmount(po, reqBO, po.getChargeAmount(), objectId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    void backChargeAmount(WelfarePointsChargePO po, ActConfirmWelfarePointsChangeBusiReqBO reqBO, BigDecimal releaseAmout, String objectId) {
        FscAccountDealWelfareDeductAbilityReqBO fscReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        fscReqBO.setSupId(this.operationOrgId);
        fscReqBO.setCreditOrgId(po.getOrgIdWelfarePoints());
        Integer payType2 = this.translate(po.getExtField1());
        if (payType2 == null) {
            throw new BusinessException("8888", "\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38!");
        }
        fscReqBO.setPayType(payType2);
        fscReqBO.setOperationType(Integer.valueOf(1));
        fscReqBO.setOrderId(po.getWelfarePointsChargeId());
        fscReqBO.setOrderNo(po.getWelfarePointChargeCode());
        fscReqBO.setObjId(po.getWelfarePointsChargeId());
        fscReqBO.setTotalAmount(releaseAmout.negate());
        fscReqBO.setBusiOrderType(Integer.valueOf(3));
        fscReqBO.setWelfareType(Integer.valueOf(po.getWelfareType().byteValue()));
        fscReqBO.setUserId(reqBO.getUserId());
        fscReqBO.setUserName(reqBO.getUserName());
        fscReqBO.setName(reqBO.getName());
        fscReqBO.setOrgId(reqBO.getOrgId());
        FscAccountDealWelfareDeductAbilityRspBO fscRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(fscReqBO);
        if (!"0000".equals(fscRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u798f\u70b9\u5145\u503c\u7f16\u53f7:" + po.getWelfarePointChargeCode() + ",\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u9000\u6b3e\u5931\u8d25!,\u539f\u56e0:" + fscRspBO.getRespDesc());
        }
    }

    private Integer translate(String extField1) {
        if ("1".equals(extField1)) {
            return 3;
        }
        if ("2".equals(extField1)) {
            return 2;
        }
        return null;
    }

    private void backRecClaim(WelfarePointsChargePO po) {
        FscRecvClaimListQueryAbilityReqBO queryReqBO = new FscRecvClaimListQueryAbilityReqBO();
        queryReqBO.setSerialNumber(po.getBankSerialNumber());
        FscRecvClaimListQueryAbilityRspBO queryAbilityRspBO = this.fscRecvClaimListQueryAbilityService.qryRecvClaimList(queryReqBO);
        FscRecvClaimConfirmAbilityReqBO bo = new FscRecvClaimConfirmAbilityReqBO();
        ArrayList<FscClaimDetailBO> detailBOS = new ArrayList<FscClaimDetailBO>();
        for (FscRecvClaimBO fscRecvClaimBO : queryAbilityRspBO.getRows()) {
            if (!po.getBankSerialNumber().equals(fscRecvClaimBO.getSerialNumber())) continue;
            bo.setClaimId(fscRecvClaimBO.getClaimId());
            bo.setRecvAmt(fscRecvClaimBO.getRecvAmt());
            BigDecimal noClaimAmt = fscRecvClaimBO.getNoClaimAmt().add(po.getChargeAmount());
            bo.setNoClaimAmt(noClaimAmt.setScale(2, 4));
            FscClaimDetailBO detailBO = new FscClaimDetailBO();
            detailBO.setClaimAmt(po.getChargeAmount());
            detailBO.setClaimDate(ActDateUtils.strToDate(ActDateUtils.dateToStr(new Date())));
            detailBO.setOperationType(ActActiveConstant.fscRecvClaimConfirmType.CANCEL);
            detailBO.setObjectId(po.getWelfarePointsChargeId());
            detailBO.setObjectNo(po.getWelfarePointChargeCode());
            detailBO.setClaimType("5");
            detailBOS.add(detailBO);
            bo.setClaimDetailList(detailBOS);
        }
        FscRecvClaimConfirmAbilityRspBO rspBO = this.fscRecvClaimConfirmAbilityService.recvClaimConfirm(bo);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
    }
}

