/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.tydic.active.app.atom.ActCountFullReductionDiscountRateAtomService;
import com.tydic.active.app.atom.ActCountFullReductionMoneyAtomService;
import com.tydic.active.app.atom.ActMoneyFullReductionDiscountRateAtomService;
import com.tydic.active.app.atom.ActMoneyFullReductionPriceAtomService;
import com.tydic.active.app.atom.ActQryActiveTemplateGroupAtomService;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.active.app.atom.bo.ActQryActiveTemplateGroupAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryActiveTemplateGroupAtomRspBO;
import com.tydic.active.app.busi.ActCouponCalculationBusiService;
import com.tydic.active.app.busi.bo.ActCouponCalculationBusiReqBO;
import com.tydic.active.app.busi.bo.ActCouponCalculationBusiRspBO;
import com.tydic.active.app.common.bo.ActDiscountSkuListBO;
import com.tydic.active.app.common.bo.ActTemplateBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import com.tydic.active.app.common.bo.SkuCouponChoiceBO;
import com.tydic.active.app.constant.ActCommConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponCalculationBusiServiceImpl")
public class ActCouponCalculationBusiServiceImpl
implements ActCouponCalculationBusiService {
    @Autowired
    private ActQryActiveTemplateGroupAtomService actQryActiveTemplateGroupAtomService;
    @Autowired
    private ActMoneyFullReductionPriceAtomService actMoneyFullReductionPriceAtomService;
    @Autowired
    private ActCountFullReductionMoneyAtomService actCountFullReductionMoneyAtomService;
    @Autowired
    private ActMoneyFullReductionDiscountRateAtomService actMoneyFullReductionDiscountRateAtomService;
    @Autowired
    private ActCountFullReductionDiscountRateAtomService actCountFullReductionDiscountRateAtomService;

    public ActCouponCalculationBusiRspBO couponCalculatePrice(ActCouponCalculationBusiReqBO busiReqBO) {
        ActCouponCalculationBusiRspBO rsp = new ActCouponCalculationBusiRspBO();
        BigDecimal totalDiscountPrice = new BigDecimal(0);
        BigDecimal totalPrice = new BigDecimal(0);
        for (SkuCalculationActiveBO bo : busiReqBO.getSkuInfoList()) {
            bo.setTotalPrice(bo.getSalePrice().multiply(bo.getActCount()));
        }
        for (SkuCouponChoiceBO bo2 : busiReqBO.getCouponSkuInfoBOList()) {
            if (CollectionUtils.isEmpty((Collection)bo2.getSkuIdList())) continue;
            ArrayList<SkuCalculationActiveBO> calculateSkuInfoList = new ArrayList<SkuCalculationActiveBO>();
            block2: for (String skuId : bo2.getSkuIdList()) {
                for (SkuCalculationActiveBO bo3 : busiReqBO.getSkuInfoList()) {
                    if (!skuId.equals(bo3.getSkuId())) continue;
                    calculateSkuInfoList.add(bo3);
                    continue block2;
                }
            }
            ActQryActiveTemplateGroupAtomReqBO actQryActiveTemplateGroupAtomReqBO = new ActQryActiveTemplateGroupAtomReqBO();
            actQryActiveTemplateGroupAtomReqBO.setMarketingType("11");
            actQryActiveTemplateGroupAtomReqBO.setActiveId(bo2.getFmId());
            actQryActiveTemplateGroupAtomReqBO.setOperType("operTemplate");
            ActQryActiveTemplateGroupAtomRspBO actQryActiveTemplateGroupAtomRspBO = this.actQryActiveTemplateGroupAtomService.qryActiveTemplateGroup(actQryActiveTemplateGroupAtomReqBO);
            for (ActTemplateBO bo1 : actQryActiveTemplateGroupAtomRspBO.getActTemplateBOS()) {
                ActDiscountSkuListBO calculateResult = new ActDiscountSkuListBO();
                if (ActCommConstant.ActivityTempIdDefine.MONEY_FULL_REDUCTION_ID.equals(bo1.getTemplateId())) {
                    calculateResult = this.calculateMoneyFullReductionPrice(calculateSkuInfoList, bo1);
                }
                if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_MONEY_ID.equals(bo1.getTemplateId())) {
                    calculateResult = this.calculateCountFullReductionMoney(calculateSkuInfoList, bo1);
                }
                if (ActCommConstant.ActivityTempIdDefine.FEE_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    calculateResult = this.calculateMoneyFullReductionDiscountRate(calculateSkuInfoList, bo1);
                }
                if (ActCommConstant.ActivityTempIdDefine.COUNT_FULL_REDUCTION_DISCOUNT_ID.equals(bo1.getTemplateId())) {
                    calculateResult = this.calculateCountFullReductionDiscountRate(calculateSkuInfoList, bo1);
                }
                bo2.setTotalDiscountPrice(calculateResult.getDiscountMoney());
                this.setParam(calculateResult.getSkuDiscountMap(), calculateSkuInfoList);
            }
        }
        for (SkuCalculationActiveBO bo : busiReqBO.getSkuInfoList()) {
            totalPrice = totalPrice.add(bo.getTotalPrice());
            if (null == bo.getDiscountPrice()) continue;
            totalDiscountPrice = totalDiscountPrice.add(bo.getDiscountPrice());
        }
        rsp.setRows(busiReqBO.getSkuInfoList());
        rsp.setCouponSkuInfoBOList(busiReqBO.getCouponSkuInfoBOList());
        rsp.setTotalPrice(totalPrice);
        rsp.setTotalDiscountPrice(totalDiscountPrice);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private ActDiscountSkuListBO calculateCountFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actCountFullReductionDiscountRateAtomService.calculateCountFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateMoneyFullReductionDiscountRate(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actMoneyFullReductionDiscountRateAtomService.calculateMoneyFullReductionDiscountRate(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateCountFullReductionMoney(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actCountFullReductionMoneyAtomService.calculateCountFullReductionMoney(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private ActDiscountSkuListBO calculateMoneyFullReductionPrice(List<SkuCalculationActiveBO> skuInfoList, ActTemplateBO actTemplateBO) {
        ActCalculationUniversalAtomReqBO actCalculationUniversalAtomReqBO = new ActCalculationUniversalAtomReqBO();
        actCalculationUniversalAtomReqBO.setSkuInfoList(skuInfoList);
        actCalculationUniversalAtomReqBO.setActTemplateBO(actTemplateBO);
        ActCalculationUniversalAtomRspBO actCalculationUniversalAtomRspBO = this.actMoneyFullReductionPriceAtomService.calculateMoneyFullReductionPrice(actCalculationUniversalAtomReqBO);
        return actCalculationUniversalAtomRspBO.getActDiscountSkuListBO();
    }

    private void setParam(Map<String, BigDecimal> skuDiscountMap, List<SkuCalculationActiveBO> skuInfoList) {
        if (null != skuDiscountMap) {
            for (SkuCalculationActiveBO bo2 : skuInfoList) {
                if (null == skuDiscountMap.get(bo2.getSkuId())) continue;
                if (null != bo2.getDiscountPrice()) {
                    bo2.setDiscountPrice(bo2.getDiscountPrice().add(skuDiscountMap.get(bo2.getSkuId())));
                    continue;
                }
                bo2.setDiscountPrice(skuDiscountMap.get(bo2.getSkuId()));
            }
        }
    }
}

