/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.ActRedisManager;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.atom.ActQueryMemDetailInfoAtomService;
import com.tydic.active.app.atom.bo.ActQueryMemDetailInfoAtomReqBO;
import com.tydic.active.app.atom.bo.ActQueryMemDetailInfoAtomRspBO;
import com.tydic.active.app.busi.ActCouponReceiveBusiService;
import com.tydic.active.app.busi.bo.ActCouponReceiveBusiReqBO;
import com.tydic.active.app.busi.bo.ActCouponReceiveBusiRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActActiveMemJoinNumMapper;
import com.tydic.active.app.dao.ActiveMemRangeMapper;
import com.tydic.active.app.dao.CouponFormMapper;
import com.tydic.active.app.dao.CouponInstMapper;
import com.tydic.active.app.dao.CouponNumMapper;
import com.tydic.active.app.dao.po.ActActiveMemJoinNumPO;
import com.tydic.active.app.dao.po.ActiveMemRangePO;
import com.tydic.active.app.dao.po.CouponFormAndInstPO;
import com.tydic.active.app.dao.po.CouponFormPO;
import com.tydic.active.app.dao.po.CouponInstPO;
import com.tydic.active.app.dao.po.CouponNumPO;
import com.tydic.active.app.facde.ActUmcServiceHolder;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityReqBO;
import com.tydic.active.external.api.umc.bo.ActUmcReceiveCouponAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponReceiveBusiService")
public class ActCouponReceiveBusiServiceImpl
implements ActCouponReceiveBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCouponReceiveBusiServiceImpl.class);
    @Autowired
    private CouponFormMapper couponFormMapper;
    @Autowired
    private ActActiveMemJoinNumMapper actActiveMemJoinNumMapper;
    @Autowired
    private CouponNumMapper couponNumMapper;
    @Autowired
    private ActiveMemRangeMapper activeMemRangeMapper;
    @Autowired
    private CouponInstMapper couponInstMapper;
    @Autowired
    private ActQueryMemDetailInfoAtomService actQueryMemDetailInfoAtomService;
    @Resource(name="couponNoSequencePager")
    private OrderSequence couponNoSequencePager;
    @Autowired
    private ActRedisManager cacheManager;
    @Autowired
    private ActUmcServiceHolder actUmcServiceHolder;

    public ActCouponReceiveBusiRspBO updateSendNumAsTotalNum(ActCouponReceiveBusiReqBO busiReqBO) {
        ActCouponReceiveBusiRspBO rsp = new ActCouponReceiveBusiRspBO();
        CouponNumPO couponNum = new CouponNumPO();
        couponNum.setAdmOrgId(busiReqBO.getOrgIdIn());
        couponNum.setFmId(busiReqBO.getFmId());
        this.couponNumMapper.updateSendNumAsTotalNum(couponNum);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    public ActCouponReceiveBusiRspBO couponReceive(ActCouponReceiveBusiReqBO busiReqBO) {
        ActCouponReceiveBusiRspBO busiRspBO = new ActCouponReceiveBusiRspBO();
        busiReqBO.setMemId(busiReqBO.getMemIdIn());
        CouponFormPO couponFormPO = this.checkcouponForm(busiReqBO);
        if (ActCommConstant.CouponReceiveOperType.SEND_COUPON.equals(busiReqBO.getOperType())) {
            this.insertActiveMemRangeMapper(busiReqBO);
        }
        this.checkCouponUserRange(busiReqBO);
        CouponNumPO couponNumPO = this.checkUserReceiveNum(busiReqBO);
        try {
            CouponInstPO couponInstPO = this.insertCouponInst(couponFormPO, busiReqBO);
            ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
            actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
            actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
            actActiveMemJoinNumPO.setMarketingType("11");
            actActiveMemJoinNumPO.setMemLimitNum(Objects.nonNull(couponNumPO) ? couponNumPO.getMemLimitNum() : null);
            int count1 = this.actActiveMemJoinNumMapper.updateJoinNum(actActiveMemJoinNumPO);
            if (Objects.nonNull(couponNumPO) && couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0 && count1 < 1) {
                throw new BusinessException("14050", "\u4f1a\u5458\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
            }
            this.callMemCouponReceiveService(couponFormPO, couponInstPO, busiReqBO);
        }
        catch (Exception e) {
            Long fmId = Objects.nonNull(couponNumPO) ? couponNumPO.getFmId() : null;
            String redisKey = "COUPON_RECEIVE_NUM_PREX_" + fmId;
            this.cacheManager.decr(redisKey);
            throw e;
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        return busiRspBO;
    }

    private void insertActiveMemRangeMapper(ActCouponReceiveBusiReqBO busiReqBO) {
        ActiveMemRangePO checkActiveMemRangePO = new ActiveMemRangePO();
        checkActiveMemRangePO.setActiveId(busiReqBO.getFmId());
        checkActiveMemRangePO.setMarketingType("11");
        checkActiveMemRangePO.setMemParamType("15");
        checkActiveMemRangePO.setParamInsCode(busiReqBO.getMemId().toString());
        ActiveMemRangePO checkActiveMemRange = this.activeMemRangeMapper.getModelBy(checkActiveMemRangePO);
        if (null == checkActiveMemRange) {
            ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
            activeMemRangePO.setMemRangeId(Sequence.getInstance().nextId());
            activeMemRangePO.setMarketingType("11");
            activeMemRangePO.setAdmOrgId(busiReqBO.getOrgIdIn());
            activeMemRangePO.setActiveId(busiReqBO.getFmId());
            activeMemRangePO.setMemParamType("15");
            activeMemRangePO.setParamInsCode(busiReqBO.getMemId().toString());
            activeMemRangePO.setParamInsName("");
            int isInsert = this.activeMemRangeMapper.insert(activeMemRangePO);
            if (isInsert < 1) {
                throw new BusinessException("14010", "\u65b0\u589e\u7528\u6237\u8303\u56f4\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void callMemCouponReceiveService(CouponFormPO couponFormPO, CouponInstPO couponInstPO, ActCouponReceiveBusiReqBO busiReqBO) {
        ActUmcReceiveCouponAbilityReqBO umcReqBO = new ActUmcReceiveCouponAbilityReqBO();
        umcReqBO.setMemId(busiReqBO.getMemId());
        umcReqBO.setCouponNo(couponInstPO.getCouponNo());
        umcReqBO.setCouponDesc(couponFormPO.getFmDesc());
        umcReqBO.setCouponType(couponInstPO.getCouponType());
        if (null != busiReqBO.getExpTime()) {
            umcReqBO.setExpTime(DateUtils.dateToStrLong((Date)busiReqBO.getExpTime()));
        } else {
            umcReqBO.setExpTime(DateUtils.dateToStrLong((Date)couponInstPO.getExpTime()));
        }
        umcReqBO.setFmId(couponInstPO.getFmId());
        umcReqBO.setCouponValue(couponFormPO.getDiscountValue());
        umcReqBO.setCouponPicUrl(couponFormPO.getImageUrl());
        if (null != busiReqBO.getEffTime()) {
            umcReqBO.setEffTime(DateUtils.dateToStrLong((Date)busiReqBO.getEffTime()));
        } else {
            umcReqBO.setEffTime(DateUtils.dateToStrLong((Date)couponFormPO.getEffTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getFmName())) {
            umcReqBO.setCouponName(busiReqBO.getFmName());
        } else {
            umcReqBO.setCouponName(couponFormPO.getFmName());
        }
        umcReqBO.setCouponKind(couponFormPO.getCouponLevel());
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getCouponMark())) {
            umcReqBO.setCouponMark(busiReqBO.getCouponMark());
        } else {
            umcReqBO.setCouponMark(couponFormPO.getCouponMark());
        }
        CouponFormAndInstPO couponFormAndInstPO = new CouponFormAndInstPO();
        BeanUtils.copyProperties((Object)couponFormPO, (Object)couponFormAndInstPO);
        couponFormAndInstPO.setCouponInstPO(couponInstPO);
        umcReqBO.setCouponJson(JSON.toJSONString((Object)couponFormAndInstPO));
        ActUmcReceiveCouponAbilityRspBO rspBO = this.actUmcServiceHolder.getActExternalUmcConponService().invokeReceiveCoupon(umcReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException("0105", "\u4f18\u60e0\u5238\u9886\u53d6\u539f\u5b50\u670d\u52a1\u8c03\u7528\u5916\u90e8\u670d\u52a1\u5931\u8d25");
        }
    }

    private CouponInstPO insertCouponInst(CouponFormPO couponFormPO, ActCouponReceiveBusiReqBO busiReqBO) {
        CouponInstPO couponInstPO = new CouponInstPO();
        BeanUtils.copyProperties((Object)couponFormPO, (Object)couponInstPO);
        if (null != busiReqBO.getExpTime()) {
            couponInstPO.setExpTime(busiReqBO.getExpTime());
        }
        if (null != busiReqBO.getEffTime()) {
            couponFormPO.setEffTime(busiReqBO.getEffTime());
        }
        String couponNo = String.valueOf(Sequence.getInstance().nextId());
        couponInstPO.setCouponNo(couponFormPO.getCouponType() + couponNo);
        couponInstPO.setMemId(busiReqBO.getMemId().toString());
        couponInstPO.setCreateTime(new Date());
        couponInstPO.setReceiveTime(new Date());
        couponInstPO.setAdmOrgId(couponFormPO.getAdmOrgId());
        if (couponFormPO.getDiscountValue() != null) {
            couponInstPO.setCouponValue(Integer.parseInt(couponFormPO.getDiscountValue()));
        }
        couponInstPO.setState(ActCommConstant.CouponState.TO_BE_USED);
        int count = this.couponInstMapper.insert(couponInstPO);
        if (count != 1) {
            throw new BusinessException("14010", "[" + couponInstPO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25");
        }
        return couponInstPO;
    }

    private CouponFormPO checkcouponForm(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponFormPO reqPO = new CouponFormPO();
        reqPO.setFmId(busiReqBO.getFmId());
        reqPO.setMerchantId(Long.parseLong(busiReqBO.getOrgIdIn()));
        CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(reqPO);
        if (couponFormPO == null) {
            throw new BusinessException("14003", "\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        if (new Date().compareTo(couponFormPO.getExpTime()) > 0) {
            throw new BusinessException("14054", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (!couponFormPO.getState().equals(ActCommConstant.CouponFormState.AUDIT_PASS)) {
            throw new BusinessException("14009", "\u4f18\u60e0\u5377\u5df2\u62a2\u5b8c");
        }
        return couponFormPO;
    }

    private CouponNumPO checkUserReceiveNum(ActCouponReceiveBusiReqBO busiReqBO) {
        CouponNumPO couponNumPO = this.couponNumMapper.selectByPrimaryKey(busiReqBO.getFmId());
        if (couponNumPO != null) {
            ActActiveMemJoinNumPO actActiveMemJoinNumPO = new ActActiveMemJoinNumPO();
            actActiveMemJoinNumPO.setActiveId(busiReqBO.getFmId());
            actActiveMemJoinNumPO.setMarketingType("11");
            actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
            actActiveMemJoinNumPO.setAdmOrgId(couponNumPO.getAdmOrgId());
            ActActiveMemJoinNumPO joinNumPO = this.actActiveMemJoinNumMapper.selectByRecord(actActiveMemJoinNumPO);
            if (joinNumPO == null) {
                actActiveMemJoinNumPO.setMemId(busiReqBO.getMemId().toString());
                actActiveMemJoinNumPO.setJoinNum(0);
                try {
                    this.actActiveMemJoinNumMapper.insert(actActiveMemJoinNumPO);
                }
                catch (Exception e) {
                    LOGGER.debug("\u522b\u7684\u7ebf\u7a0b\u5df2\u65b0\u589e\u6570\u636e" + e.getMessage());
                }
            } else if (couponNumPO.getMemLimitNum() != null && couponNumPO.getMemLimitNum() != 0 && joinNumPO.getJoinNum() >= couponNumPO.getMemLimitNum()) {
                throw new BusinessException("14050", "\u4f1a\u5458\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u8fbe\u4e0a\u9650");
            }
            if (couponNumPO.getTotalNum() != null && couponNumPO.getTotalNum() != 0L) {
                if (couponNumPO.getSendNum() != null && couponNumPO.getSendNum() >= couponNumPO.getTotalNum()) {
                    throw new BusinessException("14049", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
                }
                String redisKey = "COUPON_RECEIVE_NUM_PREX_" + couponNumPO.getFmId();
                Long couponReceiveNum = this.cacheManager.incr(redisKey);
                if (couponReceiveNum > couponNumPO.getTotalNum()) {
                    this.cacheManager.decr(redisKey);
                    throw new BusinessException("14049", "\u4f18\u60e0\u5238\u5df2\u62a2\u5b8c");
                }
            }
        }
        return couponNumPO;
    }

    private void checkCouponUserRange(ActCouponReceiveBusiReqBO busiReqBO) {
        Iterator<String> iterator;
        ActQueryMemDetailInfoAtomReqBO actQueryMemDetailInfoAtomReqBO = new ActQueryMemDetailInfoAtomReqBO();
        actQueryMemDetailInfoAtomReqBO.setMemId(busiReqBO.getMemIdIn());
        ActQueryMemDetailInfoAtomRspBO actQueryMemDetailInfoAtomRspBO = this.actQueryMemDetailInfoAtomService.queryMemDetailInfo(actQueryMemDetailInfoAtomReqBO);
        if (null == actQueryMemDetailInfoAtomRspBO || !"0000".equals(actQueryMemDetailInfoAtomRspBO.getRespCode())) {
            throw new BusinessException("0105", "\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u9519");
        }
        ActiveMemRangePO activeMemRangePO = new ActiveMemRangePO();
        activeMemRangePO.setActiveId(busiReqBO.getFmId());
        activeMemRangePO.setMarketingType("11");
        List<ActiveMemRangePO> daoList = this.activeMemRangeMapper.getList(activeMemRangePO);
        ArrayList<String> memMark = new ArrayList<String>();
        ArrayList<String> memGroup = new ArrayList<String>();
        ArrayList<String> memLevel = new ArrayList<String>();
        ArrayList<String> newOldMem = new ArrayList<String>();
        ArrayList<Long> memOrgId = new ArrayList<Long>();
        ArrayList<Long> memId = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(daoList)) {
            if (daoList.size() == 1 && "99".equals(daoList.get(0).getMemParamType())) {
                return;
            }
            for (ActiveMemRangePO po : daoList) {
                if (po.getMemParamType().equals("12")) {
                    memGroup.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("10")) {
                    memLevel.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("11")) {
                    memMark.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("13")) {
                    newOldMem.add(po.getParamInsCode());
                }
                if (po.getMemParamType().equals("14")) {
                    memOrgId.add(Long.parseLong(po.getParamInsCode()));
                }
                if (!po.getMemParamType().equals("15")) continue;
                memId.add(Long.parseLong(po.getParamInsCode()));
            }
        }
        Integer flag = 0;
        if (!CollectionUtils.isEmpty(memMark) && !CollectionUtils.isEmpty(actQueryMemDetailInfoAtomRspBO.getMemTables()) && (iterator = actQueryMemDetailInfoAtomRspBO.getMemTables().iterator()).hasNext()) {
            String memTable = iterator.next();
            memMark.contains(memTable);
            flag = flag + 1;
        }
        if (!CollectionUtils.isEmpty(memGroup) && !CollectionUtils.isEmpty(actQueryMemDetailInfoAtomRspBO.getMemGroups()) && (iterator = actQueryMemDetailInfoAtomRspBO.getMemGroups().iterator()).hasNext()) {
            String memGroupItem = iterator.next();
            memGroup.contains(memGroupItem);
            flag = flag + 1;
        }
        if (!CollectionUtils.isEmpty(newOldMem) && !CollectionUtils.isEmpty(actQueryMemDetailInfoAtomRspBO.getNewOlds()) && (iterator = actQueryMemDetailInfoAtomRspBO.getNewOlds().iterator()).hasNext()) {
            String newOldItem = iterator.next();
            newOldMem.contains(newOldItem);
            flag = flag + 1;
        }
        if (!CollectionUtils.isEmpty(memLevel) && !CollectionUtils.isEmpty(actQueryMemDetailInfoAtomRspBO.getMemLevels()) && (iterator = actQueryMemDetailInfoAtomRspBO.getMemLevels().iterator()).hasNext()) {
            String memLevelItem = iterator.next();
            memLevel.contains(memLevelItem);
            flag = flag + 1;
        }
        if (!CollectionUtils.isEmpty(memOrgId) && actQueryMemDetailInfoAtomRspBO.getMemOrgId() != null) {
            memOrgId.contains(actQueryMemDetailInfoAtomRspBO.getMemOrgId());
            flag = flag + 1;
        }
        if (!CollectionUtils.isEmpty(memId) && actQueryMemDetailInfoAtomRspBO.getMemId() != null) {
            memId.contains(actQueryMemDetailInfoAtomRspBO.getMemId());
            flag = flag + 1;
        }
        if (flag == 0) {
            throw new BusinessException("14052", "\u5f53\u524d\u4f1a\u5458\u65e0\u6743\u9886\u53d6\u5f53\u524d\u4f18\u60e0\u5238");
        }
    }
}

