/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.atom.ActCreateActivityAtomService;
import com.tydic.active.app.atom.bo.ActCreateActivityAtomReqBO;
import com.tydic.active.app.atom.bo.ActCreateActivityAtomRspBO;
import com.tydic.active.app.atom.bo.ActiveAttributeAtomBO;
import com.tydic.active.app.atom.bo.ActiveTemplateAtomBO;
import com.tydic.active.app.busi.ActCreateActivityBusiService;
import com.tydic.active.app.busi.bo.ActCreateActivityBusiReqBO;
import com.tydic.active.app.busi.bo.ActCreateActivityBusiRspBO;
import com.tydic.active.app.common.bo.ActiveGradsDiscountBO;
import com.tydic.active.app.common.bo.CreateActivityInfoBO;
import com.tydic.active.app.common.bo.ShopActiveBO;
import com.tydic.active.app.common.bo.SkuActiveBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.ParamMapper;
import com.tydic.active.app.dao.TemplateMapper;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.dao.po.ParamPO;
import com.tydic.active.app.dao.po.TemplatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateActivityBusiService")
public class ActCreateActivityBusiServiceImpl
implements ActCreateActivityBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateActivityBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private ActCreateActivityAtomService actCreateActivityAtomService;
    private TemplateMapper templateMapper;
    private ParamMapper paramMapper;
    private ActivityMapper activityMapper;

    @Autowired
    public ActCreateActivityBusiServiceImpl(ActCreateActivityAtomService actCreateActivityAtomService, TemplateMapper templateMapper, ParamMapper paramMapper, ActivityMapper activityMapper) {
        this.actCreateActivityAtomService = actCreateActivityAtomService;
        this.templateMapper = templateMapper;
        this.paramMapper = paramMapper;
        this.activityMapper = activityMapper;
    }

    public ActCreateActivityBusiRspBO createActivity(ActCreateActivityBusiReqBO reqBO) {
        ActCreateActivityBusiRspBO rspBO = new ActCreateActivityBusiRspBO();
        for (CreateActivityInfoBO createActivityInfoBO : reqBO.getActivityInfoList()) {
            int checkId;
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveCode(createActivityInfoBO.getActiveCode());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            int checkCode = this.activityMapper.getCheckBy(activityPO);
            if (checkCode > 0) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("[" + createActivityInfoBO.getActiveCode() + "]\u8be5\u6d3b\u52a8\u7f16\u7801\u5df2\u5b58\u5728");
                }
                throw new BusinessException("6011", "[" + createActivityInfoBO.getActiveCode() + "]\u8be5\u6d3b\u52a8\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if (null != createActivityInfoBO.getActiveId() && (checkId = this.activityMapper.getCheckById(createActivityInfoBO.getActiveId())) > 0) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("[" + createActivityInfoBO.getActiveId() + "]\u8be5\u6d3b\u52a8ID\u5df2\u5b58\u5728");
                }
                throw new BusinessException("6011", "[" + createActivityInfoBO.getActiveId() + "]\u8be5\u6d3b\u52a8ID\u5df2\u5b58\u5728");
            }
            ActCreateActivityAtomReqBO atomReqBO = this.generateAtomReqBO(createActivityInfoBO);
            ActCreateActivityAtomRspBO atomRspBO = this.actCreateActivityAtomService.createActivity(atomReqBO);
            if ("0000".equals(atomRspBO.getRespCode())) continue;
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u6d3b\u52a8\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + atomRspBO.getRespDesc());
            }
            throw new BusinessException("6010", atomRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u6210\u529f");
        return rspBO;
    }

    private ActCreateActivityAtomReqBO generateAtomReqBO(CreateActivityInfoBO activityInfoBO) {
        Date end;
        Date start;
        Date now;
        ActCreateActivityAtomReqBO atomReqBO = new ActCreateActivityAtomReqBO();
        BeanUtils.copyProperties((Object)activityInfoBO, (Object)atomReqBO);
        atomReqBO.setActiveAttributeList(new ArrayList<ActiveAttributeAtomBO>());
        atomReqBO.setActiveTemplateList(new ArrayList<ActiveTemplateAtomBO>());
        if (null == atomReqBO.getActiveStatus()) {
            atomReqBO.setActiveStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getActiveGiftList())) {
            atomReqBO.setActiveGiftList(activityInfoBO.getActiveGiftList());
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getActiveGiftPkgList())) {
            atomReqBO.setActiveGiftPkgList(activityInfoBO.getActiveGiftPkgList());
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getShopActiveList())) {
            atomReqBO.setShopActiveList(activityInfoBO.getShopActiveList());
            for (ShopActiveBO shopActiveBO : atomReqBO.getShopActiveList()) {
                shopActiveBO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                if (StringUtils.isBlank((CharSequence)shopActiveBO.getStartTime()) && null == shopActiveBO.getStatus()) {
                    shopActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                }
                if (StringUtils.isBlank((CharSequence)shopActiveBO.getStartTime()) || null != shopActiveBO.getStatus()) continue;
                now = new Date();
                start = DateUtils.strToDateLong((String)shopActiveBO.getStartTime());
                if (!StringUtils.isBlank((CharSequence)shopActiveBO.getEndTime())) {
                    end = DateUtils.strToDateLong((String)shopActiveBO.getEndTime());
                    if (now.after(start) && now.before(end)) {
                        shopActiveBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                        continue;
                    }
                    shopActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                    continue;
                }
                if (now.after(start)) {
                    shopActiveBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                    continue;
                }
                shopActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getActiveSkuList())) {
            atomReqBO.setActiveSkuList(activityInfoBO.getActiveSkuList());
            for (SkuActiveBO skuActiveBO : atomReqBO.getActiveSkuList()) {
                skuActiveBO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                if (skuActiveBO.getStartTime() == null && null == skuActiveBO.getStatus()) {
                    skuActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                }
                if (skuActiveBO.getStartTime() == null || null != skuActiveBO.getStatus()) continue;
                now = new Date();
                start = skuActiveBO.getStartTime();
                if (skuActiveBO.getEndTime() != null) {
                    end = skuActiveBO.getEndTime();
                    if (now.after(start) && now.before(end)) {
                        skuActiveBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                        continue;
                    }
                    skuActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                    continue;
                }
                if (now.after(start)) {
                    skuActiveBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                    continue;
                }
                skuActiveBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
            }
        }
        return atomReqBO;
    }

    private void setFullSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(activityInfoBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("total_fee_discount");
        activeAttributeAtomBO2.setParaValue(activityInfoBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO3 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO3.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO3.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO3 = this.paramMapper.getModelById("accumulate_flag");
        if (null != paramPO3) {
            activeAttributeAtomBO3.setParaName(paramPO3.getParaName());
        }
        activeAttributeAtomBO3.setParaCode("accumulate_flag");
        activeAttributeAtomBO3.setParaValue(activityInfoBO.getAccumulateFlag());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO3);
    }

    private void setFullGiftAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("total_fee_reach");
        activeAttributeAtomBO.setParaValue(activityInfoBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setFullDiscountAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(activityInfoBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount_rate");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("total_fee_discount_rate");
        activeAttributeAtomBO2.setParaValue(activityInfoBO.getDiscountRate());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
    }

    private void setSingleSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_discount");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_discount");
        activeAttributeAtomBO.setParaValue(activityInfoBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setSingleDiscount(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_discount_rate");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_discount_rate");
        activeAttributeAtomBO.setParaValue(activityInfoBO.getDiscountRate());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setSingleDiscountSub(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_AFT_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO1.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("sku_price_discount");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("sku_price_discount");
        activeAttributeAtomBO1.setParaValue(activityInfoBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO2.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("sku_price_discount_rate");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("sku_price_discount_rate");
        activeAttributeAtomBO2.setParaValue(activityInfoBO.getDiscountRate());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
    }

    private void setSingleRedefinePrice(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_DEFINE_PRICE_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_redefine");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_redefine");
        activeAttributeAtomBO.setParaValue(activityInfoBO.getRedefinePrice());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setGradFSub(ActCreateActivityAtomReqBO atomReqBO, CreateActivityInfoBO activityInfoBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(activityInfoBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activityInfoBO.getActiveGradsDiscountList().sort(Comparator.comparing(ActiveGradsDiscountBO::getTotalFeeReach));
        activeAttributeAtomBO1.setParaValue(((ActiveGradsDiscountBO)activityInfoBO.getActiveGradsDiscountList().get(0)).getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_LADDER_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(activityInfoBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO2);
        for (ActiveGradsDiscountBO activeGradsDiscountBO : activityInfoBO.getActiveGradsDiscountList()) {
            ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
            activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
            activeAttributeAtomBO2.setActiveId(activityInfoBO.getActiveId());
            ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_reach_discount");
            if (null != paramPO2) {
                activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
            }
            activeAttributeAtomBO2.setParaCode("total_fee_reach_discount");
            activeAttributeAtomBO2.setParaValue(activeGradsDiscountBO.getTotalFeeReach() + "-" + activeGradsDiscountBO.getFeeDiscount());
            atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
        }
    }
}

