/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.active.app.busi.ActCreateSeckActBusiService;
import com.tydic.active.app.busi.bo.ActCreateSeckActBusiReqBO;
import com.tydic.active.app.busi.bo.ActCreateSeckActBusiRspBO;
import com.tydic.active.app.common.bo.CreateSecKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.CommodityKillCycleMapper;
import com.tydic.active.app.dao.CommodityKillSkuMapper;
import com.tydic.active.app.dao.po.CommodityKillCyclePO;
import com.tydic.active.app.dao.po.CommodityKillSkuPO;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateSeckActBusiService")
public class ActCreateSeckActBusiServiceImpl
implements ActCreateSeckActBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateSeckActBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private CommodityKillCycleMapper commodityKillCycleMapper;
    private CommodityKillSkuMapper commodityKillSkuMapper;

    @Autowired
    public ActCreateSeckActBusiServiceImpl(CommodityKillCycleMapper commodityKillCycleMapper, CommodityKillSkuMapper commodityKillSkuMapper) {
        this.commodityKillCycleMapper = commodityKillCycleMapper;
        this.commodityKillSkuMapper = commodityKillSkuMapper;
    }

    public ActCreateSeckActBusiRspBO createSeckAct(ActCreateSeckActBusiReqBO reqBO) {
        ActCreateSeckActBusiRspBO rspBO = new ActCreateSeckActBusiRspBO();
        CommodityKillCyclePO cyclePO = new CommodityKillCyclePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cyclePO);
        Date now = new Date();
        if (now.before(cyclePO.getStartTime())) {
            cyclePO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
        } else if (now.after(cyclePO.getEndTime())) {
            cyclePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        } else {
            cyclePO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        }
        cyclePO.setCreateTime(now);
        cyclePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int insertCycle = this.commodityKillCycleMapper.insert(cyclePO);
        if (insertCycle < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u79d2\u6740\u5468\u671f\u8868\u5931\u8d25\uff0cinsert\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6016", "\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u5931\u8d25");
        }
        for (CreateSecKillSkuBO createSecKillSkuBO : reqBO.getKillSkuList()) {
            CommodityKillSkuPO skuPO = new CommodityKillSkuPO();
            BeanUtils.copyProperties((Object)createSecKillSkuBO, (Object)skuPO);
            skuPO.setKillCycleId(cyclePO.getKillCycleId());
            skuPO.setSkuState(ActCommConstant.ActivityState.STATE_EFFECTIVE);
            skuPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            skuPO.setCreateTime(now);
            skuPO.setLockNum(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
            skuPO.setSalesNum(ActCommConstant.SALE_SEND_COUNT_DEFAULT_VALUE);
            try {
                skuPO.setKillPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(createSecKillSkuBO.getKillPrice())));
                skuPO.setSkuPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(createSecKillSkuBO.getSkuPrice())));
            }
            catch (Exception e) {
                LOGGER.error("\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u5355\u54c1\u4fe1\u606f\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0cskuId=[" + createSecKillSkuBO.getSkuId() + "]\uff01" + e);
                throw new BusinessException("6012", "\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u5355\u54c1\u4fe1\u606f\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            int insertSku = this.commodityKillSkuMapper.insert(skuPO);
            if (insertSku >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u79d2\u6740\u5355\u54c1\u8868\u5931\u8d25\uff0cinsert\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0ckillCycleId=[" + skuPO.getKillCycleId() + "]\uff0cskuId=[" + skuPO.getSkuId() + "]");
            }
            throw new BusinessException("6016", "\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u79d2\u6740\u6d3b\u52a8\u521b\u5efa\u6210\u529f");
        return rspBO;
    }
}

